/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.hash.HashMapper;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.HandlerType;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.StreamHandler;
import wiki.xsx.core.handler.TransactionHandler;

public class HandlerManagerProxy {
    private final HandlerManager manager = new HandlerManager();

    public <T extends RedisHandler> T getHandler(HandlerType type) {
        return (T)this.manager.getHandler(this.manager.getDefaultKey(), type);
    }

    public <T extends RedisHandler> T getHandler(String key, HandlerType type) {
        return (T)this.manager.getHandler(key, type);
    }

    public <T extends RedisHandler> T getHandler(TransactionHandler transactionHandler, HandlerType type) {
        return (T)this.manager.getHandler(transactionHandler, type);
    }

    public StreamHandler getStreamHandler(int dbIndex, HashMapper<String, String, Object> mapper) {
        return new StreamHandler(dbIndex, mapper);
    }

    public RedisTemplate<String, Object> getDefaultRedisTemplate() {
        return this.manager.getDefaultRedisTemplate();
    }

    public StringRedisTemplate getDefaultStringRedisTemplate() {
        return this.manager.getDefaultStringRedisTemplate();
    }
}

