/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.List;
import org.springframework.data.redis.core.HyperLogLogOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;

public final class HyperLogLogHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private HyperLogLogOperations<String, Object> hyperLogLogOperations;
    private HyperLogLogOperations<String, String> stringHyperLogLogOperations;

    HyperLogLogHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.hyperLogLogOperations = this.redisTemplate.opsForHyperLogLog();
        this.stringHyperLogLogOperations = this.stringRedisTemplate.opsForHyperLogLog();
    }

    HyperLogLogHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.hyperLogLogOperations = this.redisTemplate.opsForHyperLogLog();
        this.stringHyperLogLogOperations = this.stringRedisTemplate.opsForHyperLogLog();
    }

    public Long addAsObj(String key, Object ... values) {
        return this.hyperLogLogOperations.add((Object)key, values);
    }

    public Long add(String key, String ... values) {
        return this.stringHyperLogLogOperations.add((Object)key, (Object[])values);
    }

    public Long sizeAsObj(String ... keys) {
        return this.hyperLogLogOperations.size((Object[])keys);
    }

    public Long size(String ... keys) {
        return this.stringHyperLogLogOperations.size((Object[])keys);
    }

    public Long unionAsObj(String key, String ... otherKeys) {
        return this.hyperLogLogOperations.union((Object)key, (Object[])otherKeys);
    }

    public Long union(String key, String ... otherKeys) {
        return this.stringHyperLogLogOperations.union((Object)key, (Object[])otherKeys);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

