/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.support.atomic.RedisAtomicDouble;
import org.springframework.data.redis.support.atomic.RedisAtomicInteger;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;

public final class NumberHandler
implements RedisHandler {
    private StringRedisTemplate stringRedisTemplate;
    private ValueOperations<String, String> stringOperations;
    private HashOperations<String, String, String> stringHashOperations;
    private int dbIndex;

    NumberHandler(Integer dbIndex) {
        this.dbIndex = dbIndex;
        this.stringRedisTemplate = HandlerManager.createStringRedisTemplate(dbIndex);
        this.stringOperations = this.stringRedisTemplate.opsForValue();
        this.stringHashOperations = this.stringRedisTemplate.opsForHash();
    }

    NumberHandler(TransactionHandler transactionHandler) {
        this.dbIndex = transactionHandler.getDbIndex();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.stringOperations = this.stringRedisTemplate.opsForValue();
        this.stringHashOperations = this.stringRedisTemplate.opsForHash();
    }

    public RedisAtomicDouble getAtomicDouble(String key) {
        return new RedisAtomicDouble(key, HandlerManager.getConnectionFactory(this.dbIndex));
    }

    public RedisAtomicLong getAtomicLong(String key) {
        return new RedisAtomicLong(key, HandlerManager.getConnectionFactory(this.dbIndex));
    }

    public RedisAtomicInteger getAtomicInteger(String key) {
        return new RedisAtomicInteger(key, HandlerManager.getConnectionFactory(this.dbIndex));
    }

    public void setDouble(String key, double value) {
        this.stringOperations.set((Object)key, (Object)String.valueOf(value));
    }

    public void setDouble(String key, String hashKey, double value) {
        this.stringHashOperations.put((Object)key, (Object)hashKey, (Object)String.valueOf(value));
    }

    public void setDouble(String key, double value, long timeout, TimeUnit unit) {
        this.stringOperations.set((Object)key, (Object)String.valueOf(value), timeout, unit);
    }

    public Boolean setDoubleIfAbsent(String key, double value) {
        return this.stringOperations.setIfAbsent((Object)key, (Object)String.valueOf(value));
    }

    public Boolean setDoubleIfAbsent(String key, String hashKey, double value) {
        return this.stringHashOperations.putIfAbsent((Object)key, (Object)hashKey, (Object)String.valueOf(value));
    }

    public Boolean setDoubleIfAbsent(String key, double value, long timeout, TimeUnit unit) {
        return this.stringOperations.setIfAbsent((Object)key, (Object)String.valueOf(value), timeout, unit);
    }

    public Double getDouble(String key) {
        String value = (String)this.stringOperations.get((Object)key);
        if (value != null) {
            return Double.valueOf(value);
        }
        return null;
    }

    public Double getDouble(String key, String hashKey) {
        String value = (String)this.stringHashOperations.get((Object)key, (Object)hashKey);
        if (value != null) {
            return Double.valueOf(value);
        }
        return null;
    }

    public Double getAndSetDouble(String key, double newValue) {
        String value = (String)this.stringOperations.getAndSet((Object)key, (Object)String.valueOf(newValue));
        return value != null ? Double.valueOf(value) : null;
    }

    public Double getAndSetDouble(String key, String hashKey, double newValue) {
        Double value = this.getDouble(key, hashKey);
        this.setDouble(key, hashKey, newValue);
        return value;
    }

    public Double addDouble(String key, double data) {
        return this.stringOperations.increment((Object)key, data);
    }

    public synchronized Double addDoubleBySync(String key, double data) {
        Double old = this.getDouble(key);
        double value = new BigDecimal(old == null ? "0" : Double.toString(old)).add(new BigDecimal(Double.toString(data))).doubleValue();
        this.setDouble(key, value);
        return value;
    }

    public Double addDouble(String key, String hashKey, double data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, data);
    }

    public synchronized Double addDoubleBySync(String key, String hashKey, double data) {
        Double old = this.getDouble(key, hashKey);
        double value = new BigDecimal(old == null ? "0" : Double.toString(old)).add(new BigDecimal(Double.toString(data))).doubleValue();
        this.setDouble(key, hashKey, value);
        return value;
    }

    public Double getAndAddDouble(String key, double data) {
        return new BigDecimal(Double.toString(this.addDouble(key, data))).subtract(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public synchronized Double getAndAddDoubleBySync(String key, double data) {
        return new BigDecimal(Double.toString(this.addDoubleBySync(key, data))).subtract(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public Double getAndAddDouble(String key, String hashKey, double data) {
        return new BigDecimal(Double.toString(this.addDouble(key, hashKey, data))).subtract(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public synchronized Double getAndAddDoubleBySync(String key, String hashKey, double data) {
        return new BigDecimal(Double.toString(this.addDoubleBySync(key, hashKey, data))).subtract(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public Double subtractDouble(String key, double data) {
        return this.addDouble(key, -data);
    }

    public synchronized Double subtractDoubleBySync(String key, double data) {
        return this.addDoubleBySync(key, -data);
    }

    public Double subtractDouble(String key, String hashKey, double data) {
        return this.addDouble(key, hashKey, -data);
    }

    public synchronized Double subtractDoubleBySync(String key, String hashKey, double data) {
        return this.addDoubleBySync(key, hashKey, -data);
    }

    public Double getAndSubtractDouble(String key, double data) {
        return new BigDecimal(Double.toString(this.subtractDouble(key, data))).add(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public synchronized Double getAndSubtractDoubleBySync(String key, double data) {
        return new BigDecimal(Double.toString(this.subtractDoubleBySync(key, data))).add(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public Double getAndSubtractDouble(String key, String hashKey, double data) {
        return new BigDecimal(Double.toString(this.subtractDouble(key, hashKey, data))).add(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public synchronized Double getAndSubtractDoubleBySync(String key, String hashKey, double data) {
        return new BigDecimal(Double.toString(this.subtractDoubleBySync(key, hashKey, data))).add(new BigDecimal(Double.toString(data))).doubleValue();
    }

    public void setLong(String key, long value) {
        this.stringOperations.set((Object)key, (Object)String.valueOf(value));
    }

    public void setLong(String key, String hashKey, long value) {
        this.stringHashOperations.put((Object)key, (Object)hashKey, (Object)String.valueOf(value));
    }

    public void setLong(String key, long value, long timeout, TimeUnit unit) {
        this.stringOperations.set((Object)key, (Object)String.valueOf(value), timeout, unit);
    }

    public Boolean setLongIfAbsent(String key, long value) {
        return this.stringOperations.setIfAbsent((Object)key, (Object)String.valueOf(value));
    }

    public Boolean setLongIfAbsent(String key, String hashKey, long value) {
        return this.stringHashOperations.putIfAbsent((Object)key, (Object)hashKey, (Object)String.valueOf(value));
    }

    public Boolean setLongIfAbsent(String key, long value, long timeout, TimeUnit unit) {
        return this.stringOperations.setIfAbsent((Object)key, (Object)String.valueOf(value), timeout, unit);
    }

    public Long getLong(String key) {
        String value = (String)this.stringOperations.get((Object)key);
        if (value != null) {
            return Long.valueOf(value);
        }
        return null;
    }

    public Long getLong(String key, String hashKey) {
        String value = (String)this.stringHashOperations.get((Object)key, (Object)hashKey);
        if (value != null) {
            return Long.valueOf(value);
        }
        return null;
    }

    public Long getAndSetLong(String key, long newValue) {
        String value = (String)this.stringOperations.getAndSet((Object)key, (Object)String.valueOf(newValue));
        return value != null ? Long.valueOf(value) : null;
    }

    public Long getAndSetLong(String key, String hashKey, long newValue) {
        Long value = this.getLong(key, hashKey);
        this.setLong(key, hashKey, newValue);
        return value;
    }

    public Long addLong(String key, long data) {
        return this.stringOperations.increment((Object)key, data);
    }

    public Long addLong(String key, String hashKey, long data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, data);
    }

    public Long getAndAddLong(String key, long data) {
        return this.addLong(key, data) - data;
    }

    public Long getAndAddLong(String key, String hashKey, long data) {
        return this.addLong(key, hashKey, data) - data;
    }

    public Long incrementLong(String key) {
        return this.stringOperations.increment((Object)key);
    }

    public Long incrementLong(String key, String hashKey) {
        return this.addLong(key, hashKey, 1L);
    }

    public Long getAndIncrementLong(String key) {
        return this.incrementLong(key) - 1L;
    }

    public Long getAndIncrementLong(String key, String hashKey) {
        return this.incrementLong(key, hashKey) - 1L;
    }

    public Long subtractLong(String key, long data) {
        return this.stringOperations.decrement((Object)key, data);
    }

    public Long subtractLong(String key, String hashKey, long data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, -data);
    }

    public Long getAndSubtractLong(String key, long data) {
        return this.subtractLong(key, data) + data;
    }

    public Long getAndSubtractLong(String key, String hashKey, long data) {
        return this.subtractLong(key, hashKey, data) + data;
    }

    public Long decrementLong(String key) {
        return this.stringOperations.decrement((Object)key);
    }

    public Long decrementLong(String key, String hashKey) {
        return this.subtractLong(key, hashKey, 1L);
    }

    public Long getAndDecrementLong(String key) {
        return this.decrementLong(key) + 1L;
    }

    public Long getAndDecrementLong(String key, String hashKey) {
        return this.decrementLong(key, hashKey) + 1L;
    }

    public Long removeForValue(String ... keys) {
        return this.stringOperations.getOperations().delete(Arrays.asList(keys));
    }

    public Long removeForHash(String key, String ... hashKeys) {
        return this.stringHashOperations.delete((Object)key, (Object[])hashKeys);
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

