/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class SetHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private SetOperations<String, Object> setOperations;
    private SetOperations<String, String> stringSetOperations;

    SetHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.setOperations = this.redisTemplate.opsForSet();
        this.stringSetOperations = this.stringRedisTemplate.opsForSet();
    }

    SetHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.setOperations = this.redisTemplate.opsForSet();
        this.stringSetOperations = this.stringRedisTemplate.opsForSet();
    }

    public Long addAsObj(String key, Object ... values) {
        return this.setOperations.add((Object)key, values);
    }

    public Long add(String key, String ... values) {
        return this.stringSetOperations.add((Object)key, (Object[])values);
    }

    public <T> T popAsObj(String key) {
        return (T)ConvertUtil.toJavaType(this.setOperations.pop((Object)key), Object.class);
    }

    public <T> T popAsObj(Class<T> type, String key) {
        return (T)ConvertUtil.toJavaType(this.setOperations.pop((Object)key), type);
    }

    public String pop(String key) {
        return (String)this.stringSetOperations.pop((Object)key);
    }

    public List popAsObj(String key, Long count) {
        return this.setOperations.pop((Object)key, count.longValue());
    }

    public List<String> pop(String key, Long count) {
        return this.stringSetOperations.pop((Object)key, count.longValue());
    }

    public Long removeAsObj(String key, Object ... values) {
        return this.setOperations.remove((Object)key, values);
    }

    public Long remove(String key, String ... values) {
        return this.stringSetOperations.remove((Object)key, (Object[])values);
    }

    public Boolean moveAsObj(String key, String destKey, Object value) {
        return this.setOperations.move((Object)key, value, (Object)destKey);
    }

    public Boolean move(String key, String destKey, String value) {
        return this.stringSetOperations.move((Object)key, (Object)value, (Object)destKey);
    }

    public Long sizeAsObj(String key) {
        return this.setOperations.size((Object)key);
    }

    public Long size(String key) {
        return this.stringSetOperations.size((Object)key);
    }

    public Boolean containsAsObj(String key, Object value) {
        return this.setOperations.isMember((Object)key, value);
    }

    public Boolean contains(String key, String value) {
        return this.stringSetOperations.isMember((Object)key, (Object)value);
    }

    public Set distinctRandomMembersAsObj(String key, Long count) {
        return this.setOperations.distinctRandomMembers((Object)key, count.longValue());
    }

    public Set<String> distinctRandomMembers(String key, Long count) {
        return this.stringSetOperations.distinctRandomMembers((Object)key, count.longValue());
    }

    public List randomMembersAsObj(String key, Long count) {
        return this.setOperations.randomMembers((Object)key, count.longValue());
    }

    public List<String> randomMembers(String key, Long count) {
        return this.stringSetOperations.randomMembers((Object)key, count.longValue());
    }

    public <T> T randomMemberAsObj(String key) {
        return (T)ConvertUtil.toJavaType(this.setOperations.randomMember((Object)key), Object.class);
    }

    public <T> T randomMemberAsObj(Class<T> type, String key) {
        return (T)ConvertUtil.toJavaType(this.setOperations.randomMember((Object)key), type);
    }

    public String randomMember(String key) {
        return (String)this.stringSetOperations.randomMember((Object)key);
    }

    public Set membersAsObj(String key) {
        return this.setOperations.members((Object)key);
    }

    public Set<String> members(String key) {
        return this.stringSetOperations.members((Object)key);
    }

    public Set differenceAsObj(String key, String ... otherKys) {
        return this.setOperations.difference((Object)key, Arrays.asList(otherKys));
    }

    public Set<String> difference(String key, String ... otherKys) {
        return this.stringSetOperations.difference((Object)key, Arrays.asList(otherKys));
    }

    public Long differenceAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.setOperations.differenceAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long differenceAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringSetOperations.differenceAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Set intersectAsObj(String key, String ... otherKys) {
        return this.setOperations.intersect((Object)key, Arrays.asList(otherKys));
    }

    public Set<String> intersect(String key, String ... otherKys) {
        return this.stringSetOperations.intersect((Object)key, Arrays.asList(otherKys));
    }

    public Long intersectAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.setOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long intersectAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringSetOperations.intersectAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Set unionAsObj(String key, String ... otherKys) {
        return this.setOperations.union((Object)key, Arrays.asList(otherKys));
    }

    public Set<String> union(String key, String ... otherKys) {
        return this.stringSetOperations.union((Object)key, Arrays.asList(otherKys));
    }

    public Long unionAndStoreAsObj(String key, String storeKey, String ... otherKys) {
        return this.setOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Long unionAndStore(String key, String storeKey, String ... otherKys) {
        return this.stringSetOperations.unionAndStore((Object)key, Arrays.asList(otherKys), (Object)storeKey);
    }

    public Cursor scanAsObj(String key, Long count, String pattern) {
        return this.setOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public Cursor<String> scan(String key, Long count, String pattern) {
        return this.stringSetOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

