/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.handler;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import wiki.xsx.core.handler.HandlerManager;
import wiki.xsx.core.handler.RedisHandler;
import wiki.xsx.core.handler.TransactionHandler;
import wiki.xsx.core.util.ConvertUtil;

public final class StringHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private ValueOperations<String, Object> operations;
    private ValueOperations<String, String> stringOperations;

    StringHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.operations = this.redisTemplate.opsForValue();
        this.stringOperations = this.stringRedisTemplate.opsForValue();
    }

    StringHandler(TransactionHandler transactionHandler) {
        this.redisTemplate = transactionHandler.getRedisTemplate();
        this.stringRedisTemplate = transactionHandler.getStringRedisTemplate();
        this.operations = this.redisTemplate.opsForValue();
        this.stringOperations = this.stringRedisTemplate.opsForValue();
    }

    public Long removeAsObj(String ... keys) {
        return this.operations.getOperations().delete(Arrays.asList(keys));
    }

    public Long remove(String ... keys) {
        return this.stringOperations.getOperations().delete(Arrays.asList(keys));
    }

    public void setAsObj(String key, Object value) {
        this.operations.set((Object)key, value);
    }

    public void set(String key, String value) {
        this.stringOperations.set((Object)key, (Object)value);
    }

    public void setAsObj(String key, Object value, long timeout, TimeUnit unit) {
        this.operations.set((Object)key, value, timeout, unit);
    }

    public void set(String key, String value, long timeout, TimeUnit unit) {
        this.stringOperations.set((Object)key, (Object)value, timeout, unit);
    }

    public void msetAsObj(Map<String, Object> map) {
        this.operations.multiSet(map);
    }

    public void mset(Map<String, String> map) {
        this.stringOperations.multiSet(map);
    }

    public void append(String key, String value) {
        this.stringOperations.append((Object)key, value);
    }

    public Boolean setIfAbsentAsObj(String key, Object value, long timeout, TimeUnit unit) {
        return this.operations.setIfAbsent((Object)key, value, timeout, unit);
    }

    public Boolean setIfAbsent(String key, String value, long timeout, TimeUnit unit) {
        return this.stringOperations.setIfAbsent((Object)key, (Object)value, timeout, unit);
    }

    public Boolean setIfAbsentAsObj(String key, Object value) {
        return this.operations.setIfAbsent((Object)key, value);
    }

    public Boolean setIfAbsent(String key, String value) {
        return this.stringOperations.setIfAbsent((Object)key, (Object)value);
    }

    public Boolean msetIfAbsentAsObj(Map<String, Object> map) {
        return this.operations.multiSetIfAbsent(map);
    }

    public Boolean msetIfAbsent(Map<String, String> map) {
        return this.stringOperations.multiSetIfAbsent(map);
    }

    public <T> T getAsObj(String key) {
        return (T)ConvertUtil.toJavaType(this.operations.get((Object)key), Object.class);
    }

    public <T> T getAsObj(Class<T> type, String key) {
        return (T)ConvertUtil.toJavaType(this.operations.get((Object)key), type);
    }

    public String get(String key) {
        return (String)this.stringOperations.get((Object)key);
    }

    public <T> T getAndSetAsObj(String key, Object value) {
        return (T)ConvertUtil.toJavaType(this.operations.getAndSet((Object)key, value), Object.class);
    }

    public <T> T getAndSetAsObj(Class<T> type, String key, Object value) {
        return (T)ConvertUtil.toJavaType(this.operations.getAndSet((Object)key, value), type);
    }

    public String getAndSet(String key, String value) {
        return (String)this.stringOperations.getAndSet((Object)key, (Object)value);
    }

    public List mgetAsObj(String ... keys) {
        return this.operations.multiGet(Arrays.asList(keys));
    }

    public List<String> mget(String ... keys) {
        return this.stringOperations.multiGet(Arrays.asList(keys));
    }

    public Long length(String key) {
        return this.stringOperations.size((Object)key);
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

