/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.log;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wiki.xsx.core.log.Level;
import wiki.xsx.core.log.Log;
import wiki.xsx.core.log.ParamLog;
import wiki.xsx.core.log.Position;
import wiki.xsx.core.log.ResultLog;
import wiki.xsx.core.log.ThrowingLog;
import wiki.xsx.core.support.ArrayType;
import wiki.xsx.core.support.MethodInfo;
import wiki.xsx.core.support.MethodParser;

@Aspect
public class LogProcessor {
    private static final Logger log = LoggerFactory.getLogger(LogProcessor.class);
    private static final int LINE_NUMBER = -2;

    @Before(value="@annotation(ParamLog)")
    public void beforPrint(JoinPoint joinPoint) {
        if (this.isEnable()) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            ParamLog annotation = signature.getMethod().getAnnotation(ParamLog.class);
            this.beforPrint(signature, joinPoint.getArgs(), annotation.value(), annotation.level(), annotation.position());
        }
    }

    @AfterReturning(value="@annotation(ResultLog)", returning="result")
    public void afterPrint(JoinPoint joinPoint, Object result) {
        if (this.isEnable()) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            ResultLog annotation = signature.getMethod().getAnnotation(ResultLog.class);
            this.afterPrint(signature, result, annotation.value(), annotation.level(), annotation.position());
        }
    }

    @AfterThrowing(value="@annotation(ThrowingLog)||@annotation(Log)", throwing="throwable")
    public void throwingPrint(JoinPoint joinPoint, Throwable throwable) {
        if (this.isEnable()) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            String methodName = method.getName();
            try {
                ThrowingLog annotation = method.getAnnotation(ThrowingLog.class);
                if (annotation != null) {
                    log.error(this.getThrowingInfo(annotation.value(), MethodParser.getMethodInfo(signature, -2)), throwable);
                } else {
                    log.error(this.getThrowingInfo(method.getAnnotation(Log.class).value(), MethodParser.getMethodInfo(signature, -2)), throwable);
                }
            }
            catch (Exception e) {
                log.error("{}.{}\u65b9\u6cd5\u9519\u8bef", (Object)signature.getDeclaringTypeName(), (Object)methodName);
            }
        }
    }

    @Around(value="@annotation(Log)")
    public Object aroundPrint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Object[] args = joinPoint.getArgs();
        Object result = joinPoint.proceed(args);
        if (this.isEnable()) {
            Log annotation = signature.getMethod().getAnnotation(Log.class);
            this.beforPrint(signature, args, annotation.value(), annotation.level(), annotation.position());
            this.afterPrint(signature, result, annotation.value(), annotation.level(), annotation.position());
        }
        return result;
    }

    private void beforPrint(MethodSignature signature, Object[] args, String busName, Level level, Position position) {
        Method method = signature.getMethod();
        String methodName = method.getName();
        try {
            if (log.isDebugEnabled()) {
                if (position == Position.DEFAULT || position == Position.ENABLED) {
                    this.print(level, this.getBeforeInfo(busName, MethodParser.getMethodInfo(signature.getDeclaringTypeName(), methodName, signature.getParameterNames()), args));
                } else {
                    this.print(level, this.getBeforeInfo(busName, MethodParser.getMethodInfo(signature, -2), args));
                }
            } else if (position == Position.ENABLED) {
                this.print(level, this.getBeforeInfo(busName, MethodParser.getMethodInfo(signature.getDeclaringTypeName(), methodName, signature.getParameterNames()), args));
            } else {
                this.print(level, this.getBeforeInfo(busName, MethodParser.getMethodInfo(signature, -2), args));
            }
        }
        catch (Exception e) {
            log.error("{}.{}\u65b9\u6cd5\u9519\u8bef", (Object)signature.getDeclaringTypeName(), (Object)methodName);
        }
    }

    private void afterPrint(MethodSignature signature, Object result, String busName, Level level, Position position) {
        Method method = signature.getMethod();
        String methodName = method.getName();
        try {
            if (log.isDebugEnabled()) {
                if (position == Position.DEFAULT || position == Position.ENABLED) {
                    this.print(level, this.getAfterInfo(busName, MethodParser.getMethodInfo(signature.getDeclaringTypeName(), methodName, signature.getParameterNames()), result));
                } else {
                    this.print(level, this.getAfterInfo(busName, MethodParser.getMethodInfo(signature, -2), result));
                }
            } else if (position == Position.ENABLED) {
                this.print(level, this.getAfterInfo(busName, MethodParser.getMethodInfo(signature.getDeclaringTypeName(), methodName, signature.getParameterNames()), result));
            } else {
                this.print(level, this.getAfterInfo(busName, MethodParser.getMethodInfo(signature, -2), result));
            }
        }
        catch (Exception e) {
            log.error("{}.{}\u65b9\u6cd5\u9519\u8bef", (Object)signature.getDeclaringTypeName(), (Object)methodName);
        }
    }

    private String getBeforeInfo(String busName, MethodInfo methodInfo, Object[] params) {
        StringBuilder builder = this.createInfoBuilder(methodInfo);
        builder.append("\u3011\uff0c").append("\u4e1a\u52a1\u540d\u79f0\uff1a\u3010").append(busName).append("\u3011\uff0c").append("\u63a5\u6536\u53c2\u6570\uff1a\u3010");
        List<String> paramNames = methodInfo.getParamNames();
        int count = paramNames.size();
        if (count > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(count);
            for (int i = 0; i < count; ++i) {
                paramMap.put(paramNames.get(i), this.getParam(params[i]));
            }
            return builder.append(paramMap).append("\u3011").toString();
        }
        return builder.append("{}\u3011").toString();
    }

    private String getAfterInfo(String busName, MethodInfo methodInfo, Object result) {
        return this.createInfoBuilder(methodInfo).append("\u3011\uff0c").append("\u4e1a\u52a1\u540d\u79f0\uff1a\u3010").append(busName).append("\u3011\uff0c").append("\u8fd4\u56de\u7ed3\u679c\uff1a\u3010").append(result).append("\u3011").toString();
    }

    private String getThrowingInfo(String busName, MethodInfo methodInfo) {
        return this.createInfoBuilder(methodInfo).append("\u3011\uff0c").append("\u4e1a\u52a1\u540d\u79f0\uff1a\u3010").append(busName).append("\u3011\uff0c").append("\u5f02\u5e38\u4fe1\u606f\uff1a").toString();
    }

    private StringBuilder createInfoBuilder(MethodInfo methodInfo) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u8c03\u7528\u65b9\u6cd5\uff1a\u3010");
        if (methodInfo.getLineNumber() == -2) {
            builder.append(methodInfo.getClassAllName()).append(".").append(methodInfo.getMethodName());
        } else {
            builder.append(this.createMethodStack(methodInfo));
        }
        return builder;
    }

    private Object getParam(Object param) {
        Class<?> type = param.getClass();
        return type.isArray() ? this.getList(type, param) : param;
    }

    private List<Object> getList(Class valueType, Object value) {
        if (valueType.isAssignableFrom(ArrayType.OBJECT_ARRAY.getType())) {
            Object[] array = (Object[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            Collections.addAll(list, array);
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.INT_ARRAY.getType())) {
            int[] array = (int[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (int v : array) {
                list.add(v);
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.LONG_ARRAY.getType())) {
            long[] array = (long[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (long v : array) {
                list.add(v);
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.DOUBLE_ARRAY.getType())) {
            double[] array = (double[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (double v : array) {
                list.add(v);
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.FLOAT_ARRAY.getType())) {
            float[] array = (float[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (float v : array) {
                list.add(Float.valueOf(v));
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.CHAR_ARRAY.getType())) {
            char[] array = (char[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (char v : array) {
                list.add(Character.valueOf(v));
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.BOOLEAN_ARRAY.getType())) {
            boolean[] array = (boolean[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (boolean v : array) {
                list.add(v);
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.BYTE_ARRAY.getType())) {
            byte[] array = (byte[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (byte v : array) {
                list.add(v);
            }
            return list;
        }
        if (valueType.isAssignableFrom(ArrayType.SHORT_ARRAY.getType())) {
            short[] array = (short[])value;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (short v : array) {
                list.add(v);
            }
            return list;
        }
        return null;
    }

    private StackTraceElement createMethodStack(MethodInfo methodInfo) {
        return new StackTraceElement(methodInfo.getClassAllName(), methodInfo.getMethodName(), String.format("%s.java", methodInfo.getClassSimpleName()), methodInfo.getLineNumber());
    }

    private void print(Level level, String msg) {
        switch (level) {
            case DEBUG: {
                log.debug(msg);
                break;
            }
            case INFO: {
                log.info(msg);
                break;
            }
            case WARN: {
                log.warn(msg);
                break;
            }
            case ERROR: {
                log.error(msg);
                break;
            }
        }
    }

    private boolean isEnable() {
        return log.isDebugEnabled() || log.isInfoEnabled() || log.isWarnEnabled() || log.isErrorEnabled() || log.isTraceEnabled();
    }
}

