/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.component;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.component.XEasyPdfTemplateComponentParam;
import wiki.xsx.core.pdf.template.enums.XEasyPdfTemplatePositionStyle;

public interface XEasyPdfTemplateComponent {
    public Element createElement(Document var1);

    default public Element createEmptyElement(Document document) {
        return document.createElement("fo:block");
    }

    default public Element createBlockElement(Document document, XEasyPdfTemplateComponentParam param) {
        XEasyPdfTemplatePositionStyle style;
        Element block = this.createEmptyElement(document);
        if (param.getHasBorder() != null) {
            block.setAttribute("border", "1px solid black");
        }
        if (param.getHorizontalStyle() != null && (style = param.getHorizontalStyle()).isHorizontalStyle()) {
            block.setAttribute(style.getKey(), style.getValue());
        }
        if (param.getVerticalStyle() != null && (style = param.getVerticalStyle()).isVerticalStyle()) {
            block.setAttribute(style.getKey(), style.getValue());
        }
        if (param.getPaddingTop() != null) {
            block.setAttribute("padding-top", param.getPaddingTop());
        }
        if (param.getPaddingBottom() != null) {
            block.setAttribute("padding-bottom", param.getPaddingBottom());
        }
        if (param.getPaddingLeft() != null) {
            block.setAttribute("padding-left", param.getPaddingLeft());
        }
        if (param.getPaddingRight() != null) {
            block.setAttribute("padding-right", param.getPaddingRight());
        }
        return block;
    }

    default public Element transform(Document document) {
        Element element = this.createElement(document);
        return element != null ? element : this.createEmptyElement(document);
    }
}

