/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.component.image;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.component.XEasyPdfTemplateComponent;
import wiki.xsx.core.pdf.template.component.image.XEasyPdfTemplateImageParam;
import wiki.xsx.core.pdf.template.enums.XEasyPdfTemplatePositionStyle;

public class XEasyPdfTemplateImage
implements XEasyPdfTemplateComponent {
    private final XEasyPdfTemplateImageParam param = new XEasyPdfTemplateImageParam();

    public XEasyPdfTemplateImage setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public XEasyPdfTemplateImage setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public XEasyPdfTemplateImage setPath(String path) {
        this.param.setPath(path);
        return this;
    }

    public XEasyPdfTemplateImage setHorizontalStyle(XEasyPdfTemplatePositionStyle style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateImage enableRemote() {
        this.param.setIsRemote(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateImage enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getPath() == null) {
            return null;
        }
        Element block = this.createBlockElement(document, this.param);
        Element externalGraphic = this.createExternalGraphic(document);
        block.appendChild(externalGraphic);
        return block;
    }

    private Element createExternalGraphic(Document document) {
        Element externalGraphic = document.createElement("fo:external-graphic");
        if (this.param.getWidth() != null) {
            externalGraphic.setAttribute("content-width", this.param.getWidth());
        }
        if (this.param.getHeight() != null) {
            externalGraphic.setAttribute("content-height", this.param.getHeight());
        }
        externalGraphic.setAttribute("src", this.param.getIsRemote() != null ? this.param.getPath() : new File(this.param.getPath()).toURI().getPath());
        return externalGraphic;
    }
}

