/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.component.table;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.component.XEasyPdfTemplateComponent;
import wiki.xsx.core.pdf.template.component.table.XEasyPdfTemplateTableBody;
import wiki.xsx.core.pdf.template.component.table.XEasyPdfTemplateTableFooter;
import wiki.xsx.core.pdf.template.component.table.XEasyPdfTemplateTableHeader;
import wiki.xsx.core.pdf.template.component.table.XEasyPdfTemplateTableParam;
import wiki.xsx.core.pdf.template.enums.XEasyPdfTemplatePositionStyle;
import wiki.xsx.core.pdf.template.handler.XEasyPdfTemplateElementHandler;

public class XEasyPdfTemplateTable
implements XEasyPdfTemplateComponent {
    private final XEasyPdfTemplateTableParam param = new XEasyPdfTemplateTableParam();

    public XEasyPdfTemplateTable setHeader(XEasyPdfTemplateTableHeader header) {
        this.param.setHeader(header);
        return this;
    }

    public XEasyPdfTemplateTable setBody(XEasyPdfTemplateTableBody body) {
        this.param.setBody(body);
        return this;
    }

    public XEasyPdfTemplateTable setFooter(XEasyPdfTemplateTableFooter footer) {
        this.param.setFooter(footer);
        return this;
    }

    public XEasyPdfTemplateTable setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public XEasyPdfTemplateTable setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public XEasyPdfTemplateTable setBorder(String border) {
        this.param.setBorder(border);
        return this;
    }

    public XEasyPdfTemplateTable setBorderCollapse(String borderCollapse) {
        this.param.setBorderCollapse(borderCollapse);
        return this;
    }

    public XEasyPdfTemplateTable setBorderSpacing(String borderSpacing) {
        this.param.setBorderSpacing(borderSpacing);
        return this;
    }

    public XEasyPdfTemplateTable setHorizontalStyle(XEasyPdfTemplatePositionStyle horizontalStyle) {
        this.param.setHorizontalStyle(horizontalStyle);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createTable(document));
        return block;
    }

    private Element createTable(Document document) {
        Element table = document.createElement("fo:table");
        XEasyPdfTemplateElementHandler.appendChild(table, this.createTableHeader(document));
        XEasyPdfTemplateElementHandler.appendChild(table, this.createTableBody(document));
        XEasyPdfTemplateElementHandler.appendChild(table, this.createTableFooter(document));
        if (this.param.getPaddingTop() != null) {
            table.setAttribute("padding-top", this.param.getPaddingTop());
        }
        if (this.param.getWidth() != null) {
            table.setAttribute("width", this.param.getWidth());
        }
        if (this.param.getHeight() != null) {
            table.setAttribute("height", this.param.getHeight());
        }
        if (this.param.getBorder() != null) {
            table.setAttribute("border", this.param.getBorder());
        }
        if (this.param.getBorderCollapse() != null) {
            table.setAttribute("border-collapse", this.param.getBorderCollapse());
        }
        if (this.param.getBorderSpacing() != null) {
            table.setAttribute("border-spacing", this.param.getBorderSpacing());
        }
        return table;
    }

    private Element createTableHeader(Document document) {
        XEasyPdfTemplateTableHeader header = this.param.getHeader();
        return header == null ? null : header.createElement(document);
    }

    private Element createTableBody(Document document) {
        XEasyPdfTemplateTableBody body = this.param.getBody();
        if (body == null) {
            throw new IllegalArgumentException("the table body can not be null");
        }
        return body.createElement(document);
    }

    private Element createTableFooter(Document document) {
        XEasyPdfTemplateTableFooter footer = this.param.getFooter();
        return footer == null ? null : footer.createElement(document);
    }
}

