/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.component.table.XEasyPdfTemplateTableCell;
import wiki.xsx.core.pdf.template.component.table.XEasyPdfTemplateTableRowParam;

public class XEasyPdfTemplateTableRow {
    private final XEasyPdfTemplateTableRowParam param = new XEasyPdfTemplateTableRowParam();

    private XEasyPdfTemplateTableRow setInitialCapacity(int initialCapacity) {
        this.param.setCells(new ArrayList<XEasyPdfTemplateTableCell>(initialCapacity));
        return this;
    }

    public XEasyPdfTemplateTableRow setBorderStyle(String borderStyle) {
        this.param.setBorderStyle(borderStyle);
        return this;
    }

    public XEasyPdfTemplateTableRow addCell(XEasyPdfTemplateTableCell ... cells) {
        if (cells != null) {
            Collections.addAll(this.param.getCells(), cells);
        }
        return this;
    }

    public XEasyPdfTemplateTableRow addCell(List<XEasyPdfTemplateTableCell> cells) {
        if (cells != null) {
            this.param.getCells().addAll(cells);
        }
        return this;
    }

    public Element createElement(Document document) {
        Element tableRow = document.createElement("fo:table-row");
        List<XEasyPdfTemplateTableCell> cells = this.param.getCells();
        for (XEasyPdfTemplateTableCell cell : cells) {
            tableRow.appendChild(cell.init(this).createElement(document));
        }
        return tableRow;
    }

    XEasyPdfTemplateTableRowParam getParam() {
        return this.param;
    }
}

