/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.component.text;

import java.awt.Color;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.component.text.XEasyPdfTemplateTextBase;
import wiki.xsx.core.pdf.template.component.text.XEasyPdfTemplateTextBaseParam;
import wiki.xsx.core.pdf.template.component.text.XEasyPdfTemplateTextParam;
import wiki.xsx.core.pdf.template.enums.XEasyPdfTemplatePositionStyle;

public class XEasyPdfTemplateText
extends XEasyPdfTemplateTextBase {
    private final XEasyPdfTemplateTextParam param = new XEasyPdfTemplateTextParam();

    public XEasyPdfTemplateText setText(String text) {
        this.param.setText(text);
        return this;
    }

    public XEasyPdfTemplateText setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public XEasyPdfTemplateText setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public XEasyPdfTemplateText setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateText setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public XEasyPdfTemplateText setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTemplateText setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public XEasyPdfTemplateText setFontColor(Color fontColor) {
        this.param.setFontColor(fontColor);
        return this;
    }

    public XEasyPdfTemplateText setHorizontalStyle(XEasyPdfTemplatePositionStyle style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateText enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getText() == null) {
            return null;
        }
        Element block = this.initBlock(document, this.param);
        Element inline = this.createInline(document);
        block.appendChild(inline);
        return block;
    }

    XEasyPdfTemplateText init(XEasyPdfTemplateTextBaseParam param) {
        this.param.init(param);
        return this;
    }

    private Element createInline(Document document) {
        Element inline = document.createElement("fo:inline");
        if (this.param.getFontFamily() != null) {
            inline.setAttribute("font-family", this.param.getFontFamily());
        }
        if (this.param.getFontStyle() != null) {
            inline.setAttribute("font-style", this.param.getFontStyle());
        }
        if (this.param.getFontSize() != null) {
            inline.setAttribute("font-size", this.param.getFontSize());
        }
        if (this.param.getFontSizeAdjust() != null) {
            inline.setAttribute("font-size-adjust", this.param.getFontSizeAdjust());
        }
        if (this.param.getFontWeight() != null) {
            inline.setAttribute("font-weight", this.param.getFontWeight());
        }
        if (this.param.getFontColor() != null) {
            Color fontColor = this.param.getFontColor();
            inline.setAttribute("color", String.join((CharSequence)"", "rgb(", String.valueOf(fontColor.getRed()), ",", String.valueOf(fontColor.getGreen()), ",", String.valueOf(fontColor.getBlue()), ")"));
        }
        inline.setTextContent(this.param.getText());
        return inline;
    }
}

