/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc;

import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.template.doc.XEasyPdfTemplateDocumentParam;
import wiki.xsx.core.pdf.template.handler.XEasyPdfTemplateHandler;
import wiki.xsx.core.pdf.template.page.XEasyPdfTemplatePageComponent;
import wiki.xsx.core.pdf.template.template.XEasyPdfTemplate;

public class XEasyPdfTemplateDocument {
    private final XEasyPdfTemplateDocumentParam param = new XEasyPdfTemplateDocumentParam();

    public XEasyPdfTemplateDocument setConfigPath(String configPath) {
        this.param.setConfigPath(configPath);
        return this;
    }

    public XEasyPdfTemplateDocument addPage(XEasyPdfTemplatePageComponent ... pages) {
        if (pages != null) {
            Collections.addAll(this.param.getPageList(), pages);
        }
        return this;
    }

    public void transform(String outputPath) {
        try (FileOutputStream outputStream = new FileOutputStream(outputPath);){
            this.transform(outputStream);
        }
    }

    public void transform(OutputStream outputStream) {
        this.initTemplate().transform(outputStream);
    }

    public XEasyPdfDocument transform() {
        return this.initTemplate().transform();
    }

    public Document getDocument() {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getClass().getResourceAsStream("/wiki/xsx/core/pdf/template/template.fo"));
        Element root = document.getDocumentElement();
        int index = 0;
        for (XEasyPdfTemplatePageComponent page : this.param.getPageList()) {
            root.appendChild(page.transform(++index, document));
        }
        return document;
    }

    public String getContent() {
        return XEasyPdfTemplateHandler.DataSource.Document.build().setDocument(this.getDocument()).getDocumentContent();
    }

    private XEasyPdfTemplate initTemplate() {
        return XEasyPdfTemplateHandler.Template.build().setConfigPath(this.param.getConfigPath()).setDataSource(XEasyPdfTemplateHandler.DataSource.Document.build().setDocument(this.getDocument()));
    }
}

