/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.page;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wiki.xsx.core.pdf.template.component.XEasyPdfTemplateComponent;
import wiki.xsx.core.pdf.template.enums.XEasyPdfTemplateRegionStyle;
import wiki.xsx.core.pdf.template.page.XEasyPdfTemplatePageComponent;
import wiki.xsx.core.pdf.template.page.XEasyPdfTemplatePageParam;

public class XEasyPdfTemplatePage
implements XEasyPdfTemplatePageComponent {
    private final XEasyPdfTemplatePageParam param = new XEasyPdfTemplatePageParam();

    public XEasyPdfTemplatePage setPageWidth(String pageWidth) {
        if (pageWidth != null) {
            this.param.setPageWidth(pageWidth);
        }
        return this;
    }

    public XEasyPdfTemplatePage setPageHeight(String pageHeight) {
        if (pageHeight != null) {
            this.param.setPageHeight(pageHeight);
        }
        return this;
    }

    public XEasyPdfTemplatePage setPageMargin(String margin) {
        if (margin != null) {
            this.param.setMarginTop(margin).setMarginBottom(margin).setMarginLeft(margin).setMarginRight(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setPageMarginTop(String margin) {
        if (margin != null) {
            this.param.setMarginTop(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setPageMarginBottom(String margin) {
        if (margin != null) {
            this.param.setMarginBottom(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setPageMarginLeft(String margin) {
        if (margin != null) {
            this.param.setMarginLeft(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setPageMarginRight(String margin) {
        if (margin != null) {
            this.param.setMarginRight(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setBodyMargin(String margin) {
        if (margin != null) {
            this.param.getRegionBodyParam().setMarginTop(margin).setMarginBottom(margin).setMarginLeft(margin).setMarginRight(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setBodyMarginTop(String margin) {
        if (margin != null) {
            this.param.getRegionBodyParam().setMarginTop(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setBodyMarginBottom(String margin) {
        if (margin != null) {
            this.param.getRegionBodyParam().setMarginBottom(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setBodyMarginLeft(String margin) {
        if (margin != null) {
            this.param.getRegionBodyParam().setMarginLeft(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setBodyMarginRight(String margin) {
        if (margin != null) {
            this.param.getRegionBodyParam().setMarginRight(margin);
        }
        return this;
    }

    public XEasyPdfTemplatePage setHeaderHeight(String height) {
        if (height != null) {
            this.param.getRegionBeforeParam().setHeight(height);
        }
        return this;
    }

    public XEasyPdfTemplatePage setFooterHeight(String height) {
        if (height != null) {
            this.param.getRegionAfterParam().setHeight(height);
        }
        return this;
    }

    public XEasyPdfTemplatePage changeLandscape() {
        this.param.changeLandscape();
        return this;
    }

    public XEasyPdfTemplatePage addBodyComponent(XEasyPdfTemplateComponent ... components) {
        if (components != null) {
            Collections.addAll(this.param.getRegionBodyParam().getComponentList(), components);
        }
        return this;
    }

    public XEasyPdfTemplatePage addBodyComponent(List<XEasyPdfTemplateComponent> components) {
        if (components != null) {
            this.param.getRegionBodyParam().getComponentList().addAll(components);
        }
        return this;
    }

    public XEasyPdfTemplatePage addHeaderComponent(XEasyPdfTemplateComponent ... components) {
        if (components != null) {
            Collections.addAll(this.param.getRegionBeforeParam().getComponentList(), components);
        }
        return this;
    }

    public XEasyPdfTemplatePage addHeaderComponent(List<XEasyPdfTemplateComponent> components) {
        if (components != null) {
            this.param.getRegionBeforeParam().getComponentList().addAll(components);
        }
        return this;
    }

    public XEasyPdfTemplatePage addFooterComponent(XEasyPdfTemplateComponent ... components) {
        if (components != null) {
            Collections.addAll(this.param.getRegionAfterParam().getComponentList(), components);
        }
        return this;
    }

    public XEasyPdfTemplatePage addFooterComponent(List<XEasyPdfTemplateComponent> components) {
        if (components != null) {
            this.param.getRegionAfterParam().getComponentList().addAll(components);
        }
        return this;
    }

    @Override
    public Node transform(int index, Document document) {
        Element root = document.getDocumentElement();
        String masterName = this.addLayoutMasterSet(index, document, root);
        return this.addPageSequence(document, masterName);
    }

    private String addLayoutMasterSet(int index, Document document, Element root) {
        String masterName = "page" + index;
        Node layoutMasterSet = root.getElementsByTagName("fo:layout-master-set").item(0);
        layoutMasterSet.appendChild(this.createSimplePageMaster(document, masterName));
        return masterName;
    }

    private Element createSimplePageMaster(Document document, String masterName) {
        Element simplePageMaster = document.createElement("fo:simple-page-master");
        simplePageMaster.setAttribute("master-name", masterName);
        simplePageMaster.setAttribute("page-width", this.param.getPageWidth().intern());
        simplePageMaster.setAttribute("page-height", this.param.getPageHeight().intern());
        simplePageMaster.setAttribute("margin-top", this.param.getMarginTop().intern());
        simplePageMaster.setAttribute("margin-bottom", this.param.getMarginBottom().intern());
        simplePageMaster.setAttribute("margin-left", this.param.getMarginLeft().intern());
        simplePageMaster.setAttribute("margin-right", this.param.getMarginRight().intern());
        simplePageMaster.appendChild(this.createRegionBody(document));
        simplePageMaster.appendChild(this.createRegionBefore(document));
        simplePageMaster.appendChild(this.createRegionAfter(document));
        return simplePageMaster;
    }

    private Element createRegionBody(Document document) {
        Element regionBody = document.createElement("fo:region-body");
        regionBody.setAttribute("margin-top", this.param.getRegionBodyParam().getMarginTop().intern());
        regionBody.setAttribute("margin-bottom", this.param.getRegionBodyParam().getMarginBottom().intern());
        regionBody.setAttribute("margin-left", this.param.getRegionBodyParam().getMarginLeft().intern());
        regionBody.setAttribute("margin-right", this.param.getRegionBodyParam().getMarginRight().intern());
        return regionBody;
    }

    private Element createRegionBefore(Document document) {
        Element regionBefore = document.createElement("fo:region-before");
        regionBefore.setAttribute("extent", this.param.getRegionBeforeParam().getHeight().intern());
        return regionBefore;
    }

    private Element createRegionAfter(Document document) {
        Element regionAfter = document.createElement("fo:region-after");
        regionAfter.setAttribute("extent", this.param.getRegionAfterParam().getHeight().intern());
        return regionAfter;
    }

    private Element addPageSequence(Document document, String masterName) {
        Element pageSequence = document.createElement("fo:page-sequence");
        pageSequence.setAttribute("master-reference", masterName);
        pageSequence.appendChild(this.addRegionBody(document));
        if (this.param.hasHeader()) {
            pageSequence.appendChild(this.addRegionBefore(document));
        }
        if (this.param.hasFooter()) {
            pageSequence.appendChild(this.addRegionAfter(document));
        }
        return pageSequence;
    }

    private Element addRegionBody(Document document) {
        Element flow = document.createElement("fo:flow");
        flow.setAttribute("flow-name", XEasyPdfTemplateRegionStyle.BODY.getValue());
        if (this.param.hasBody()) {
            for (XEasyPdfTemplateComponent component : this.param.getRegionBodyParam().getComponentList()) {
                flow.appendChild(component.transform(document));
            }
        } else {
            flow.appendChild(document.createElement("fo:block"));
        }
        return flow;
    }

    private Element addRegionBefore(Document document) {
        Element staticContent = document.createElement("fo:static-content");
        staticContent.setAttribute("flow-name", XEasyPdfTemplateRegionStyle.BEFORE.getValue());
        for (XEasyPdfTemplateComponent component : this.param.getRegionBeforeParam().getComponentList()) {
            staticContent.appendChild(component.transform(document));
        }
        return staticContent;
    }

    private Element addRegionAfter(Document document) {
        Element staticContent = document.createElement("fo:static-content");
        staticContent.setAttribute("flow-name", XEasyPdfTemplateRegionStyle.AFTER.getValue());
        for (XEasyPdfTemplateComponent component : this.param.getRegionAfterParam().getComponentList()) {
            staticContent.appendChild(component.transform(document));
        }
        return staticContent;
    }
}

