/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.template;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.template.template.XEasyPdfTemplateParam;
import wiki.xsx.core.pdf.template.template.datasource.XEasyPdfTemplateDataSource;

public class XEasyPdfTemplate {
    private static final Log log = LogFactory.getLog(XEasyPdfTemplate.class);
    private final XEasyPdfTemplateParam param = new XEasyPdfTemplateParam();

    public XEasyPdfTemplate setConfigPath(String configPath) {
        this.param.setConfigPath(configPath);
        return this;
    }

    public XEasyPdfTemplate setDataSource(XEasyPdfTemplateDataSource dataSource) {
        this.param.setDataSource(dataSource);
        return this;
    }

    public XEasyPdfTemplate setAuthor(String author) {
        this.param.setAuthor(author);
        return this;
    }

    public XEasyPdfTemplate setCreator(String creator) {
        this.param.setCreator(creator);
        return this;
    }

    public XEasyPdfTemplate setTitle(String title) {
        this.param.setTitle(title);
        return this;
    }

    public XEasyPdfTemplate setSubject(String subject) {
        this.param.setSubject(subject);
        return this;
    }

    public XEasyPdfTemplate setKeywords(String keywords) {
        this.param.setKeywords(keywords);
        return this;
    }

    public XEasyPdfTemplate setCreationDate(Date date) {
        this.param.setCreationDate(date);
        return this;
    }

    public XEasyPdfTemplate enableAccessibility() {
        this.param.setIsAccessibility(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplate disableKeepEmptyTags() {
        this.param.setIsKeepEmptyTags(Boolean.FALSE);
        return this.enableAccessibility();
    }

    /*
     * Exception decompiling
     */
    public XEasyPdfDocument transform() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void transform(String outputPath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputPath));){
            this.transform(outputStream);
        }
    }

    public void transform(OutputStream outputStream) {
        FopFactory factory;
        this.param.init();
        try (InputStream inputStream = this.getClass().getResourceAsStream(this.param.getConfigPath());){
            factory = new FopFactoryBuilder(new File(".").toURI()).setConfiguration((Configuration)new DefaultConfigurationBuilder().build(inputStream)).build();
        }
        catch (Exception e) {
            try (InputStream inputStream2 = Files.newInputStream(Paths.get(this.param.getConfigPath(), new String[0]), new OpenOption[0]);){
                factory = new FopFactoryBuilder(new File(this.param.getConfigPath()).toURI()).setConfiguration((Configuration)new DefaultConfigurationBuilder().build(inputStream2)).build();
            }
        }
        FOUserAgent agent = this.getUserAgent(factory);
        if (log.isInfoEnabled()) {
            log.info((Object)("XSL-FO ==> \n" + this.param.getDataSource().getDocumentContent()));
        }
        this.param.getDataSource().transform(factory, agent, outputStream);
    }

    private FOUserAgent getUserAgent(FopFactory fopFactory) {
        FOUserAgent userAgent = fopFactory.newFOUserAgent();
        userAgent.setProducer("x-easypdf/fop");
        userAgent.setAccessibility(this.param.getIsAccessibility().booleanValue());
        userAgent.setAuthor(this.param.getAuthor());
        userAgent.setCreator(this.param.getCreator());
        userAgent.setTitle(this.param.getTitle());
        userAgent.setSubject(this.param.getSubject());
        userAgent.setKeywords(this.param.getKeywords());
        userAgent.setCreationDate(this.param.getCreationDate());
        userAgent.setKeepEmptyTags(this.param.getIsAccessibility().booleanValue());
        return userAgent;
    }
}

