/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.template.datasource;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import wiki.xsx.core.pdf.template.template.datasource.XEasyPdfTemplateDataSource;

public class XEasyPdfTemplateXMLDataSource
implements XEasyPdfTemplateDataSource {
    private String templatePath;
    private String xmlPath;

    @Override
    public Reader getSourceReader() {
        if (this.isNotEmptyData()) {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(this.xmlPath);
                return inputStream != null ? new InputStreamReader(inputStream, StandardCharsets.UTF_8) : new InputStreamReader(Files.newInputStream(Paths.get(this.xmlPath, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("the xml can not be loaded\uff0cthe path['" + this.xmlPath + "'] is error");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(FopFactory fopFactory, FOUserAgent foAgent, OutputStream outputStream) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(this.templatePath);){
            try {
                if (inputStream == null) {
                    inputStream = Files.newInputStream(Paths.get(this.templatePath, new String[0]), new OpenOption[0]);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("the template can not be loaded\uff0cthe path['" + this.templatePath + "'] is error");
            }
            try (InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(streamReader));
                try (Reader reader = this.getSourceReader();){
                    transformer.transform(new StreamSource(reader), new SAXResult(fopFactory.newFop("application/pdf", foAgent, outputStream).getDefaultHandler()));
                }
            }
        }
    }

    private boolean isNotEmptyData() {
        return this.xmlPath != null && this.xmlPath.length() > 0;
    }

    public XEasyPdfTemplateXMLDataSource setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
        return this;
    }

    public XEasyPdfTemplateXMLDataSource setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
        return this;
    }
}

