/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.template.XEasyPdfTemplateParam;
import wiki.xsx.core.pdf.template.datasource.XEasyPdfTemplateDataSource;

public class XEasyPdfTemplate {
    private static final Log log = LogFactory.getLog(XEasyPdfTemplate.class);
    private final XEasyPdfTemplateParam param = new XEasyPdfTemplateParam();

    public XEasyPdfTemplate setConfigPath(String configPath) {
        this.param.setConfigPath(configPath);
        return this;
    }

    public XEasyPdfTemplate setDataSource(XEasyPdfTemplateDataSource dataSource) {
        this.param.setDataSource(dataSource);
        return this;
    }

    public XEasyPdfTemplate setAuthor(String author) {
        this.param.setAuthor(author);
        return this;
    }

    public XEasyPdfTemplate setCreator(String creator) {
        this.param.setCreator(creator);
        return this;
    }

    public XEasyPdfTemplate setTitle(String title) {
        this.param.setTitle(title);
        return this;
    }

    public XEasyPdfTemplate setSubject(String subject) {
        this.param.setSubject(subject);
        return this;
    }

    public XEasyPdfTemplate setKeywords(String keywords) {
        this.param.setKeywords(keywords);
        return this;
    }

    public XEasyPdfTemplate setCreationDate(Date date) {
        this.param.setCreationDate(date);
        return this;
    }

    public XEasyPdfTemplate enableAccessibility() {
        this.param.setIsAccessibility(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplate disableKeepEmptyTags() {
        this.param.setIsKeepEmptyTags(Boolean.FALSE);
        return this.enableAccessibility();
    }

    public void save(String path) {
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            this.save(outputStream);
        }
    }

    public void save(OutputStream outputStream) {
        String content = this.param.getDataSource().getDocumentContent();
        if (log.isInfoEnabled()) {
            log.info((Object)("XSL-FO ==> \n" + content));
        }
        outputStream.write(content.getBytes());
    }

    /*
     * Exception decompiling
     */
    public XEasyPdfDocument transform() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void transform(String outputPath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(Paths.get(outputPath, new String[0]), new OpenOption[0]));){
            this.transform(outputStream);
        }
    }

    public void transform(OutputStream outputStream) {
        if (log.isInfoEnabled()) {
            log.info((Object)("XSL-FO ==> \n" + this.param.getDataSource().getDocumentContent()));
        }
        this.param.initParams();
        this.param.getDataSource().transform(this.param.getFopFactory(), this.param.getUserAgent(), outputStream);
    }
}

