/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Date;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfigurationBuilder;
import wiki.xsx.core.pdf.template.datasource.XEasyPdfTemplateDataSource;

class XEasyPdfTemplateParam {
    private String configPath;
    private String title;
    private String author;
    private String subject;
    private String keywords;
    private String creator;
    private Date creationDate;
    private FopFactory fopFactory;
    private FOUserAgent userAgent;
    private XEasyPdfTemplateDataSource dataSource;
    private Boolean isAccessibility = Boolean.FALSE;
    private Boolean isKeepEmptyTags = Boolean.TRUE;
    private Boolean isErrorInfo = Boolean.FALSE;

    void initParams() {
        if (this.configPath == null) {
            this.configPath = "/wiki/xsx/core/pdf/template/fop.xconf";
        }
        if (this.dataSource == null) {
            throw new IllegalArgumentException("the data source can not be null");
        }
        if (this.fopFactory == null) {
            this.fopFactory = this.initFopFactory();
        }
        if (this.userAgent == null) {
            this.userAgent = this.initUserAgent();
        }
    }

    FopFactory initFopFactory() {
        FopFactory factory;
        try (InputStream inputStream = this.getClass().getResourceAsStream(this.configPath);){
            factory = new FopFactoryBuilder(new File(".").toURI()).setConfiguration((Configuration)new DefaultConfigurationBuilder().build(inputStream)).build();
        }
        catch (Exception e) {
            try (InputStream inputStream2 = Files.newInputStream(Paths.get(this.configPath, new String[0]), new OpenOption[0]);){
                factory = new FopFactoryBuilder(new File(this.configPath).toURI()).setConfiguration((Configuration)new DefaultConfigurationBuilder().build(inputStream2)).build();
            }
        }
        return factory;
    }

    FOUserAgent initUserAgent() {
        FOUserAgent userAgent = this.fopFactory.newFOUserAgent();
        userAgent.setProducer("x-easypdf/fop");
        userAgent.setAccessibility(this.isAccessibility.booleanValue());
        userAgent.setAuthor(this.author);
        userAgent.setCreator(this.creator);
        userAgent.setTitle(this.title);
        userAgent.setSubject(this.subject);
        userAgent.setKeywords(this.keywords);
        userAgent.setCreationDate(this.creationDate);
        userAgent.setKeepEmptyTags(this.isKeepEmptyTags.booleanValue());
        userAgent.setLocatorEnabled(this.isErrorInfo.booleanValue());
        return userAgent;
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public FopFactory getFopFactory() {
        return this.fopFactory;
    }

    public FOUserAgent getUserAgent() {
        return this.userAgent;
    }

    public XEasyPdfTemplateDataSource getDataSource() {
        return this.dataSource;
    }

    public Boolean getIsAccessibility() {
        return this.isAccessibility;
    }

    public Boolean getIsKeepEmptyTags() {
        return this.isKeepEmptyTags;
    }

    public Boolean getIsErrorInfo() {
        return this.isErrorInfo;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setFopFactory(FopFactory fopFactory) {
        this.fopFactory = fopFactory;
    }

    public void setUserAgent(FOUserAgent userAgent) {
        this.userAgent = userAgent;
    }

    public void setDataSource(XEasyPdfTemplateDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setIsAccessibility(Boolean isAccessibility) {
        this.isAccessibility = isAccessibility;
    }

    public void setIsKeepEmptyTags(Boolean isKeepEmptyTags) {
        this.isKeepEmptyTags = isKeepEmptyTags;
    }

    public void setIsErrorInfo(Boolean isErrorInfo) {
        this.isErrorInfo = isErrorInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfTemplateParam)) {
            return false;
        }
        XEasyPdfTemplateParam other = (XEasyPdfTemplateParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isAccessibility = this.getIsAccessibility();
        Boolean other$isAccessibility = other.getIsAccessibility();
        if (this$isAccessibility == null ? other$isAccessibility != null : !((Object)this$isAccessibility).equals(other$isAccessibility)) {
            return false;
        }
        Boolean this$isKeepEmptyTags = this.getIsKeepEmptyTags();
        Boolean other$isKeepEmptyTags = other.getIsKeepEmptyTags();
        if (this$isKeepEmptyTags == null ? other$isKeepEmptyTags != null : !((Object)this$isKeepEmptyTags).equals(other$isKeepEmptyTags)) {
            return false;
        }
        Boolean this$isErrorInfo = this.getIsErrorInfo();
        Boolean other$isErrorInfo = other.getIsErrorInfo();
        if (this$isErrorInfo == null ? other$isErrorInfo != null : !((Object)this$isErrorInfo).equals(other$isErrorInfo)) {
            return false;
        }
        String this$configPath = this.getConfigPath();
        String other$configPath = other.getConfigPath();
        if (this$configPath == null ? other$configPath != null : !this$configPath.equals(other$configPath)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$keywords = this.getKeywords();
        String other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !this$keywords.equals(other$keywords)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        Date this$creationDate = this.getCreationDate();
        Date other$creationDate = other.getCreationDate();
        if (this$creationDate == null ? other$creationDate != null : !((Object)this$creationDate).equals(other$creationDate)) {
            return false;
        }
        FopFactory this$fopFactory = this.getFopFactory();
        FopFactory other$fopFactory = other.getFopFactory();
        if (this$fopFactory == null ? other$fopFactory != null : !this$fopFactory.equals(other$fopFactory)) {
            return false;
        }
        FOUserAgent this$userAgent = this.getUserAgent();
        FOUserAgent other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        XEasyPdfTemplateDataSource this$dataSource = this.getDataSource();
        XEasyPdfTemplateDataSource other$dataSource = other.getDataSource();
        return !(this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfTemplateParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isAccessibility = this.getIsAccessibility();
        result = result * 59 + ($isAccessibility == null ? 43 : ((Object)$isAccessibility).hashCode());
        Boolean $isKeepEmptyTags = this.getIsKeepEmptyTags();
        result = result * 59 + ($isKeepEmptyTags == null ? 43 : ((Object)$isKeepEmptyTags).hashCode());
        Boolean $isErrorInfo = this.getIsErrorInfo();
        result = result * 59 + ($isErrorInfo == null ? 43 : ((Object)$isErrorInfo).hashCode());
        String $configPath = this.getConfigPath();
        result = result * 59 + ($configPath == null ? 43 : $configPath.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : $keywords.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        Date $creationDate = this.getCreationDate();
        result = result * 59 + ($creationDate == null ? 43 : ((Object)$creationDate).hashCode());
        FopFactory $fopFactory = this.getFopFactory();
        result = result * 59 + ($fopFactory == null ? 43 : $fopFactory.hashCode());
        FOUserAgent $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        XEasyPdfTemplateDataSource $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfTemplateParam(configPath=" + this.getConfigPath() + ", title=" + this.getTitle() + ", author=" + this.getAuthor() + ", subject=" + this.getSubject() + ", keywords=" + this.getKeywords() + ", creator=" + this.getCreator() + ", creationDate=" + this.getCreationDate() + ", fopFactory=" + this.getFopFactory() + ", userAgent=" + this.getUserAgent() + ", dataSource=" + this.getDataSource() + ", isAccessibility=" + this.getIsAccessibility() + ", isKeepEmptyTags=" + this.getIsKeepEmptyTags() + ", isErrorInfo=" + this.getIsErrorInfo() + ")";
    }
}

