/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.datasource;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import wiki.xsx.core.pdf.template.datasource.XEasyPdfTemplateDataSource;
import wiki.xsx.core.pdf.template.doc.XEasyPdfTemplateDocumentComponent;

public class XEasyPdfTemplateDocumentDataSource
implements XEasyPdfTemplateDataSource {
    private XEasyPdfTemplateDocumentComponent document;

    @Override
    public Reader getSourceReader() {
        return new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8);
    }

    @Override
    public void transform(FopFactory fopFactory, FOUserAgent foAgent, OutputStream outputStream) {
        this.saxTransform(fopFactory, foAgent, outputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getInputStream() {
        if (this.document == null) {
            throw new IllegalArgumentException("the document can not be null");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(8192);){
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.document.getDocument()), new StreamResult(outputStream));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(outputStream.toByteArray()));
            return bufferedInputStream;
        }
    }

    public XEasyPdfTemplateDocumentDataSource setDocument(XEasyPdfTemplateDocumentComponent document) {
        this.document = document;
        return this;
    }
}

