/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc;

import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.template.XEasyPdfTemplate;
import wiki.xsx.core.pdf.template.doc.XEasyPdfTemplateDocumentComponent;
import wiki.xsx.core.pdf.template.doc.XEasyPdfTemplateDocumentParam;
import wiki.xsx.core.pdf.template.doc.bookmark.XEasyPdfTemplateBookmarkComponent;
import wiki.xsx.core.pdf.template.doc.page.XEasyPdfTemplatePageComponent;
import wiki.xsx.core.pdf.template.handler.XEasyPdfTemplateHandler;

public class XEasyPdfTemplateDocument
implements XEasyPdfTemplateDocumentComponent {
    private final XEasyPdfTemplateDocumentParam param = new XEasyPdfTemplateDocumentParam();

    public XEasyPdfTemplateDocument setConfigPath(String configPath) {
        this.param.setConfigPath(configPath);
        return this;
    }

    public XEasyPdfTemplateDocument addPage(XEasyPdfTemplatePageComponent ... pages) {
        Optional.ofNullable(pages).ifPresent(v -> Collections.addAll(this.param.getPageList(), v));
        return this;
    }

    public XEasyPdfTemplateDocument addBookmark(XEasyPdfTemplateBookmarkComponent ... bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(v -> Collections.addAll(this.param.getBookmarkList(), v));
        return this;
    }

    public XEasyPdfTemplateDocument addBookmark(List<XEasyPdfTemplateBookmarkComponent> bookmarks) {
        Optional.ofNullable(bookmarks).ifPresent(this.param.getBookmarkList()::addAll);
        return this;
    }

    public XEasyPdfDocument transform() {
        return this.initTemplate().transform();
    }

    @Override
    public void transform(OutputStream outputStream) {
        this.initTemplate().transform(outputStream);
    }

    @Override
    public Document getDocument() {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getClass().getResourceAsStream("/wiki/xsx/core/pdf/template/template.fo"));
        this.addPage(document);
        return document;
    }

    public String getContent() {
        return XEasyPdfTemplateHandler.DataSource.Document.build().setDocument(this).getDocumentContent();
    }

    private XEasyPdfTemplate initTemplate() {
        return XEasyPdfTemplateHandler.Template.build().setConfigPath(this.param.getConfigPath()).setDataSource(XEasyPdfTemplateHandler.DataSource.Document.build().setDocument(this));
    }

    private void addPage(Document document) {
        Element root = document.getDocumentElement();
        int index = 0;
        List<XEasyPdfTemplatePageComponent> pageList = this.param.getPageList();
        for (XEasyPdfTemplatePageComponent page : pageList) {
            root.appendChild(page.createElement(++index, document, this.createBookmark(document, index)));
        }
    }

    private Element createBookmark(Document document, int index) {
        if (index > 1) {
            return null;
        }
        if (!this.param.getBookmarkList().isEmpty()) {
            Element tree = document.createElement("fo:bookmark-tree");
            this.param.getBookmarkList().forEach(v -> tree.appendChild(v.createElement(document)));
            return tree;
        }
        return null;
    }
}

