/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc.component;

import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import wiki.xsx.core.pdf.template.doc.component.XEasyPdfTemplateComponentParam;

public interface XEasyPdfTemplateComponent {
    public Element createElement(Document var1);

    default public Element createEmptyElement(Document document) {
        return document.createElement("fo:block");
    }

    default public Element createBlockElement(Document document, XEasyPdfTemplateComponentParam param) {
        Element block = this.createEmptyElement(document);
        Optional.ofNullable(param.getId()).ifPresent(v -> block.setAttribute("id", v.intern()));
        Optional.ofNullable(param.getHasBorder()).ifPresent(v -> block.setAttribute("border", "1px solid black"));
        Optional.ofNullable(param.getHorizontalStyle()).ifPresent(v -> block.setAttribute("text-align", v.intern().toLowerCase()));
        Optional.ofNullable(param.getMargin()).ifPresent(v -> block.setAttribute("margin", v.intern().toLowerCase()));
        Optional.ofNullable(param.getMarginTop()).ifPresent(v -> block.setAttribute("margin-top", v.intern().toLowerCase()));
        Optional.ofNullable(param.getMarginBottom()).ifPresent(v -> block.setAttribute("margin-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(param.getMarginLeft()).ifPresent(v -> block.setAttribute("margin-left", v.intern().toLowerCase()));
        Optional.ofNullable(param.getMarginRight()).ifPresent(v -> block.setAttribute("margin-right", v.intern().toLowerCase()));
        Optional.ofNullable(param.getPadding()).ifPresent(v -> block.setAttribute("padding", v.intern().toLowerCase()));
        Optional.ofNullable(param.getPaddingTop()).ifPresent(v -> block.setAttribute("padding-top", v.intern().toLowerCase()));
        Optional.ofNullable(param.getPaddingBottom()).ifPresent(v -> block.setAttribute("padding-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(param.getPaddingLeft()).ifPresent(v -> block.setAttribute("padding-left", v.intern().toLowerCase()));
        Optional.ofNullable(param.getPaddingRight()).ifPresent(v -> block.setAttribute("padding-right", v.intern().toLowerCase()));
        Optional.ofNullable(param.getSpaceBefore()).ifPresent(v -> block.setAttribute("space-before", v.intern().toLowerCase()));
        Optional.ofNullable(param.getSpaceAfter()).ifPresent(v -> block.setAttribute("space-after", v.intern().toLowerCase()));
        Optional.ofNullable(param.getWhiteSpace()).ifPresent(v -> block.setAttribute("white-space", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBreakBefore()).ifPresent(v -> block.setAttribute("break-before", v.intern().toLowerCase()));
        Optional.ofNullable(param.getBreakAfter()).ifPresent(v -> block.setAttribute("break-after", v.intern().toLowerCase()));
        Optional.ofNullable(param.getKeepTogether()).ifPresent(v -> block.setAttribute("keep-together", v.intern().toLowerCase()));
        Optional.ofNullable(param.getKeepWithPrevious()).ifPresent(v -> block.setAttribute("keep-with-previous", v.intern().toLowerCase()));
        Optional.ofNullable(param.getKeepWithNext()).ifPresent(v -> block.setAttribute("keep-with-next", v.intern().toLowerCase()));
        return block;
    }

    default public Element transform(Document document) {
        return Optional.ofNullable(this.createElement(document)).orElse(this.createEmptyElement(document));
    }

    default public void appendChild(Element parent, Node child) {
        if (child == null) {
            return;
        }
        Optional.ofNullable(child.getFirstChild()).ifPresent(v -> {
            parent.appendChild((Node)v);
            this.appendChild(parent, child);
        });
    }
}

