/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc.component.image;

import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.doc.component.XEasyPdfTemplateComponent;
import wiki.xsx.core.pdf.template.doc.component.image.XEasyPdfTemplateImageParam;

public class XEasyPdfTemplateImage
implements XEasyPdfTemplateComponent {
    private final XEasyPdfTemplateImageParam param = new XEasyPdfTemplateImageParam();

    public XEasyPdfTemplateImage setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public XEasyPdfTemplateImage setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public XEasyPdfTemplateImage setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public XEasyPdfTemplateImage setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public XEasyPdfTemplateImage setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateImage setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public XEasyPdfTemplateImage setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public XEasyPdfTemplateImage setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public XEasyPdfTemplateImage setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public XEasyPdfTemplateImage setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateImage setId(String id) {
        this.param.setId(id);
        return this;
    }

    public XEasyPdfTemplateImage setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public XEasyPdfTemplateImage setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public XEasyPdfTemplateImage setPath(String path) {
        this.param.setPath(path);
        return this;
    }

    public XEasyPdfTemplateImage setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateImage setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public XEasyPdfTemplateImage setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public XEasyPdfTemplateImage enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public XEasyPdfTemplateImage enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public XEasyPdfTemplateImage enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public XEasyPdfTemplateImage enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getPath() == null) {
            return null;
        }
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createExternalGraphic(document));
        return block;
    }

    private Element createExternalGraphic(Document document) {
        Element externalGraphic = document.createElement("fo:external-graphic");
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> externalGraphic.setAttribute("content-width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> externalGraphic.setAttribute("content-height", v.intern().toLowerCase()));
        externalGraphic.setAttribute("src", this.param.getPath().intern());
        return externalGraphic;
    }
}

