/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc.component.table;

import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.doc.component.XEasyPdfTemplateComponent;
import wiki.xsx.core.pdf.template.doc.component.table.XEasyPdfTemplateTableBody;
import wiki.xsx.core.pdf.template.doc.component.table.XEasyPdfTemplateTableFooter;
import wiki.xsx.core.pdf.template.doc.component.table.XEasyPdfTemplateTableHeader;
import wiki.xsx.core.pdf.template.doc.component.table.XEasyPdfTemplateTableParam;
import wiki.xsx.core.pdf.template.handler.XEasyPdfTemplateElementHandler;

public class XEasyPdfTemplateTable
implements XEasyPdfTemplateComponent {
    private final XEasyPdfTemplateTableParam param = new XEasyPdfTemplateTableParam();

    public XEasyPdfTemplateTable setHeader(XEasyPdfTemplateTableHeader header) {
        this.param.setHeader(header);
        return this;
    }

    public XEasyPdfTemplateTable setBody(XEasyPdfTemplateTableBody body) {
        this.param.setBody(body);
        return this;
    }

    public XEasyPdfTemplateTable setFooter(XEasyPdfTemplateTableFooter footer) {
        this.param.setFooter(footer);
        return this;
    }

    public XEasyPdfTemplateTable setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public XEasyPdfTemplateTable setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public XEasyPdfTemplateTable setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public XEasyPdfTemplateTable setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public XEasyPdfTemplateTable setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateTable setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public XEasyPdfTemplateTable setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public XEasyPdfTemplateTable setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public XEasyPdfTemplateTable setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public XEasyPdfTemplateTable setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateTable setId(String id) {
        this.param.setId(id);
        return this;
    }

    public XEasyPdfTemplateTable setWidth(String width) {
        this.param.setWidth(width);
        return this;
    }

    public XEasyPdfTemplateTable setHeight(String height) {
        this.param.setHeight(height);
        return this;
    }

    public XEasyPdfTemplateTable setBorder(String border) {
        this.param.setBorder(border);
        return this;
    }

    public XEasyPdfTemplateTable setBorderStyle(String borderStyle) {
        this.param.setBorderStyle(borderStyle);
        return this;
    }

    public XEasyPdfTemplateTable setBorderCollapse(String borderCollapse) {
        this.param.setBorderCollapse(borderCollapse);
        return this;
    }

    public XEasyPdfTemplateTable setBorderSpacing(String borderSpacing) {
        this.param.setBorderSpacing(borderSpacing);
        return this;
    }

    public XEasyPdfTemplateTable setBorderRadius(String borderRadius) {
        this.param.setBorderRadius(borderRadius);
        return this;
    }

    public XEasyPdfTemplateTable setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public XEasyPdfTemplateTable setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public XEasyPdfTemplateTable setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public XEasyPdfTemplateTable setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public XEasyPdfTemplateTable setWordBreak(String wordBreak) {
        this.param.setWordBreak(wordBreak);
        return this;
    }

    public XEasyPdfTemplateTable setWhiteSpace(String whiteSpace) {
        this.param.setWhiteSpace(whiteSpace);
        return this;
    }

    public XEasyPdfTemplateTable setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateTable setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public XEasyPdfTemplateTable setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public XEasyPdfTemplateTable setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTemplateTable setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public XEasyPdfTemplateTable setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public XEasyPdfTemplateTable setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateTable setVerticalStyle(String style) {
        this.param.setVerticalStyle(style);
        return this;
    }

    public XEasyPdfTemplateTable setMinRowHeight(String minRowHeight) {
        this.param.setMinRowHeight(minRowHeight);
        return this;
    }

    public XEasyPdfTemplateTable setMinColumnWidth(String minColumnWidth) {
        this.param.setMinColumnWidth(minColumnWidth);
        return this;
    }

    public XEasyPdfTemplateTable setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public XEasyPdfTemplateTable setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public XEasyPdfTemplateTable setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public XEasyPdfTemplateTable enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public XEasyPdfTemplateTable enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public XEasyPdfTemplateTable enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public XEasyPdfTemplateTable enableAutoOmitHeader() {
        this.param.setIsAutoOmitHeader(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateTable enableAutoOmitFooter() {
        this.param.setIsAutoOmitFooter(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        Element block = this.createBlockElement(document, this.param);
        block.appendChild(this.createTable(document));
        return block;
    }

    private Element createTable(Document document) {
        Element table = document.createElement("fo:table");
        XEasyPdfTemplateElementHandler.appendChild(table, this.createTableHeader(document));
        XEasyPdfTemplateElementHandler.appendChild(table, this.createTableBody(document));
        XEasyPdfTemplateElementHandler.appendChild(table, this.createTableFooter(document));
        Optional.ofNullable(this.param.getVerticalStyle()).ifPresent(v -> table.setAttribute("display-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWidth()).ifPresent(v -> table.setAttribute("width", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHeight()).ifPresent(v -> table.setAttribute("height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorder()).ifPresent(v -> table.setAttribute("border", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderStyle()).ifPresent(v -> table.setAttribute("border-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderCollapse()).ifPresent(v -> table.setAttribute("border-collapse", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderSpacing()).ifPresent(v -> table.setAttribute("border-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderRadius()).ifPresent(v -> table.setAttribute("border-radius", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> table.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> table.setAttribute("font-family", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> table.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> table.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> table.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> table.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> table.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLeading()).ifPresent(v -> table.setAttribute("line-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLetterSpacing()).ifPresent(v -> table.setAttribute("letter-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordSpacing()).ifPresent(v -> table.setAttribute("word-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordBreak()).ifPresent(v -> table.setAttribute("word-break", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWhiteSpace()).ifPresent(v -> table.setAttribute("white-space", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getIsAutoOmitHeader()).ifPresent(v -> table.setAttribute("table-omit-header-at-break", v.toString().intern().toLowerCase()));
        Optional.ofNullable(this.param.getIsAutoOmitFooter()).ifPresent(v -> table.setAttribute("table-omit-footer-at-break", v.toString().intern().toLowerCase()));
        Optional.ofNullable(this.param.getBackgroundColor()).ifPresent(v -> table.setAttribute("background-color", v.intern().toLowerCase()));
        return table;
    }

    private Element createTableHeader(Document document) {
        XEasyPdfTemplateTableHeader header = this.param.getHeader();
        return header == null ? null : header.setMinColumnWidth(this.param.getMinColumnWidth()).setMinRowHeight(this.param.getMinRowHeight()).createElement(document);
    }

    private Element createTableBody(Document document) {
        XEasyPdfTemplateTableBody body = this.param.getBody();
        if (body == null) {
            throw new IllegalArgumentException("the table body can not be null");
        }
        return body.setMinColumnWidth(this.param.getMinColumnWidth()).setMinRowHeight(this.param.getMinRowHeight()).createElement(document);
    }

    private Element createTableFooter(Document document) {
        XEasyPdfTemplateTableFooter footer = this.param.getFooter();
        return footer == null ? null : footer.setMinColumnWidth(this.param.getMinColumnWidth()).setMinRowHeight(this.param.getMinRowHeight()).createElement(document);
    }
}

