/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc.component.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.doc.component.table.XEasyPdfTemplateTableCell;
import wiki.xsx.core.pdf.template.doc.component.table.XEasyPdfTemplateTableRowParam;

public class XEasyPdfTemplateTableRow {
    private final XEasyPdfTemplateTableRowParam param = new XEasyPdfTemplateTableRowParam();

    private XEasyPdfTemplateTableRow setInitialCapacity(int initialCapacity) {
        this.param.setCells(new ArrayList<XEasyPdfTemplateTableCell>(initialCapacity));
        return this;
    }

    public XEasyPdfTemplateTableRow setBorder(String border) {
        this.param.setBorder(border);
        return this;
    }

    public XEasyPdfTemplateTableRow setBorderStyle(String borderStyle) {
        this.param.setBorderStyle(borderStyle);
        return this;
    }

    public XEasyPdfTemplateTableRow setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public XEasyPdfTemplateTableRow setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public XEasyPdfTemplateTableRow setLetterSpacing(String letterSpacing) {
        this.param.setLetterSpacing(letterSpacing);
        return this;
    }

    public XEasyPdfTemplateTableRow setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public XEasyPdfTemplateTableRow setWordBreak(String wordBreak) {
        this.param.setWordBreak(wordBreak);
        return this;
    }

    public XEasyPdfTemplateTableRow setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateTableRow setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public XEasyPdfTemplateTableRow setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public XEasyPdfTemplateTableRow setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTemplateTableRow setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public XEasyPdfTemplateTableRow setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public XEasyPdfTemplateTableRow setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateTableRow setVerticalStyle(String style) {
        this.param.setVerticalStyle(style);
        return this;
    }

    public XEasyPdfTemplateTableRow setMinColumnWidth(String minColumnWidth) {
        if (this.param.getMinColumnWidth() == null) {
            this.param.setMinColumnWidth(minColumnWidth);
        }
        return this;
    }

    public XEasyPdfTemplateTableRow setMinRowHeight(String minRowHeight) {
        if (this.param.getMinRowHeight() == null) {
            this.param.setMinRowHeight(minRowHeight);
        }
        return this;
    }

    public XEasyPdfTemplateTableRow setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public XEasyPdfTemplateTableRow setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public XEasyPdfTemplateTableRow enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public XEasyPdfTemplateTableRow enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public XEasyPdfTemplateTableRow enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public XEasyPdfTemplateTableRow addCell(XEasyPdfTemplateTableCell ... cells) {
        Optional.ofNullable(cells).ifPresent(v -> Collections.addAll(this.param.getCells(), v));
        return this;
    }

    public XEasyPdfTemplateTableRow addCell(List<XEasyPdfTemplateTableCell> cells) {
        Optional.ofNullable(cells).ifPresent(this.param.getCells()::addAll);
        return this;
    }

    public Element createElement(Document document) {
        Element tableRow = document.createElement("fo:table-row");
        Optional.ofNullable(this.param.getBorder()).ifPresent(v -> tableRow.setAttribute("border", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBorderStyle()).ifPresent(v -> tableRow.setAttribute("border-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getHorizontalStyle()).ifPresent(v -> tableRow.setAttribute("text-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getVerticalStyle()).ifPresent(v -> tableRow.setAttribute("display-align", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> tableRow.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> tableRow.setAttribute("font-family", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> tableRow.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> tableRow.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> tableRow.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> tableRow.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> tableRow.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLeading()).ifPresent(v -> tableRow.setAttribute("line-height", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLetterSpacing()).ifPresent(v -> tableRow.setAttribute("letter-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordSpacing()).ifPresent(v -> tableRow.setAttribute("word-spacing", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getWordBreak()).ifPresent(v -> tableRow.setAttribute("word-break", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBreakBefore()).ifPresent(v -> tableRow.setAttribute("break-before", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getBreakAfter()).ifPresent(v -> tableRow.setAttribute("break-after", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getKeepTogether()).ifPresent(v -> tableRow.setAttribute("keep-together", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getKeepWithPrevious()).ifPresent(v -> tableRow.setAttribute("keep-with-previous", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getKeepWithNext()).ifPresent(v -> tableRow.setAttribute("keep-with-next", v.intern().toLowerCase()));
        this.param.getCells().forEach(v -> tableRow.appendChild(v.setWidth(this.param.getMinColumnWidth()).setHeight(this.param.getMinRowHeight()).createElement(document)));
        return tableRow;
    }
}

