/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.doc.component.text;

import java.util.Optional;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import wiki.xsx.core.pdf.template.doc.component.text.XEasyPdfTemplateTextBase;
import wiki.xsx.core.pdf.template.doc.component.text.XEasyPdfTemplateTextBaseParam;
import wiki.xsx.core.pdf.template.doc.component.text.XEasyPdfTemplateTextParam;

public class XEasyPdfTemplateText
extends XEasyPdfTemplateTextBase {
    private final XEasyPdfTemplateTextParam param = new XEasyPdfTemplateTextParam();

    public XEasyPdfTemplateText setMargin(String margin) {
        this.param.setMargin(margin);
        return this;
    }

    public XEasyPdfTemplateText setMarginTop(String marginTop) {
        this.param.setMarginTop(marginTop);
        return this;
    }

    public XEasyPdfTemplateText setMarginBottom(String marginBottom) {
        this.param.setMarginBottom(marginBottom);
        return this;
    }

    public XEasyPdfTemplateText setMarginLeft(String marginLeft) {
        this.param.setMarginLeft(marginLeft);
        return this;
    }

    public XEasyPdfTemplateText setMarginRight(String paddingRight) {
        this.param.setMarginRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateText setPadding(String padding) {
        this.param.setPadding(padding);
        return this;
    }

    public XEasyPdfTemplateText setPaddingTop(String paddingTop) {
        this.param.setPaddingTop(paddingTop);
        return this;
    }

    public XEasyPdfTemplateText setPaddingBottom(String paddingBottom) {
        this.param.setPaddingBottom(paddingBottom);
        return this;
    }

    public XEasyPdfTemplateText setPaddingLeft(String paddingLeft) {
        this.param.setPaddingLeft(paddingLeft);
        return this;
    }

    public XEasyPdfTemplateText setPaddingRight(String paddingRight) {
        this.param.setPaddingRight(paddingRight);
        return this;
    }

    public XEasyPdfTemplateText setId(String id) {
        this.param.setId(id);
        return this;
    }

    public XEasyPdfTemplateText setLanguage(String language) {
        this.param.setLanguage(language);
        return this;
    }

    public XEasyPdfTemplateText setText(String text) {
        this.param.setText(text);
        return this;
    }

    public XEasyPdfTemplateText setLeading(String leading) {
        this.param.setLeading(leading);
        return this;
    }

    public XEasyPdfTemplateText setLetterSpacing(String spacing) {
        this.param.setLetterSpacing(spacing);
        return this;
    }

    public XEasyPdfTemplateText setWordSpacing(String spacing) {
        this.param.setWordSpacing(spacing);
        return this;
    }

    public XEasyPdfTemplateText setWordBreak(String wordBreak) {
        this.param.setWordBreak(wordBreak);
        return this;
    }

    public XEasyPdfTemplateText setWhiteSpace(String whiteSpace) {
        this.param.setWhiteSpace(whiteSpace);
        return this;
    }

    public XEasyPdfTemplateText setTextIndent(String indent) {
        this.param.setTextIndent(indent);
        return this;
    }

    public XEasyPdfTemplateText setStartIndent(String indent) {
        this.param.setStartIndent(indent);
        return this;
    }

    public XEasyPdfTemplateText setEndIndent(String indent) {
        this.param.setEndIndent(indent);
        return this;
    }

    public XEasyPdfTemplateText setSpaceBefore(String space) {
        this.param.setSpaceBefore(space);
        return this;
    }

    public XEasyPdfTemplateText setSpaceAfter(String space) {
        this.param.setSpaceAfter(space);
        return this;
    }

    public XEasyPdfTemplateText setFontFamily(String fontFamily) {
        this.param.setFontFamily(fontFamily);
        return this;
    }

    public XEasyPdfTemplateText setFontStyle(String fontStyle) {
        this.param.setFontStyle(fontStyle);
        return this;
    }

    public XEasyPdfTemplateText setFontWeight(String fontWeight) {
        this.param.setFontWeight(fontWeight);
        return this;
    }

    public XEasyPdfTemplateText setFontSize(String fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTemplateText setFontSizeAdjust(String fontSizeAdjust) {
        this.param.setFontSizeAdjust(fontSizeAdjust);
        return this;
    }

    public XEasyPdfTemplateText setFontColor(String color) {
        this.param.setColor(color);
        return this;
    }

    public XEasyPdfTemplateText setHorizontalStyle(String style) {
        this.param.setHorizontalStyle(style);
        return this;
    }

    public XEasyPdfTemplateText setVerticalStyle(String style) {
        this.param.setVerticalAlign(style);
        return this;
    }

    public XEasyPdfTemplateText setLinkInternalDestination(String destination) {
        this.param.setLinkInternalDestination(destination);
        return this;
    }

    public XEasyPdfTemplateText setLinkExternalDestination(String destination) {
        this.param.setLinkExternalDestination(destination);
        return this;
    }

    public XEasyPdfTemplateText setDeleteLineColor(String color) {
        this.param.setDeleteLineColor(color);
        return this;
    }

    public XEasyPdfTemplateText setUnderLineColor(String color) {
        this.param.setUnderLineColor(color);
        return this;
    }

    public XEasyPdfTemplateText setUnderLineWidth(String width) {
        this.param.setUnderLineWidth(width);
        return this;
    }

    public XEasyPdfTemplateText setBreakBefore(String breakBefore) {
        this.param.setBreakBefore(breakBefore);
        return this;
    }

    public XEasyPdfTemplateText setBreakAfter(String breakAfter) {
        this.param.setBreakAfter(breakAfter);
        return this;
    }

    public XEasyPdfTemplateText setBackgroundColor(String color) {
        this.param.setBackgroundColor(color);
        return this;
    }

    public XEasyPdfTemplateText enableKeepTogether() {
        this.param.setKeepTogether("always");
        return this;
    }

    public XEasyPdfTemplateText enableKeepWithPrevious() {
        this.param.setKeepWithPrevious("always");
        return this;
    }

    public XEasyPdfTemplateText enableKeepWithNext() {
        this.param.setKeepWithNext("always");
        return this;
    }

    public XEasyPdfTemplateText enableLink() {
        this.param.setHasLink(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateText enableDeleteLine() {
        this.param.setHasDeleteLine(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateText enableUnderLine() {
        this.param.setHasUnderLine(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTemplateText enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    @Override
    public Element createElement(Document document) {
        if (this.param.getText() == null) {
            return null;
        }
        Element block = this.initBlock(document, this.param);
        if (this.param.getHasLink().booleanValue()) {
            Element link = this.createLink(document);
            link.appendChild(this.createInline(document));
            block.appendChild(link);
        } else {
            block.appendChild(this.createInline(document));
        }
        return block;
    }

    XEasyPdfTemplateText init(XEasyPdfTemplateTextBaseParam param) {
        this.param.init(param);
        return this;
    }

    private Element createLink(Document document) {
        Element link = document.createElement("fo:basic-link");
        Optional.ofNullable(this.param.getLinkInternalDestination()).ifPresent(v -> link.setAttribute("internal-destination", v.intern()));
        Optional.ofNullable(this.param.getLinkExternalDestination()).ifPresent(v -> link.setAttribute("external-destination", v.intern()));
        return link;
    }

    private Element createInline(Document document) {
        Element inline = document.createElement("fo:inline");
        Optional.ofNullable(this.param.getPadding()).ifPresent(v -> inline.setAttribute("padding", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingTop()).ifPresent(v -> inline.setAttribute("padding-top", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingBottom()).ifPresent(v -> inline.setAttribute("padding-bottom", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingLeft()).ifPresent(v -> inline.setAttribute("padding-left", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getPaddingRight()).ifPresent(v -> inline.setAttribute("padding-right", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getTextIndent()).ifPresent(v -> inline.setAttribute("text-indent", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getLanguage()).ifPresent(v -> inline.setAttribute("language", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontFamily()).ifPresent(v -> inline.setAttribute("font-family", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontStyle()).ifPresent(v -> inline.setAttribute("font-style", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSize()).ifPresent(v -> inline.setAttribute("font-size", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontSizeAdjust()).ifPresent(v -> inline.setAttribute("font-size-adjust", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getFontWeight()).ifPresent(v -> inline.setAttribute("font-weight", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getColor()).ifPresent(v -> inline.setAttribute("color", v.intern().toLowerCase()));
        Optional.ofNullable(this.param.getVerticalAlign()).ifPresent(v -> inline.setAttribute("vertical-align", v.intern().toLowerCase()));
        if (this.param.hasUnderLine.booleanValue()) {
            String borderBottom = Optional.ofNullable(this.param.getUnderLineWidth()).orElse("1pt") + " solid " + Optional.ofNullable(this.param.getUnderLineColor()).orElse("");
            inline.setAttribute("border-bottom", borderBottom.intern());
        }
        Optional.ofNullable(this.param.getBackgroundColor()).ifPresent(v -> inline.setAttribute("background-color", v.intern().toLowerCase()));
        inline.setTextContent(this.param.getText());
        return inline;
    }
}

