/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.ext.barcode;

import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.w3c.dom.Node;
import wiki.xsx.core.pdf.template.ext.barcode.XEasyPdfTemplateBarCodeConfig;
import wiki.xsx.core.pdf.template.util.XEasyPdfTemplateImageUtil;

public class XEasyPdfTemplateBarcodePreloader
extends AbstractImagePreloader {
    private static final Map<String, BufferedImage> CACHE = new HashMap<String, BufferedImage>(10);
    private static final Object LOCK = new Object();

    public ImageInfo preloadImage(String originalURI, Source src, ImageContext context) {
        DOMSource domSource;
        Node barcode;
        if (src instanceof DOMSource && (barcode = (domSource = (DOMSource)src).getNode().getFirstChild()) != null && "barcode".equals(barcode.getLocalName())) {
            XEasyPdfTemplateBarCodeConfig config = XEasyPdfTemplateBarCodeConfig.init(barcode.getAttributes());
            String uri = String.join((CharSequence)"-", config.getType().name(), config.getWidth().toString(), config.getHeight().toString(), config.getContent()).intern();
            ImageInfo imageInfo = new ImageInfo(uri, "image/barcode");
            imageInfo.getCustomObjects().put("barcode", this.getImage(uri, config));
            return imageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(String uri, XEasyPdfTemplateBarCodeConfig config) {
        BufferedImage barcodeImage = CACHE.get(uri);
        if (barcodeImage == null) {
            Object object = LOCK;
            synchronized (object) {
                barcodeImage = CACHE.get(uri);
                if (barcodeImage == null) {
                    barcodeImage = this.createBarCodeImage(config);
                    CACHE.put(uri, barcodeImage);
                }
            }
        }
        return barcodeImage;
    }

    private BufferedImage createBarCodeImage(XEasyPdfTemplateBarCodeConfig config) {
        BufferedImage barCodeImage = this.getBarCodeImage(new MultiFormatWriter().encode(config.getContent(), config.getType(), config.getWidth().intValue(), config.getHeight().intValue(), config.getEncodeHints()), config);
        if (config.getWords() != null) {
            barCodeImage = this.addImageWords(barCodeImage, config);
        }
        if (config.isRotate()) {
            barCodeImage = XEasyPdfTemplateImageUtil.rotate(barCodeImage, config.getRotateRectangle(), config.getRadians());
        }
        return barCodeImage;
    }

    private BufferedImage getBarCodeImage(BitMatrix matrix, XEasyPdfTemplateBarCodeConfig config) {
        int onColor = config.getOnColor().getRGB();
        int offColor = config.getOffColor().getRGB();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] rowPixels = new int[width];
        BitArray row = new BitArray(width);
        for (int y = 0; y < height; ++y) {
            row = matrix.getRow(y, row);
            for (int x = 0; x < width; ++x) {
                rowPixels[x] = row.get(x) ? onColor : offColor;
            }
            image.setRGB(0, y, width, 1, rowPixels, 0, width);
        }
        return image;
    }

    private BufferedImage addImageWords(BufferedImage image, XEasyPdfTemplateBarCodeConfig config) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage out = new BufferedImage(width, height + config.getWordsSize(), 1);
        Graphics2D graphics = out.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics.setColor(config.getOffColor());
        graphics.fillRect(0, 0, width, height + config.getWordsSize());
        graphics.setColor(config.getWordsColor());
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.setFont(new Font(config.getWordsFamily(), (int)config.getWordsStyle(), config.getWordsSize()));
        int strWidth = graphics.getFontMetrics().stringWidth(config.getWords());
        int beginX = (width - strWidth) / 2 - config.getWordsOffsetX();
        int beginY = height + config.getWordsSize() - config.getWordsOffsetY();
        graphics.drawString(config.getWords(), beginX, beginY);
        graphics.dispose();
        image.flush();
        return out;
    }
}

