/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.template.datasource;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.FopFactory;
import wiki.xsx.core.pdf.template.datasource.XEasyPdfTemplateDataSource;

abstract class XEasyPdfTemplateAbstractDataSource
implements XEasyPdfTemplateDataSource {
    protected String templatePath;
    protected Map<String, Object> templateData;

    XEasyPdfTemplateAbstractDataSource() {
    }

    @Override
    public Reader getSourceReader() {
        return new InputStreamReader(this.getInputStream(), StandardCharsets.UTF_8);
    }

    @Override
    public void transform(FopFactory fopFactory, FOUserAgent foAgent, OutputStream outputStream) {
        this.saxTransform(fopFactory, foAgent, outputStream);
    }

    protected abstract InputStream processTemplate();

    private InputStream getInputStream() {
        return this.isNotEmptyTemplateData() ? this.processTemplate() : this.loadTemplateInputStream();
    }

    private InputStream loadTemplateInputStream() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.templatePath);
            return inputStream != null ? inputStream : Files.newInputStream(Paths.get(this.templatePath, new String[0]), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the template can not be loaded\uff0cthe path['" + this.templatePath + "'] is error");
        }
    }

    private boolean isNotEmptyTemplateData() {
        return this.templateData != null && !this.templateData.isEmpty();
    }
}

