/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.handler;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.handler.XEasyPdfHandler;

public class XEasyPdfFontMapperHandler
implements FontMapper {
    private static final ConcurrentHashMap<String, FontBoxFont> FONT_NAME_MAPPING = new ConcurrentHashMap(16);
    private static final ConcurrentHashMap<String, FontBoxFont> FONT_PATH_MAPPING = new ConcurrentHashMap(16);
    private static final String DEFAULT_FONT_NAME = XEasyPdfDefaultFontStyle.NORMAL.getName();
    private static final XEasyPdfFontMapperHandler INSTANCE = new XEasyPdfFontMapperHandler();

    private XEasyPdfFontMapperHandler() {
        this.init(XEasyPdfDefaultFontStyle.LIGHT, XEasyPdfDefaultFontStyle.NORMAL, XEasyPdfDefaultFontStyle.BOLD);
    }

    public static XEasyPdfFontMapperHandler getInstance() {
        return INSTANCE;
    }

    public void addFont(String fontPath, FontBoxFont font) {
        FONT_NAME_MAPPING.putIfAbsent(font.getName(), font);
        FONT_PATH_MAPPING.putIfAbsent(fontPath, font);
    }

    public FontBoxFont getFontByPath(String fontPath) {
        return FONT_PATH_MAPPING.get(fontPath);
    }

    public FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(baseFont);
        if (ttf != null) {
            return new FontMapping((FontBoxFont)ttf, false);
        }
        return new FontMapping((FontBoxFont)((TrueTypeFont)FONT_NAME_MAPPING.get(DEFAULT_FONT_NAME)), true);
    }

    public FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
        FontBoxFont font = this.findFont(baseFont);
        if (font != null) {
            return new FontMapping(font, false);
        }
        return new FontMapping(FONT_NAME_MAPPING.get(DEFAULT_FONT_NAME), true);
    }

    public CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        FontBoxFont font = this.findFont(baseFont);
        if (font instanceof OpenTypeFont) {
            return new CIDFontMapping((OpenTypeFont)font, null, false);
        }
        if (font instanceof TrueTypeFont) {
            return new CIDFontMapping(null, font, false);
        }
        return new CIDFontMapping(null, FONT_NAME_MAPPING.get(DEFAULT_FONT_NAME), true);
    }

    private void init(XEasyPdfDefaultFontStyle ... styles) {
        for (XEasyPdfDefaultFontStyle style : styles) {
            try (BufferedInputStream inputStream = new BufferedInputStream(XEasyPdfFontMapperHandler.class.getResourceAsStream(style.getPath()));){
                TrueTypeFont font = new TTFParser(true, true).parse((InputStream)inputStream);
                this.addFont(style.getPath(), (FontBoxFont)font);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.initFontMapper();
    }

    private void initFontMapper() {
        String fontMappingPolicy = System.getProperty(XEasyPdfHandler.FontMappingPolicy.key(), XEasyPdfHandler.FontMappingPolicy.DEFAULT.name());
        if (fontMappingPolicy.equals(XEasyPdfHandler.FontMappingPolicy.DEFAULT.name())) {
            FontMappers.set((FontMapper)this);
        }
    }

    private FontBoxFont findFont(String postScriptName) {
        if (postScriptName == null) {
            return null;
        }
        FontBoxFont info = this.getFont(postScriptName);
        if (info != null) {
            return info;
        }
        info = this.getFont(postScriptName.replace("-", ""));
        if (info != null) {
            return info;
        }
        info = this.getFont(postScriptName.replace(',', '-'));
        if (info != null) {
            return info;
        }
        return this.getFont(postScriptName + "-Regular");
    }

    private FontBoxFont getFont(String postScriptName) {
        if (postScriptName.contains("+")) {
            postScriptName = postScriptName.substring(postScriptName.indexOf(43) + 1);
        }
        return FONT_NAME_MAPPING.get(postScriptName);
    }
}

