/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.image;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPositionStyle;
import wiki.xsx.core.pdf.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

class XEasyPdfImageParam
implements Serializable {
    private static final long serialVersionUID = -1443161179636974232L;
    private XEasyPdfComponent.ContentMode contentMode;
    private Boolean isResetContext;
    private transient PDImageXObject imageXObject;
    private transient BufferedImage image;
    private String imageType;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Integer width;
    private Integer height;
    private Float maxWidth;
    private Float maxHeight;
    private Double radians;
    private Boolean useSelfStyle = Boolean.FALSE;
    private Boolean enableSelfAdaption = Boolean.TRUE;
    private Boolean enableVerticalCenterStyle = Boolean.FALSE;
    private XEasyPdfPositionStyle horizontalStyle = XEasyPdfPositionStyle.LEFT;
    private XEasyPdfPositionStyle verticalStyle = XEasyPdfPositionStyle.TOP;
    private Float beginX = Float.valueOf(0.0f);
    private Float beginY;
    private Boolean isChildComponent = Boolean.FALSE;
    private Boolean isCustomRectangle = Boolean.FALSE;
    private Boolean isNeedInitialize = Boolean.TRUE;

    PDImageXObject init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfImage image) {
        if (this.imageXObject != null) {
            return this.imageXObject;
        }
        if (this.image == null) {
            throw new FileNotFoundException("the image can not be found");
        }
        if (this.contentMode == null) {
            this.contentMode = page.getContentMode();
        }
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        if (this.isRotate()) {
            this.image = XEasyPdfImageUtil.rotate(this.image, this.radians);
        }
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float pageWidth = rectangle.getWidth();
        float pageHeight = rectangle.getHeight();
        this.imageXObject = PDImageXObject.createFromByteArray((PDDocument)document.getTarget(), (byte[])XEasyPdfImageUtil.toBytes(this.image, this.imageType), (String)this.imageType);
        int imageWidth = this.imageXObject.getWidth();
        int imageHeight = this.imageXObject.getHeight();
        if (this.width == null) {
            this.width = imageWidth;
        }
        if (this.height == null) {
            this.height = imageHeight;
        }
        if (this.maxWidth == null) {
            this.maxWidth = Float.valueOf(pageWidth);
        }
        if (this.maxHeight == null) {
            this.maxHeight = Float.valueOf(pageHeight);
        }
        if (this.enableSelfAdaption.booleanValue()) {
            float maxWidth;
            XEasyPdfHeader header = page.getHeader();
            XEasyPdfFooter footer = page.getFooter();
            float headerFooterHeight = 0.0f;
            if (header != null && !header.check(image)) {
                headerFooterHeight += header.getHeight(document, page);
            }
            if (footer != null && !footer.check(image)) {
                headerFooterHeight += footer.getHeight(document, page);
            }
            if ((float)this.height.intValue() + this.marginTop.floatValue() + this.marginBottom.floatValue() + headerFooterHeight > pageHeight) {
                Float pageY = page.getPageY();
                if (pageY == null) {
                    pageY = Float.valueOf(pageHeight);
                }
                this.height = (int)(pageY.floatValue() - this.marginTop.floatValue() - this.marginBottom.floatValue() - headerFooterHeight);
                this.width = (int)((double)(this.height * imageWidth) / (double)imageHeight);
            }
            if ((maxWidth = (float)this.width.intValue() + this.marginLeft.floatValue() + this.marginRight.floatValue()) > pageWidth) {
                maxWidth = (float)this.width.intValue() - (maxWidth - pageWidth);
                float ratio = maxWidth / (float)this.width.intValue();
                this.width = (int)maxWidth;
                this.height = (int)((float)this.height.intValue() * ratio);
            }
        }
        return this.imageXObject;
    }

    void initPosition(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.beginY == null) {
            if (page.getPageY() != null) {
                this.initBeginY(document, page);
                if (this.beginY.floatValue() < this.marginBottom.floatValue()) {
                    page.addNewPage(document, page.getLastPage().getMediaBox());
                    this.initBeginY(document, page);
                }
            } else {
                this.initBeginY(document, page);
            }
        }
        this.beginY = Float.valueOf(this.beginY.floatValue() - this.marginTop.floatValue() + this.marginBottom.floatValue());
        this.initBeginX();
    }

    private void initBeginX() {
        if (this.horizontalStyle == XEasyPdfPositionStyle.CENTER) {
            this.beginX = Float.valueOf(this.beginX.floatValue() + (this.maxWidth.floatValue() - (float)this.width.intValue()) / 2.0f);
        } else if (this.horizontalStyle == XEasyPdfPositionStyle.RIGHT) {
            this.beginX = Float.valueOf(this.beginX.floatValue() + this.maxWidth.floatValue() - (float)this.width.intValue() - this.marginRight.floatValue());
        }
        this.beginX = Float.valueOf(this.beginX.floatValue() + this.marginLeft.floatValue() - this.marginRight.floatValue());
    }

    private void initBeginY(XEasyPdfDocument document, XEasyPdfPage page) {
        Float pageY = page.getPageY();
        if (this.verticalStyle == XEasyPdfPositionStyle.CENTER) {
            if (pageY == null) {
                this.beginY = Float.valueOf((this.maxHeight.floatValue() - (float)this.height.intValue()) / 2.0f);
            } else if (this.beginY == null) {
                this.beginY = Float.valueOf(pageY.floatValue() - (float)this.height.intValue() - (pageY.floatValue() - (float)this.height.intValue()) / 2.0f);
            }
        } else if (this.verticalStyle == XEasyPdfPositionStyle.TOP) {
            this.beginY = pageY == null ? Float.valueOf(this.maxHeight.floatValue() - (float)this.height.intValue()) : Float.valueOf(pageY.floatValue() - (float)this.height.intValue());
        } else {
            this.beginY = Float.valueOf(0.01f);
            XEasyPdfFooter footer = page.getFooter();
            if (footer != null) {
                this.beginY = Float.valueOf(this.beginY.floatValue() + footer.getHeight(document, page));
            }
        }
    }

    private boolean isRotate() {
        return this.radians != null && this.radians % 360.0 != 0.0;
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public PDImageXObject getImageXObject() {
        return this.imageXObject;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getImageType() {
        return this.imageType;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Float getMaxWidth() {
        return this.maxWidth;
    }

    public Float getMaxHeight() {
        return this.maxHeight;
    }

    public Double getRadians() {
        return this.radians;
    }

    public Boolean getUseSelfStyle() {
        return this.useSelfStyle;
    }

    public Boolean getEnableSelfAdaption() {
        return this.enableSelfAdaption;
    }

    public Boolean getEnableVerticalCenterStyle() {
        return this.enableVerticalCenterStyle;
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.horizontalStyle;
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.verticalStyle;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Boolean getIsChildComponent() {
        return this.isChildComponent;
    }

    public Boolean getIsCustomRectangle() {
        return this.isCustomRectangle;
    }

    public Boolean getIsNeedInitialize() {
        return this.isNeedInitialize;
    }

    public XEasyPdfImageParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfImageParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfImageParam setImageXObject(PDImageXObject imageXObject) {
        this.imageXObject = imageXObject;
        return this;
    }

    public XEasyPdfImageParam setImage(BufferedImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfImageParam setImageType(String imageType) {
        this.imageType = imageType;
        return this;
    }

    public XEasyPdfImageParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfImageParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfImageParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfImageParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfImageParam setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public XEasyPdfImageParam setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public XEasyPdfImageParam setMaxWidth(Float maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public XEasyPdfImageParam setMaxHeight(Float maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public XEasyPdfImageParam setRadians(Double radians) {
        this.radians = radians;
        return this;
    }

    public XEasyPdfImageParam setUseSelfStyle(Boolean useSelfStyle) {
        this.useSelfStyle = useSelfStyle;
        return this;
    }

    public XEasyPdfImageParam setEnableSelfAdaption(Boolean enableSelfAdaption) {
        this.enableSelfAdaption = enableSelfAdaption;
        return this;
    }

    public XEasyPdfImageParam setEnableVerticalCenterStyle(Boolean enableVerticalCenterStyle) {
        this.enableVerticalCenterStyle = enableVerticalCenterStyle;
        return this;
    }

    public XEasyPdfImageParam setHorizontalStyle(XEasyPdfPositionStyle horizontalStyle) {
        this.horizontalStyle = horizontalStyle;
        return this;
    }

    public XEasyPdfImageParam setVerticalStyle(XEasyPdfPositionStyle verticalStyle) {
        this.verticalStyle = verticalStyle;
        return this;
    }

    public XEasyPdfImageParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfImageParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfImageParam setIsChildComponent(Boolean isChildComponent) {
        this.isChildComponent = isChildComponent;
        return this;
    }

    public XEasyPdfImageParam setIsCustomRectangle(Boolean isCustomRectangle) {
        this.isCustomRectangle = isCustomRectangle;
        return this;
    }

    public XEasyPdfImageParam setIsNeedInitialize(Boolean isNeedInitialize) {
        this.isNeedInitialize = isNeedInitialize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfImageParam)) {
            return false;
        }
        XEasyPdfImageParam other = (XEasyPdfImageParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$maxWidth = this.getMaxWidth();
        Float other$maxWidth = other.getMaxWidth();
        if (this$maxWidth == null ? other$maxWidth != null : !((Object)this$maxWidth).equals(other$maxWidth)) {
            return false;
        }
        Float this$maxHeight = this.getMaxHeight();
        Float other$maxHeight = other.getMaxHeight();
        if (this$maxHeight == null ? other$maxHeight != null : !((Object)this$maxHeight).equals(other$maxHeight)) {
            return false;
        }
        Double this$radians = this.getRadians();
        Double other$radians = other.getRadians();
        if (this$radians == null ? other$radians != null : !((Object)this$radians).equals(other$radians)) {
            return false;
        }
        Boolean this$useSelfStyle = this.getUseSelfStyle();
        Boolean other$useSelfStyle = other.getUseSelfStyle();
        if (this$useSelfStyle == null ? other$useSelfStyle != null : !((Object)this$useSelfStyle).equals(other$useSelfStyle)) {
            return false;
        }
        Boolean this$enableSelfAdaption = this.getEnableSelfAdaption();
        Boolean other$enableSelfAdaption = other.getEnableSelfAdaption();
        if (this$enableSelfAdaption == null ? other$enableSelfAdaption != null : !((Object)this$enableSelfAdaption).equals(other$enableSelfAdaption)) {
            return false;
        }
        Boolean this$enableVerticalCenterStyle = this.getEnableVerticalCenterStyle();
        Boolean other$enableVerticalCenterStyle = other.getEnableVerticalCenterStyle();
        if (this$enableVerticalCenterStyle == null ? other$enableVerticalCenterStyle != null : !((Object)this$enableVerticalCenterStyle).equals(other$enableVerticalCenterStyle)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Boolean this$isChildComponent = this.getIsChildComponent();
        Boolean other$isChildComponent = other.getIsChildComponent();
        if (this$isChildComponent == null ? other$isChildComponent != null : !((Object)this$isChildComponent).equals(other$isChildComponent)) {
            return false;
        }
        Boolean this$isCustomRectangle = this.getIsCustomRectangle();
        Boolean other$isCustomRectangle = other.getIsCustomRectangle();
        if (this$isCustomRectangle == null ? other$isCustomRectangle != null : !((Object)this$isCustomRectangle).equals(other$isCustomRectangle)) {
            return false;
        }
        Boolean this$isNeedInitialize = this.getIsNeedInitialize();
        Boolean other$isNeedInitialize = other.getIsNeedInitialize();
        if (this$isNeedInitialize == null ? other$isNeedInitialize != null : !((Object)this$isNeedInitialize).equals(other$isNeedInitialize)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        String this$imageType = this.getImageType();
        String other$imageType = other.getImageType();
        if (this$imageType == null ? other$imageType != null : !this$imageType.equals(other$imageType)) {
            return false;
        }
        XEasyPdfPositionStyle this$horizontalStyle = this.getHorizontalStyle();
        XEasyPdfPositionStyle other$horizontalStyle = other.getHorizontalStyle();
        if (this$horizontalStyle == null ? other$horizontalStyle != null : !((Object)((Object)this$horizontalStyle)).equals((Object)other$horizontalStyle)) {
            return false;
        }
        XEasyPdfPositionStyle this$verticalStyle = this.getVerticalStyle();
        XEasyPdfPositionStyle other$verticalStyle = other.getVerticalStyle();
        return !(this$verticalStyle == null ? other$verticalStyle != null : !((Object)((Object)this$verticalStyle)).equals((Object)other$verticalStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfImageParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $maxWidth = this.getMaxWidth();
        result = result * 59 + ($maxWidth == null ? 43 : ((Object)$maxWidth).hashCode());
        Float $maxHeight = this.getMaxHeight();
        result = result * 59 + ($maxHeight == null ? 43 : ((Object)$maxHeight).hashCode());
        Double $radians = this.getRadians();
        result = result * 59 + ($radians == null ? 43 : ((Object)$radians).hashCode());
        Boolean $useSelfStyle = this.getUseSelfStyle();
        result = result * 59 + ($useSelfStyle == null ? 43 : ((Object)$useSelfStyle).hashCode());
        Boolean $enableSelfAdaption = this.getEnableSelfAdaption();
        result = result * 59 + ($enableSelfAdaption == null ? 43 : ((Object)$enableSelfAdaption).hashCode());
        Boolean $enableVerticalCenterStyle = this.getEnableVerticalCenterStyle();
        result = result * 59 + ($enableVerticalCenterStyle == null ? 43 : ((Object)$enableVerticalCenterStyle).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Boolean $isChildComponent = this.getIsChildComponent();
        result = result * 59 + ($isChildComponent == null ? 43 : ((Object)$isChildComponent).hashCode());
        Boolean $isCustomRectangle = this.getIsCustomRectangle();
        result = result * 59 + ($isCustomRectangle == null ? 43 : ((Object)$isCustomRectangle).hashCode());
        Boolean $isNeedInitialize = this.getIsNeedInitialize();
        result = result * 59 + ($isNeedInitialize == null ? 43 : ((Object)$isNeedInitialize).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        String $imageType = this.getImageType();
        result = result * 59 + ($imageType == null ? 43 : $imageType.hashCode());
        XEasyPdfPositionStyle $horizontalStyle = this.getHorizontalStyle();
        result = result * 59 + ($horizontalStyle == null ? 43 : ((Object)((Object)$horizontalStyle)).hashCode());
        XEasyPdfPositionStyle $verticalStyle = this.getVerticalStyle();
        result = result * 59 + ($verticalStyle == null ? 43 : ((Object)((Object)$verticalStyle)).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfImageParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isResetContext=" + this.getIsResetContext() + ", imageXObject=" + this.getImageXObject() + ", image=" + this.getImage() + ", imageType=" + this.getImageType() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", maxWidth=" + this.getMaxWidth() + ", maxHeight=" + this.getMaxHeight() + ", radians=" + this.getRadians() + ", useSelfStyle=" + this.getUseSelfStyle() + ", enableSelfAdaption=" + this.getEnableSelfAdaption() + ", enableVerticalCenterStyle=" + this.getEnableVerticalCenterStyle() + ", horizontalStyle=" + (Object)((Object)this.getHorizontalStyle()) + ", verticalStyle=" + (Object)((Object)this.getVerticalStyle()) + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", isChildComponent=" + this.getIsChildComponent() + ", isCustomRectangle=" + this.getIsCustomRectangle() + ", isNeedInitialize=" + this.getIsNeedInitialize() + ")";
    }
}

