/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.rect;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.rect.XEasyPdfRectParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;

public class XEasyPdfRect
implements XEasyPdfComponent {
    private static final long serialVersionUID = 7685200001639953693L;
    private final XEasyPdfRectParam param = new XEasyPdfRectParam();

    public XEasyPdfRect(float width, float height) {
        this(width, height, null, null);
    }

    public XEasyPdfRect(float width, float height, Float beginX, Float beginY) {
        this.param.setWidth(Float.valueOf(Math.abs(width))).setHeight(Float.valueOf(Math.abs(height))).setBeginX(beginX).setBeginY(beginY);
    }

    @Override
    public XEasyPdfRect enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfRect enableCheckPage() {
        this.param.setCheckPage(Boolean.TRUE);
        return this;
    }

    public XEasyPdfRect disableCheckPage() {
        this.param.setCheckPage(Boolean.FALSE);
        return this;
    }

    public XEasyPdfRect setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setHasBorder(boolean hasBorder) {
        this.param.setHasBorder(hasBorder);
        return this;
    }

    public XEasyPdfRect setBorderWidth(float borderWidth) {
        this.param.setBorderWidth(Float.valueOf(Math.abs(borderWidth)));
        return this;
    }

    public XEasyPdfRect setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.param.setBackgroundColor(backgroundColor);
        }
        return this;
    }

    public XEasyPdfRect setBorderColor(Color borderColor) {
        if (borderColor != null) {
            this.param.setBorderColor(borderColor);
        }
        return this;
    }

    public XEasyPdfRect setNewLine(boolean newLine) {
        this.param.setIsNewLine(newLine);
        return this;
    }

    @Override
    public XEasyPdfRect setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfRect setWidth(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfRect setHeight(float height) {
        this.param.setHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    @Override
    public XEasyPdfRect setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, this.param.getIsResetContext().booleanValue());
        if (this.param.getHasBorder().booleanValue()) {
            contentStream.addRect(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue(), this.param.getWidth().floatValue(), this.param.getHeight().floatValue());
            contentStream.setNonStrokingColor(this.param.getBorderColor());
            contentStream.fill();
            contentStream.addRect(this.param.getBeginX().floatValue() + this.param.getBorderWidth().floatValue(), this.param.getBeginY().floatValue() + this.param.getBorderWidth().floatValue(), this.param.getWidth().floatValue() - this.param.getBorderWidth().floatValue() * 2.0f, this.param.getHeight().floatValue() - this.param.getBorderWidth().floatValue() * 2.0f);
            contentStream.setNonStrokingColor(this.param.getBackgroundColor());
            contentStream.fill();
        } else {
            contentStream.addRect(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue(), this.param.getWidth().floatValue(), this.param.getHeight().floatValue());
            contentStream.setNonStrokingColor(this.param.getBackgroundColor());
            contentStream.fill();
        }
        contentStream.setNonStrokingColor(Color.BLACK);
        contentStream.close();
        if (page.isAllowResetPosition()) {
            if (this.param.getIsNewLine().booleanValue()) {
                page.setPageX(null);
                page.setPageY(this.param.getBeginY());
            } else {
                page.setPageX(Float.valueOf(this.param.getBeginX().floatValue() + this.param.getWidth().floatValue()));
            }
        }
    }
}

