/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.DrawObject;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.state.Concatenate;
import org.apache.pdfbox.contentstream.operator.state.Restore;
import org.apache.pdfbox.contentstream.operator.state.Save;
import org.apache.pdfbox.contentstream.operator.state.SetGraphicsStateParameters;
import org.apache.pdfbox.contentstream.operator.state.SetMatrix;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitRectangleDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageFitWidthDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.util.XEasyPdfConvertUtil;

public class XEasyPdfDocumentAnalyzer
implements Serializable {
    private static final long serialVersionUID = -5122489986081853881L;
    private static final Log log = LogFactory.getLog(XEasyPdfDocumentAnalyzer.class);
    private final transient PDDocument document;
    private final XEasyPdfDocument pdfDocument;
    private transient List<TextInfo> textInfoList;
    private transient List<ImageInfo> imageInfoList;
    private transient List<BookmarkInfo> bookmarkInfoList;

    XEasyPdfDocumentAnalyzer(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.build(true);
        this.pdfDocument.getParam().setIsReset(Boolean.TRUE);
    }

    public XEasyPdfDocumentAnalyzer analyzeText(int ... pageIndex) {
        TextAnalyzer analyzer = new TextAnalyzer(this.document);
        if (pageIndex == null || pageIndex.length == 0) {
            int count = this.document.getNumberOfPages();
            for (int i = 0; i < count; ++i) {
                analyzer.processText(i);
            }
        } else {
            for (int index : pageIndex) {
                if (index < 0) continue;
                analyzer.processText(index);
            }
        }
        this.textInfoList = analyzer.textInfoList;
        return this;
    }

    public XEasyPdfDocumentAnalyzer analyzeImage(int ... pageIndex) {
        ImageAnalyzer imageAnalyzer = new ImageAnalyzer();
        PDPageTree pages = this.document.getPages();
        if (pageIndex == null || pageIndex.length == 0) {
            int count = pages.getCount();
            for (int i = 0; i < count; ++i) {
                imageAnalyzer.processImage(i, pages.get(i));
            }
        } else {
            for (int index : pageIndex) {
                if (index < 0) continue;
                imageAnalyzer.processImage(index, pages.get(index));
            }
        }
        this.imageInfoList = imageAnalyzer.imageInfoList;
        return this;
    }

    public XEasyPdfDocumentAnalyzer analyzeBookmark(int ... bookmarkIndex) {
        this.bookmarkInfoList = this.processOutlineItem(this.document.getDocumentCatalog(), bookmarkIndex);
        return this;
    }

    public List<TextInfo> getTextInfoList() {
        return this.textInfoList;
    }

    public List<ImageInfo> getImageInfoList() {
        return this.imageInfoList;
    }

    public List<BookmarkInfo> getBookmarkInfoList() {
        return this.bookmarkInfoList;
    }

    public void finish() {
        this.pdfDocument.close();
    }

    private List<BookmarkInfo> processOutlineItem(PDDocumentCatalog documentCatalog, int ... bookmarkIndex) {
        ArrayList<BookmarkInfo> list = new ArrayList<BookmarkInfo>(16);
        PDDocumentOutline documentOutline = documentCatalog.getDocumentOutline();
        if (documentOutline != null) {
            List<PDOutlineItem> itemList = XEasyPdfConvertUtil.toList(documentOutline.children());
            if (bookmarkIndex != null && bookmarkIndex.length > 0) {
                for (int index : bookmarkIndex) {
                    if (index <= 0) continue;
                    this.processOutlineItem(list, documentCatalog, itemList.get(index));
                }
            } else {
                for (PDOutlineItem outlineItem : itemList) {
                    this.processOutlineItem(list, documentCatalog, outlineItem);
                }
            }
        }
        return list;
    }

    private void processOutlineItem(List<BookmarkInfo> list, PDDocumentCatalog documentCatalog, PDOutlineItem outlineItem) {
        PDDestination destination = this.processDestination(outlineItem);
        if (destination == null) {
            return;
        }
        if (this.processPageDestination(list, outlineItem, destination)) {
            return;
        }
        this.processNamedDestination(list, documentCatalog, destination);
        this.processBookmarkInfo(list);
    }

    private PDDestination processDestination(PDOutlineItem outlineItem) {
        PDAction action;
        PDDestination destination = outlineItem.getDestination();
        if (destination == null && (action = outlineItem.getAction()) instanceof PDActionGoTo) {
            destination = ((PDActionGoTo)action).getDestination();
        }
        return destination;
    }

    private boolean processPageDestination(List<BookmarkInfo> list, PDOutlineItem outlineItem, PDDestination destination) {
        if (destination instanceof PDPageDestination) {
            BookmarkInfo info = BookmarkInfo.builder().build();
            if (destination instanceof PDPageXYZDestination) {
                PDPageXYZDestination xyzDestination = (PDPageXYZDestination)destination;
                info.setTitle(outlineItem.getTitle());
                info.setBeginPageIndex(xyzDestination.retrievePageNumber());
                info.setBeginPageTopY(xyzDestination.getTop());
                list.add(info);
                return true;
            }
            if (destination instanceof PDPageFitWidthDestination) {
                PDPageFitWidthDestination xyzDestination = (PDPageFitWidthDestination)destination;
                info.setBeginPageIndex(xyzDestination.retrievePageNumber());
                info.setBeginPageTopY(xyzDestination.getTop());
                list.add(info);
                return true;
            }
            if (destination instanceof PDPageFitRectangleDestination) {
                PDPageFitRectangleDestination xyzDestination = (PDPageFitRectangleDestination)destination;
                info.setBeginPageIndex(xyzDestination.retrievePageNumber());
                info.setBeginPageTopY(xyzDestination.getTop());
                list.add(info);
                return true;
            }
        }
        return false;
    }

    private void processNamedDestination(List<BookmarkInfo> list, PDDocumentCatalog documentCatalog, PDDestination destination) {
        if (destination instanceof PDNamedDestination) {
            BookmarkInfo info = BookmarkInfo.builder().build();
            PDPageDestination pageDestination = documentCatalog.findNamedDestinationPage((PDNamedDestination)destination);
            if (pageDestination != null) {
                info.setBeginPageIndex(pageDestination.retrievePageNumber());
                list.add(info);
            }
        }
    }

    private void processBookmarkInfo(List<BookmarkInfo> list) {
        if (!list.isEmpty()) {
            PDPageTree pages = this.document.getPages();
            int maxIndex = list.size() - 1;
            if (maxIndex == 0) {
                BookmarkInfo bookmarkInfo = list.get(0);
                bookmarkInfo.setEndPageIndex(0);
                bookmarkInfo.setBeginPageTopY((int)pages.get(bookmarkInfo.getBeginPageIndex().intValue()).getMediaBox().getHeight());
                bookmarkInfo.setBeginPageBottomY(0);
                bookmarkInfo.setEndPageTopY(bookmarkInfo.getBeginPageTopY());
                bookmarkInfo.setEndPageBottomY(0);
            } else {
                for (int i = 0; i <= maxIndex; ++i) {
                    BookmarkInfo current = list.get(i);
                    if (i == maxIndex) {
                        current.setBeginPageBottomY(0);
                        current.setEndPageIndex(pages.getCount() - 1);
                        current.setEndPageTopY((int)pages.get(current.getEndPageIndex().intValue()).getMediaBox().getHeight());
                        current.setEndPageBottomY(0);
                    } else {
                        BookmarkInfo next = list.get(i + 1);
                        if (current.getBeginPageIndex().equals(next.getBeginPageIndex())) {
                            current.setBeginPageBottomY(next.getBeginPageTopY());
                            current.setEndPageIndex(current.getBeginPageIndex());
                            current.setEndPageTopY(current.getBeginPageTopY());
                            current.setEndPageBottomY(current.getBeginPageBottomY());
                        } else {
                            current.setBeginPageBottomY(0);
                            current.setEndPageIndex(next.getBeginPageIndex());
                            current.setEndPageTopY((int)pages.get(current.getEndPageIndex().intValue()).getMediaBox().getHeight());
                            current.setEndPageBottomY(next.getBeginPageTopY());
                        }
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("\n********************************************ANALYZE BOOKMARK BEGIN********************************************\ntitle: " + current.getTitle() + "\nbegin page index: " + current.getBeginPageIndex() + "\nend page index: " + current.getEndPageIndex() + "\nbegin page top y: " + current.getBeginPageTopY() + "\nbegin page bottom y: " + current.getBeginPageBottomY() + "\nend page top y: " + current.getEndPageTopY() + "\nend page bottom y: " + current.getEndPageBottomY() + "\n*********************************************ANALYZE BOOKMARK END*********************************************"));
                }
            }
        }
    }

    private static class ImageAnalyzer
    extends PDFStreamEngine
    implements Serializable {
        private static final long serialVersionUID = 2131598546867279339L;
        private Integer pageIndex;
        private Integer imageIndex;
        private final List<ImageInfo> imageInfoList = new ArrayList<ImageInfo>(16);

        ImageAnalyzer() {
            this.addOperator((OperatorProcessor)new Concatenate());
            this.addOperator((OperatorProcessor)new DrawObject());
            this.addOperator((OperatorProcessor)new SetGraphicsStateParameters());
            this.addOperator((OperatorProcessor)new Save());
            this.addOperator((OperatorProcessor)new Restore());
            this.addOperator((OperatorProcessor)new SetMatrix());
        }

        protected void processImage(int pageIndex, PDPage page) {
            this.pageIndex = pageIndex;
            this.imageIndex = 0;
            this.processPage(page);
        }

        protected void processOperator(Operator operator, List<COSBase> operands) {
            if ("Do".equals(operator.getName())) {
                PDXObject xObject = this.getResources().getXObject((COSName)operands.get(0));
                if (xObject instanceof PDImageXObject) {
                    PDImageXObject image = (PDImageXObject)xObject;
                    PDRectangle rectangle = this.getCurrentPage().getMediaBox();
                    Matrix matrix = this.getGraphicsState().getCurrentTransformationMatrix();
                    ImageInfo imageInfo = ImageInfo.builder().pageIndex(this.pageIndex).pageWidth(Float.valueOf(rectangle.getWidth())).pageHeight(Float.valueOf(rectangle.getHeight())).imageIndex(this.imageIndex).imageType(image.getSuffix()).imageRealWidth(image.getWidth()).imageRealHeight(image.getHeight()).imageDisplayWidth((int)matrix.getScalingFactorX()).imageDisplayHeight((int)matrix.getScalingFactorY()).imagePosition(this.getPosition(matrix, image.getWidth() == (int)matrix.getScalingFactorX(), image.getHeight() == (int)matrix.getScalingFactorY())).image(image.getImage()).build();
                    this.imageInfoList.add(imageInfo);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("\n********************************************ANALYZE IMAGE BEGIN********************************************\npage index: " + imageInfo.getPageIndex() + "\npage width: " + imageInfo.getPageWidth() + "\npage height: " + imageInfo.getPageHeight() + "\nimage index: " + imageInfo.getImageIndex() + "\nimage type: " + imageInfo.getImageType() + "\nimage real width: " + imageInfo.getImageRealWidth() + "\nimage real height: " + imageInfo.getImageRealHeight() + "\nimage display width: " + imageInfo.getImageDisplayWidth() + "\nimage display height: " + imageInfo.getImageDisplayHeight() + "\nimage position: " + imageInfo.getImagePosition() + "\n*********************************************ANALYZE IMAGE END*********************************************"));
                    }
                    ImageAnalyzer imageAnalyzer = this;
                    Integer n = imageAnalyzer.imageIndex;
                    Integer n2 = imageAnalyzer.imageIndex = Integer.valueOf(imageAnalyzer.imageIndex + 1);
                } else if (xObject instanceof PDFormXObject) {
                    this.showForm((PDFormXObject)xObject);
                }
            } else {
                super.processOperator(operator, operands);
            }
        }

        private String getPosition(Matrix matrix, boolean equalWidth, boolean equalHeight) {
            StringBuilder builder = new StringBuilder();
            if (equalWidth && matrix.getTranslateX() < 0.0f) {
                builder.append("0.0");
            } else {
                builder.append(matrix.getTranslateX());
            }
            builder.append(',');
            if (equalHeight && matrix.getTranslateY() < 0.0f) {
                builder.append("0.0");
            } else {
                builder.append(matrix.getTranslateY());
            }
            return builder.toString();
        }
    }

    private static class TextAnalyzer
    extends PDFTextStripper
    implements Serializable {
        private static final long serialVersionUID = 7087714696135717794L;
        private Integer pageIndex;
        private final PDDocument document;
        private final List<TextInfo> textInfoList = new ArrayList<TextInfo>(256);

        TextAnalyzer(PDDocument document) throws IOException {
            this.document = document;
            this.setSortByPosition(true);
        }

        protected void processText(int pageIndex) {
            this.pageIndex = pageIndex;
            this.setStartPage(this.pageIndex + 1);
            this.setEndPage(this.pageIndex + 1);
            try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(new ByteArrayOutputStream()));){
                this.writeText(this.document, writer);
            }
        }

        protected void writeString(String content, List<TextPosition> textPositions) {
            if (content != null && content.trim().length() > 0) {
                PDRectangle rectangle = this.getCurrentPage().getMediaBox();
                float width = rectangle.getWidth();
                float height = rectangle.getHeight();
                TextPosition begin = textPositions.get(0);
                TextPosition end = textPositions.get(textPositions.size() - 1);
                TextInfo textInfo = TextInfo.builder().pageIndex(this.pageIndex).pageWidth(Float.valueOf(width)).pageHeight(Float.valueOf(height)).fontName(this.getFontName(begin.getFont().getName())).fontSize(Float.valueOf(begin.getFontSize())).textContent(content).textBeginPosition(begin.getXDirAdj() + "," + (height - begin.getYDirAdj())).textEndPosition(end.getXDirAdj() + "," + (height - end.getYDirAdj())).textTotalWidth(Float.valueOf(end.getXDirAdj() - begin.getXDirAdj())).build();
                this.textInfoList.add(textInfo);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("\n********************************************ANALYZE TEXT BEGIN********************************************\npage index: " + textInfo.getPageIndex() + "\npage width: " + textInfo.getPageWidth() + "\npage height: " + textInfo.getPageHeight() + "\ntext font name: " + textInfo.getFontName() + "\ntext font size: " + textInfo.getFontSize() + "\ntext content: " + textInfo.getTextContent() + "\ntext begin position: " + textInfo.getTextBeginPosition() + "\ntext end position: " + textInfo.getTextEndPosition() + "\ntext total width: " + textInfo.getTextTotalWidth() + "\n*********************************************ANALYZE TEXT END*********************************************"));
                }
            }
        }

        private String getFontName(String fontName) {
            if (fontName != null) {
                return fontName.substring(fontName.indexOf(43) + 1);
            }
            return null;
        }
    }

    public static class BookmarkInfo
    implements Serializable {
        private static final long serialVersionUID = 9113863764818167947L;
        private String title;
        private Integer beginPageIndex;
        private Integer endPageIndex;
        private Integer beginPageTopY;
        private Integer beginPageBottomY;
        private Integer endPageTopY;
        private Integer endPageBottomY;

        BookmarkInfo(String title, Integer beginPageIndex, Integer endPageIndex, Integer beginPageTopY, Integer beginPageBottomY, Integer endPageTopY, Integer endPageBottomY) {
            this.title = title;
            this.beginPageIndex = beginPageIndex;
            this.endPageIndex = endPageIndex;
            this.beginPageTopY = beginPageTopY;
            this.beginPageBottomY = beginPageBottomY;
            this.endPageTopY = endPageTopY;
            this.endPageBottomY = endPageBottomY;
        }

        public static BookmarkInfoBuilder builder() {
            return new BookmarkInfoBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public Integer getBeginPageIndex() {
            return this.beginPageIndex;
        }

        public Integer getEndPageIndex() {
            return this.endPageIndex;
        }

        public Integer getBeginPageTopY() {
            return this.beginPageTopY;
        }

        public Integer getBeginPageBottomY() {
            return this.beginPageBottomY;
        }

        public Integer getEndPageTopY() {
            return this.endPageTopY;
        }

        public Integer getEndPageBottomY() {
            return this.endPageBottomY;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setBeginPageIndex(Integer beginPageIndex) {
            this.beginPageIndex = beginPageIndex;
        }

        public void setEndPageIndex(Integer endPageIndex) {
            this.endPageIndex = endPageIndex;
        }

        public void setBeginPageTopY(Integer beginPageTopY) {
            this.beginPageTopY = beginPageTopY;
        }

        public void setBeginPageBottomY(Integer beginPageBottomY) {
            this.beginPageBottomY = beginPageBottomY;
        }

        public void setEndPageTopY(Integer endPageTopY) {
            this.endPageTopY = endPageTopY;
        }

        public void setEndPageBottomY(Integer endPageBottomY) {
            this.endPageBottomY = endPageBottomY;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BookmarkInfo)) {
                return false;
            }
            BookmarkInfo other = (BookmarkInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$beginPageIndex = this.getBeginPageIndex();
            Integer other$beginPageIndex = other.getBeginPageIndex();
            if (this$beginPageIndex == null ? other$beginPageIndex != null : !((Object)this$beginPageIndex).equals(other$beginPageIndex)) {
                return false;
            }
            Integer this$endPageIndex = this.getEndPageIndex();
            Integer other$endPageIndex = other.getEndPageIndex();
            if (this$endPageIndex == null ? other$endPageIndex != null : !((Object)this$endPageIndex).equals(other$endPageIndex)) {
                return false;
            }
            Integer this$beginPageTopY = this.getBeginPageTopY();
            Integer other$beginPageTopY = other.getBeginPageTopY();
            if (this$beginPageTopY == null ? other$beginPageTopY != null : !((Object)this$beginPageTopY).equals(other$beginPageTopY)) {
                return false;
            }
            Integer this$beginPageBottomY = this.getBeginPageBottomY();
            Integer other$beginPageBottomY = other.getBeginPageBottomY();
            if (this$beginPageBottomY == null ? other$beginPageBottomY != null : !((Object)this$beginPageBottomY).equals(other$beginPageBottomY)) {
                return false;
            }
            Integer this$endPageTopY = this.getEndPageTopY();
            Integer other$endPageTopY = other.getEndPageTopY();
            if (this$endPageTopY == null ? other$endPageTopY != null : !((Object)this$endPageTopY).equals(other$endPageTopY)) {
                return false;
            }
            Integer this$endPageBottomY = this.getEndPageBottomY();
            Integer other$endPageBottomY = other.getEndPageBottomY();
            if (this$endPageBottomY == null ? other$endPageBottomY != null : !((Object)this$endPageBottomY).equals(other$endPageBottomY)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            return !(this$title == null ? other$title != null : !this$title.equals(other$title));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BookmarkInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $beginPageIndex = this.getBeginPageIndex();
            result = result * 59 + ($beginPageIndex == null ? 43 : ((Object)$beginPageIndex).hashCode());
            Integer $endPageIndex = this.getEndPageIndex();
            result = result * 59 + ($endPageIndex == null ? 43 : ((Object)$endPageIndex).hashCode());
            Integer $beginPageTopY = this.getBeginPageTopY();
            result = result * 59 + ($beginPageTopY == null ? 43 : ((Object)$beginPageTopY).hashCode());
            Integer $beginPageBottomY = this.getBeginPageBottomY();
            result = result * 59 + ($beginPageBottomY == null ? 43 : ((Object)$beginPageBottomY).hashCode());
            Integer $endPageTopY = this.getEndPageTopY();
            result = result * 59 + ($endPageTopY == null ? 43 : ((Object)$endPageTopY).hashCode());
            Integer $endPageBottomY = this.getEndPageBottomY();
            result = result * 59 + ($endPageBottomY == null ? 43 : ((Object)$endPageBottomY).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            return result;
        }

        public String toString() {
            return "XEasyPdfDocumentAnalyzer.BookmarkInfo(title=" + this.getTitle() + ", beginPageIndex=" + this.getBeginPageIndex() + ", endPageIndex=" + this.getEndPageIndex() + ", beginPageTopY=" + this.getBeginPageTopY() + ", beginPageBottomY=" + this.getBeginPageBottomY() + ", endPageTopY=" + this.getEndPageTopY() + ", endPageBottomY=" + this.getEndPageBottomY() + ")";
        }

        public static class BookmarkInfoBuilder {
            private String title;
            private Integer beginPageIndex;
            private Integer endPageIndex;
            private Integer beginPageTopY;
            private Integer beginPageBottomY;
            private Integer endPageTopY;
            private Integer endPageBottomY;

            BookmarkInfoBuilder() {
            }

            public BookmarkInfoBuilder title(String title) {
                this.title = title;
                return this;
            }

            public BookmarkInfoBuilder beginPageIndex(Integer beginPageIndex) {
                this.beginPageIndex = beginPageIndex;
                return this;
            }

            public BookmarkInfoBuilder endPageIndex(Integer endPageIndex) {
                this.endPageIndex = endPageIndex;
                return this;
            }

            public BookmarkInfoBuilder beginPageTopY(Integer beginPageTopY) {
                this.beginPageTopY = beginPageTopY;
                return this;
            }

            public BookmarkInfoBuilder beginPageBottomY(Integer beginPageBottomY) {
                this.beginPageBottomY = beginPageBottomY;
                return this;
            }

            public BookmarkInfoBuilder endPageTopY(Integer endPageTopY) {
                this.endPageTopY = endPageTopY;
                return this;
            }

            public BookmarkInfoBuilder endPageBottomY(Integer endPageBottomY) {
                this.endPageBottomY = endPageBottomY;
                return this;
            }

            public BookmarkInfo build() {
                return new BookmarkInfo(this.title, this.beginPageIndex, this.endPageIndex, this.beginPageTopY, this.beginPageBottomY, this.endPageTopY, this.endPageBottomY);
            }

            public String toString() {
                return "XEasyPdfDocumentAnalyzer.BookmarkInfo.BookmarkInfoBuilder(title=" + this.title + ", beginPageIndex=" + this.beginPageIndex + ", endPageIndex=" + this.endPageIndex + ", beginPageTopY=" + this.beginPageTopY + ", beginPageBottomY=" + this.beginPageBottomY + ", endPageTopY=" + this.endPageTopY + ", endPageBottomY=" + this.endPageBottomY + ")";
            }
        }
    }

    public static class ImageInfo
    implements Serializable {
        private static final long serialVersionUID = -3274677412926972735L;
        private Integer pageIndex;
        private Float pageWidth;
        private Float pageHeight;
        private Integer imageIndex;
        private String imageType;
        private Integer imageRealWidth;
        private Integer imageRealHeight;
        private Integer imageDisplayWidth;
        private Integer imageDisplayHeight;
        private String imagePosition;
        private BufferedImage image;

        ImageInfo(Integer pageIndex, Float pageWidth, Float pageHeight, Integer imageIndex, String imageType, Integer imageRealWidth, Integer imageRealHeight, Integer imageDisplayWidth, Integer imageDisplayHeight, String imagePosition, BufferedImage image) {
            this.pageIndex = pageIndex;
            this.pageWidth = pageWidth;
            this.pageHeight = pageHeight;
            this.imageIndex = imageIndex;
            this.imageType = imageType;
            this.imageRealWidth = imageRealWidth;
            this.imageRealHeight = imageRealHeight;
            this.imageDisplayWidth = imageDisplayWidth;
            this.imageDisplayHeight = imageDisplayHeight;
            this.imagePosition = imagePosition;
            this.image = image;
        }

        public static ImageInfoBuilder builder() {
            return new ImageInfoBuilder();
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public Float getPageWidth() {
            return this.pageWidth;
        }

        public Float getPageHeight() {
            return this.pageHeight;
        }

        public Integer getImageIndex() {
            return this.imageIndex;
        }

        public String getImageType() {
            return this.imageType;
        }

        public Integer getImageRealWidth() {
            return this.imageRealWidth;
        }

        public Integer getImageRealHeight() {
            return this.imageRealHeight;
        }

        public Integer getImageDisplayWidth() {
            return this.imageDisplayWidth;
        }

        public Integer getImageDisplayHeight() {
            return this.imageDisplayHeight;
        }

        public String getImagePosition() {
            return this.imagePosition;
        }

        public BufferedImage getImage() {
            return this.image;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public void setPageWidth(Float pageWidth) {
            this.pageWidth = pageWidth;
        }

        public void setPageHeight(Float pageHeight) {
            this.pageHeight = pageHeight;
        }

        public void setImageIndex(Integer imageIndex) {
            this.imageIndex = imageIndex;
        }

        public void setImageType(String imageType) {
            this.imageType = imageType;
        }

        public void setImageRealWidth(Integer imageRealWidth) {
            this.imageRealWidth = imageRealWidth;
        }

        public void setImageRealHeight(Integer imageRealHeight) {
            this.imageRealHeight = imageRealHeight;
        }

        public void setImageDisplayWidth(Integer imageDisplayWidth) {
            this.imageDisplayWidth = imageDisplayWidth;
        }

        public void setImageDisplayHeight(Integer imageDisplayHeight) {
            this.imageDisplayHeight = imageDisplayHeight;
        }

        public void setImagePosition(String imagePosition) {
            this.imagePosition = imagePosition;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImageInfo)) {
                return false;
            }
            ImageInfo other = (ImageInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$pageIndex = this.getPageIndex();
            Integer other$pageIndex = other.getPageIndex();
            if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
                return false;
            }
            Float this$pageWidth = this.getPageWidth();
            Float other$pageWidth = other.getPageWidth();
            if (this$pageWidth == null ? other$pageWidth != null : !((Object)this$pageWidth).equals(other$pageWidth)) {
                return false;
            }
            Float this$pageHeight = this.getPageHeight();
            Float other$pageHeight = other.getPageHeight();
            if (this$pageHeight == null ? other$pageHeight != null : !((Object)this$pageHeight).equals(other$pageHeight)) {
                return false;
            }
            Integer this$imageIndex = this.getImageIndex();
            Integer other$imageIndex = other.getImageIndex();
            if (this$imageIndex == null ? other$imageIndex != null : !((Object)this$imageIndex).equals(other$imageIndex)) {
                return false;
            }
            Integer this$imageRealWidth = this.getImageRealWidth();
            Integer other$imageRealWidth = other.getImageRealWidth();
            if (this$imageRealWidth == null ? other$imageRealWidth != null : !((Object)this$imageRealWidth).equals(other$imageRealWidth)) {
                return false;
            }
            Integer this$imageRealHeight = this.getImageRealHeight();
            Integer other$imageRealHeight = other.getImageRealHeight();
            if (this$imageRealHeight == null ? other$imageRealHeight != null : !((Object)this$imageRealHeight).equals(other$imageRealHeight)) {
                return false;
            }
            Integer this$imageDisplayWidth = this.getImageDisplayWidth();
            Integer other$imageDisplayWidth = other.getImageDisplayWidth();
            if (this$imageDisplayWidth == null ? other$imageDisplayWidth != null : !((Object)this$imageDisplayWidth).equals(other$imageDisplayWidth)) {
                return false;
            }
            Integer this$imageDisplayHeight = this.getImageDisplayHeight();
            Integer other$imageDisplayHeight = other.getImageDisplayHeight();
            if (this$imageDisplayHeight == null ? other$imageDisplayHeight != null : !((Object)this$imageDisplayHeight).equals(other$imageDisplayHeight)) {
                return false;
            }
            String this$imageType = this.getImageType();
            String other$imageType = other.getImageType();
            if (this$imageType == null ? other$imageType != null : !this$imageType.equals(other$imageType)) {
                return false;
            }
            String this$imagePosition = this.getImagePosition();
            String other$imagePosition = other.getImagePosition();
            if (this$imagePosition == null ? other$imagePosition != null : !this$imagePosition.equals(other$imagePosition)) {
                return false;
            }
            BufferedImage this$image = this.getImage();
            BufferedImage other$image = other.getImage();
            return !(this$image == null ? other$image != null : !this$image.equals(other$image));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImageInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $pageIndex = this.getPageIndex();
            result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
            Float $pageWidth = this.getPageWidth();
            result = result * 59 + ($pageWidth == null ? 43 : ((Object)$pageWidth).hashCode());
            Float $pageHeight = this.getPageHeight();
            result = result * 59 + ($pageHeight == null ? 43 : ((Object)$pageHeight).hashCode());
            Integer $imageIndex = this.getImageIndex();
            result = result * 59 + ($imageIndex == null ? 43 : ((Object)$imageIndex).hashCode());
            Integer $imageRealWidth = this.getImageRealWidth();
            result = result * 59 + ($imageRealWidth == null ? 43 : ((Object)$imageRealWidth).hashCode());
            Integer $imageRealHeight = this.getImageRealHeight();
            result = result * 59 + ($imageRealHeight == null ? 43 : ((Object)$imageRealHeight).hashCode());
            Integer $imageDisplayWidth = this.getImageDisplayWidth();
            result = result * 59 + ($imageDisplayWidth == null ? 43 : ((Object)$imageDisplayWidth).hashCode());
            Integer $imageDisplayHeight = this.getImageDisplayHeight();
            result = result * 59 + ($imageDisplayHeight == null ? 43 : ((Object)$imageDisplayHeight).hashCode());
            String $imageType = this.getImageType();
            result = result * 59 + ($imageType == null ? 43 : $imageType.hashCode());
            String $imagePosition = this.getImagePosition();
            result = result * 59 + ($imagePosition == null ? 43 : $imagePosition.hashCode());
            BufferedImage $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            return result;
        }

        public String toString() {
            return "XEasyPdfDocumentAnalyzer.ImageInfo(pageIndex=" + this.getPageIndex() + ", pageWidth=" + this.getPageWidth() + ", pageHeight=" + this.getPageHeight() + ", imageIndex=" + this.getImageIndex() + ", imageType=" + this.getImageType() + ", imageRealWidth=" + this.getImageRealWidth() + ", imageRealHeight=" + this.getImageRealHeight() + ", imageDisplayWidth=" + this.getImageDisplayWidth() + ", imageDisplayHeight=" + this.getImageDisplayHeight() + ", imagePosition=" + this.getImagePosition() + ", image=" + this.getImage() + ")";
        }

        public static class ImageInfoBuilder {
            private Integer pageIndex;
            private Float pageWidth;
            private Float pageHeight;
            private Integer imageIndex;
            private String imageType;
            private Integer imageRealWidth;
            private Integer imageRealHeight;
            private Integer imageDisplayWidth;
            private Integer imageDisplayHeight;
            private String imagePosition;
            private BufferedImage image;

            ImageInfoBuilder() {
            }

            public ImageInfoBuilder pageIndex(Integer pageIndex) {
                this.pageIndex = pageIndex;
                return this;
            }

            public ImageInfoBuilder pageWidth(Float pageWidth) {
                this.pageWidth = pageWidth;
                return this;
            }

            public ImageInfoBuilder pageHeight(Float pageHeight) {
                this.pageHeight = pageHeight;
                return this;
            }

            public ImageInfoBuilder imageIndex(Integer imageIndex) {
                this.imageIndex = imageIndex;
                return this;
            }

            public ImageInfoBuilder imageType(String imageType) {
                this.imageType = imageType;
                return this;
            }

            public ImageInfoBuilder imageRealWidth(Integer imageRealWidth) {
                this.imageRealWidth = imageRealWidth;
                return this;
            }

            public ImageInfoBuilder imageRealHeight(Integer imageRealHeight) {
                this.imageRealHeight = imageRealHeight;
                return this;
            }

            public ImageInfoBuilder imageDisplayWidth(Integer imageDisplayWidth) {
                this.imageDisplayWidth = imageDisplayWidth;
                return this;
            }

            public ImageInfoBuilder imageDisplayHeight(Integer imageDisplayHeight) {
                this.imageDisplayHeight = imageDisplayHeight;
                return this;
            }

            public ImageInfoBuilder imagePosition(String imagePosition) {
                this.imagePosition = imagePosition;
                return this;
            }

            public ImageInfoBuilder image(BufferedImage image) {
                this.image = image;
                return this;
            }

            public ImageInfo build() {
                return new ImageInfo(this.pageIndex, this.pageWidth, this.pageHeight, this.imageIndex, this.imageType, this.imageRealWidth, this.imageRealHeight, this.imageDisplayWidth, this.imageDisplayHeight, this.imagePosition, this.image);
            }

            public String toString() {
                return "XEasyPdfDocumentAnalyzer.ImageInfo.ImageInfoBuilder(pageIndex=" + this.pageIndex + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight + ", imageIndex=" + this.imageIndex + ", imageType=" + this.imageType + ", imageRealWidth=" + this.imageRealWidth + ", imageRealHeight=" + this.imageRealHeight + ", imageDisplayWidth=" + this.imageDisplayWidth + ", imageDisplayHeight=" + this.imageDisplayHeight + ", imagePosition=" + this.imagePosition + ", image=" + this.image + ")";
            }
        }
    }

    public static class TextInfo
    implements Serializable {
        private static final long serialVersionUID = 8466964755899811503L;
        private Integer pageIndex;
        private Float pageWidth;
        private Float pageHeight;
        private String fontName;
        private Float fontSize;
        private String textContent;
        private String textBeginPosition;
        private String textEndPosition;
        private Float textTotalWidth;

        TextInfo(Integer pageIndex, Float pageWidth, Float pageHeight, String fontName, Float fontSize, String textContent, String textBeginPosition, String textEndPosition, Float textTotalWidth) {
            this.pageIndex = pageIndex;
            this.pageWidth = pageWidth;
            this.pageHeight = pageHeight;
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.textContent = textContent;
            this.textBeginPosition = textBeginPosition;
            this.textEndPosition = textEndPosition;
            this.textTotalWidth = textTotalWidth;
        }

        public static TextInfoBuilder builder() {
            return new TextInfoBuilder();
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public Float getPageWidth() {
            return this.pageWidth;
        }

        public Float getPageHeight() {
            return this.pageHeight;
        }

        public String getFontName() {
            return this.fontName;
        }

        public Float getFontSize() {
            return this.fontSize;
        }

        public String getTextContent() {
            return this.textContent;
        }

        public String getTextBeginPosition() {
            return this.textBeginPosition;
        }

        public String getTextEndPosition() {
            return this.textEndPosition;
        }

        public Float getTextTotalWidth() {
            return this.textTotalWidth;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public void setPageWidth(Float pageWidth) {
            this.pageWidth = pageWidth;
        }

        public void setPageHeight(Float pageHeight) {
            this.pageHeight = pageHeight;
        }

        public void setFontName(String fontName) {
            this.fontName = fontName;
        }

        public void setFontSize(Float fontSize) {
            this.fontSize = fontSize;
        }

        public void setTextContent(String textContent) {
            this.textContent = textContent;
        }

        public void setTextBeginPosition(String textBeginPosition) {
            this.textBeginPosition = textBeginPosition;
        }

        public void setTextEndPosition(String textEndPosition) {
            this.textEndPosition = textEndPosition;
        }

        public void setTextTotalWidth(Float textTotalWidth) {
            this.textTotalWidth = textTotalWidth;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TextInfo)) {
                return false;
            }
            TextInfo other = (TextInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$pageIndex = this.getPageIndex();
            Integer other$pageIndex = other.getPageIndex();
            if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
                return false;
            }
            Float this$pageWidth = this.getPageWidth();
            Float other$pageWidth = other.getPageWidth();
            if (this$pageWidth == null ? other$pageWidth != null : !((Object)this$pageWidth).equals(other$pageWidth)) {
                return false;
            }
            Float this$pageHeight = this.getPageHeight();
            Float other$pageHeight = other.getPageHeight();
            if (this$pageHeight == null ? other$pageHeight != null : !((Object)this$pageHeight).equals(other$pageHeight)) {
                return false;
            }
            Float this$fontSize = this.getFontSize();
            Float other$fontSize = other.getFontSize();
            if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
                return false;
            }
            Float this$textTotalWidth = this.getTextTotalWidth();
            Float other$textTotalWidth = other.getTextTotalWidth();
            if (this$textTotalWidth == null ? other$textTotalWidth != null : !((Object)this$textTotalWidth).equals(other$textTotalWidth)) {
                return false;
            }
            String this$fontName = this.getFontName();
            String other$fontName = other.getFontName();
            if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
                return false;
            }
            String this$textContent = this.getTextContent();
            String other$textContent = other.getTextContent();
            if (this$textContent == null ? other$textContent != null : !this$textContent.equals(other$textContent)) {
                return false;
            }
            String this$textBeginPosition = this.getTextBeginPosition();
            String other$textBeginPosition = other.getTextBeginPosition();
            if (this$textBeginPosition == null ? other$textBeginPosition != null : !this$textBeginPosition.equals(other$textBeginPosition)) {
                return false;
            }
            String this$textEndPosition = this.getTextEndPosition();
            String other$textEndPosition = other.getTextEndPosition();
            return !(this$textEndPosition == null ? other$textEndPosition != null : !this$textEndPosition.equals(other$textEndPosition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TextInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $pageIndex = this.getPageIndex();
            result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
            Float $pageWidth = this.getPageWidth();
            result = result * 59 + ($pageWidth == null ? 43 : ((Object)$pageWidth).hashCode());
            Float $pageHeight = this.getPageHeight();
            result = result * 59 + ($pageHeight == null ? 43 : ((Object)$pageHeight).hashCode());
            Float $fontSize = this.getFontSize();
            result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
            Float $textTotalWidth = this.getTextTotalWidth();
            result = result * 59 + ($textTotalWidth == null ? 43 : ((Object)$textTotalWidth).hashCode());
            String $fontName = this.getFontName();
            result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
            String $textContent = this.getTextContent();
            result = result * 59 + ($textContent == null ? 43 : $textContent.hashCode());
            String $textBeginPosition = this.getTextBeginPosition();
            result = result * 59 + ($textBeginPosition == null ? 43 : $textBeginPosition.hashCode());
            String $textEndPosition = this.getTextEndPosition();
            result = result * 59 + ($textEndPosition == null ? 43 : $textEndPosition.hashCode());
            return result;
        }

        public String toString() {
            return "XEasyPdfDocumentAnalyzer.TextInfo(pageIndex=" + this.getPageIndex() + ", pageWidth=" + this.getPageWidth() + ", pageHeight=" + this.getPageHeight() + ", fontName=" + this.getFontName() + ", fontSize=" + this.getFontSize() + ", textContent=" + this.getTextContent() + ", textBeginPosition=" + this.getTextBeginPosition() + ", textEndPosition=" + this.getTextEndPosition() + ", textTotalWidth=" + this.getTextTotalWidth() + ")";
        }

        public static class TextInfoBuilder {
            private Integer pageIndex;
            private Float pageWidth;
            private Float pageHeight;
            private String fontName;
            private Float fontSize;
            private String textContent;
            private String textBeginPosition;
            private String textEndPosition;
            private Float textTotalWidth;

            TextInfoBuilder() {
            }

            public TextInfoBuilder pageIndex(Integer pageIndex) {
                this.pageIndex = pageIndex;
                return this;
            }

            public TextInfoBuilder pageWidth(Float pageWidth) {
                this.pageWidth = pageWidth;
                return this;
            }

            public TextInfoBuilder pageHeight(Float pageHeight) {
                this.pageHeight = pageHeight;
                return this;
            }

            public TextInfoBuilder fontName(String fontName) {
                this.fontName = fontName;
                return this;
            }

            public TextInfoBuilder fontSize(Float fontSize) {
                this.fontSize = fontSize;
                return this;
            }

            public TextInfoBuilder textContent(String textContent) {
                this.textContent = textContent;
                return this;
            }

            public TextInfoBuilder textBeginPosition(String textBeginPosition) {
                this.textBeginPosition = textBeginPosition;
                return this;
            }

            public TextInfoBuilder textEndPosition(String textEndPosition) {
                this.textEndPosition = textEndPosition;
                return this;
            }

            public TextInfoBuilder textTotalWidth(Float textTotalWidth) {
                this.textTotalWidth = textTotalWidth;
                return this;
            }

            public TextInfo build() {
                return new TextInfo(this.pageIndex, this.pageWidth, this.pageHeight, this.fontName, this.fontSize, this.textContent, this.textBeginPosition, this.textEndPosition, this.textTotalWidth);
            }

            public String toString() {
                return "XEasyPdfDocumentAnalyzer.TextInfo.TextInfoBuilder(pageIndex=" + this.pageIndex + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight + ", fontName=" + this.fontName + ", fontSize=" + this.fontSize + ", textContent=" + this.textContent + ", textBeginPosition=" + this.textBeginPosition + ", textEndPosition=" + this.textEndPosition + ", textTotalWidth=" + this.textTotalWidth + ")";
            }
        }
    }
}

