/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.io.InputStream;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;

public class XEasyPdfDocumentPermission
implements Serializable {
    private static final long serialVersionUID = 489321495313792173L;
    private final XEasyPdfDocument document;
    private ProtectionPolicy policy;
    private final AccessPermission accessPermission = new AccessPermission();
    private static final String PUBLIC_KEY_TYPE = "X.509";

    XEasyPdfDocumentPermission(XEasyPdfDocument document) {
        this.document = document;
    }

    public XEasyPdfDocumentPermission setCanPrint(boolean allowPrinting) {
        this.accessPermission.setCanPrint(allowPrinting);
        return this;
    }

    public XEasyPdfDocumentPermission setCanModify(boolean allowModifications) {
        this.accessPermission.setCanModify(allowModifications);
        return this;
    }

    public XEasyPdfDocumentPermission setCanModifyAnnotations(boolean allowAnnotationModification) {
        this.accessPermission.setCanModifyAnnotations(allowAnnotationModification);
        return this;
    }

    public XEasyPdfDocumentPermission setCanFillInForm(boolean allowFillingInForm) {
        this.accessPermission.setCanFillInForm(allowFillingInForm);
        return this;
    }

    public XEasyPdfDocumentPermission setCanExtractContent(boolean allowExtraction) {
        this.accessPermission.setCanExtractContent(allowExtraction);
        return this;
    }

    public XEasyPdfDocumentPermission setCanExtractForAccessibility(boolean allowExtraction) {
        this.accessPermission.setCanExtractForAccessibility(allowExtraction);
        return this;
    }

    public XEasyPdfDocumentPermission setCanAssembleDocument(boolean allowAssembly) {
        this.accessPermission.setCanAssembleDocument(allowAssembly);
        return this;
    }

    public XEasyPdfDocumentPermission setCanPrintDegraded(boolean canPrintDegraded) {
        this.accessPermission.setCanPrintDegraded(canPrintDegraded);
        return this;
    }

    public XEasyPdfDocumentPermission setReadOnly() {
        this.accessPermission.setReadOnly();
        return this;
    }

    public XEasyPdfDocument finish() {
        return this.finishWithStandardPolicy(false, PWLength.LENGTH_128, "", "");
    }

    public XEasyPdfDocument finishWithStandardPolicy(boolean preferAES, PWLength length, String ownerPassword, String userPassword) {
        StandardProtectionPolicy policy = new StandardProtectionPolicy(ownerPassword, userPassword, this.accessPermission);
        policy.setPreferAES(preferAES);
        policy.setEncryptionKeyLength(length.length);
        this.policy = policy;
        this.document.setPermission(this);
        return this.document;
    }

    public XEasyPdfDocument finishWithPublicKeyPolicy(InputStream certificateInputStream) throws CertificateException {
        PublicKeyRecipient recipient = new PublicKeyRecipient();
        recipient.setPermission(this.accessPermission);
        recipient.setX509((X509Certificate)CertificateFactory.getInstance(PUBLIC_KEY_TYPE).generateCertificate(certificateInputStream));
        PublicKeyProtectionPolicy policy = new PublicKeyProtectionPolicy();
        policy.addRecipient(recipient);
        this.policy = policy;
        return this.document;
    }

    ProtectionPolicy getPolicy() {
        return this.policy;
    }

    public static enum PWLength {
        LENGTH_40(40),
        LENGTH_128(128),
        LENGTH_256(256);

        private final int length;

        private PWLength(int length) {
            this.length = length;
        }
    }
}

