/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSigner;
import wiki.xsx.core.pdf.util.XEasyPdfFileUtil;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

public class XEasyPdfDocumentReplacer
implements Serializable {
    private static final long serialVersionUID = 5248577569799461988L;
    private final Log log = LogFactory.getLog(XEasyPdfDocumentReplacer.class);
    private PDDocument document;
    private XEasyPdfDocument pdfDocument;
    private Boolean isAllowReplaceCOSArray = Boolean.FALSE;
    private String fontPath;

    XEasyPdfDocumentReplacer(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.build(true);
    }

    XEasyPdfDocumentReplacer(XEasyPdfDocument pdfDocument, PDDocument target) {
        this.pdfDocument = pdfDocument;
        this.document = target;
    }

    public XEasyPdfDocumentReplacer enableReplaceCOSArray() {
        this.isAllowReplaceCOSArray = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentReplacer setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfDocumentReplacer setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.fontPath = style.getPath();
        }
        return this;
    }

    public XEasyPdfDocumentReplacer replaceText(Map<String, String> replaceMap) {
        return this.replaceText(replaceMap, (int[])null);
    }

    public XEasyPdfDocumentReplacer replaceText(Map<String, String> replaceMap, int ... pageIndex) {
        return this.replaceText(1, replaceMap, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceText(int count, Map<String, String> replaceMap, int ... pageIndex) {
        if (replaceMap != null && !replaceMap.isEmpty() && count > 0) {
            if (pageIndex == null || pageIndex.length == 0) {
                PDPageTree pages = this.document.getPages();
                for (PDPage page : pages) {
                    for (int i = 0; i < count; ++i) {
                        this.replaceText(page, replaceMap);
                    }
                }
            } else {
                for (int index : pageIndex) {
                    if (index < 0) continue;
                    for (int i = 0; i < count; ++i) {
                        this.replaceText(this.document.getPage(index), replaceMap);
                    }
                }
            }
        }
        this.isAllowReplaceCOSArray = Boolean.FALSE;
        return this;
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, int ... pageIndex) {
        return this.replaceImage(image, XEasyPdfImageType.PNG, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, XEasyPdfImageType imageType, int ... pageIndex) {
        return this.replaceImage(image, imageType, null, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, List<Integer> replaceIndexList, int ... pageIndex) {
        return this.replaceImage(image, XEasyPdfImageType.PNG, replaceIndexList, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, XEasyPdfImageType imageType, List<Integer> replaceIndexList, int ... pageIndex) {
        PDImageXObject imageObject = null;
        if (image != null) {
            imageObject = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])XEasyPdfImageUtil.toBytes(image, imageType.name()), (String)imageType.name());
        }
        return this.replaceImage(imageObject, replaceIndexList, pageIndex);
    }

    public XEasyPdfDocumentSigner signer() {
        return new XEasyPdfDocumentSigner(this.pdfDocument);
    }

    public void finish(String outputPath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(outputPath, new String[0])), new OpenOption[0]));){
            this.finish(outputStream);
        }
    }

    public void finish(OutputStream outputStream) {
        this.pdfDocument.replaceTotalPagePlaceholder(this.document, false);
        this.pdfDocument.setBasicInfo(this.document);
        this.document.save(outputStream);
        this.pdfDocument.close();
    }

    void finish() {
        this.pdfDocument = null;
        this.document = null;
    }

    void replaceText(PDPage page, Map<String, String> replaceMap) {
        block14: {
            PDFont font = this.initFont();
            PDResources resources = page.getResources();
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
            parser.parse();
            List tokens = parser.getTokens();
            if (!this.replaceTextToken(font, resources, tokens, replaceMap)) break block14;
            PDStream updatedStream = new PDStream(this.document);
            try (OutputStream outputStream = updatedStream.createOutputStream(COSName.FLATE_DECODE);){
                ContentStreamWriter tokenWriter = new ContentStreamWriter(outputStream);
                tokenWriter.writeTokens(tokens);
                page.setContents(updatedStream);
            }
            this.pdfDocument.getParam().embedFont(Collections.singleton(font));
        }
    }

    private PDFont initFont() {
        if (this.fontPath == null) {
            this.fontPath = this.pdfDocument.getFontPath();
        }
        return XEasyPdfFontUtil.loadFont(this.pdfDocument, this.fontPath, true);
    }

    private Map<COSName, PDFont> initResourceFontMap(PDResources resources) {
        HashMap<COSName, PDFont> resourceFontMap = new HashMap<COSName, PDFont>(16);
        for (COSName cosName : resources.getFontNames()) {
            resourceFontMap.put(cosName, resources.getFont(cosName));
        }
        return resourceFontMap;
    }

    private boolean replaceTextToken(PDFont font, PDResources resources, List<Object> tokens, Map<String, String> replaceMap) {
        HashMap<String, String> replaceMapTemp = new HashMap<String, String>(replaceMap);
        Map<COSName, PDFont> resourceFontMap = this.initResourceFontMap(resources);
        Set<Map.Entry<String, String>> entrySet = replaceMapTemp.entrySet();
        COSName replaceFontName = COSName.getPDFName((String)font.getName());
        int fontIndex = 0;
        PDFont resourceFont = null;
        int count = tokens.size();
        for (int i = 0; i < count; ++i) {
            Object token = tokens.get(i);
            if (token instanceof COSName) {
                if (resourceFontMap.get(token) == null) continue;
                fontIndex = i;
                resourceFont = resourceFontMap.get(token);
                continue;
            }
            if (token instanceof COSArray && this.processCOSArray(token, entrySet, resourceFont, font)) {
                tokens.set(fontIndex, replaceFontName);
            }
            if (token instanceof COSString && this.processCOSString(false, token, entrySet, resourceFont, font)) {
                tokens.set(fontIndex, replaceFontName);
            }
            if (entrySet.isEmpty()) break;
        }
        int needReplaceCount = replaceMap.size();
        int replacedCount = needReplaceCount - replaceMapTemp.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("need replace keys: " + needReplaceCount + "\uff0creplaced keys: " + replacedCount));
        }
        if (replacedCount > 0) {
            resources.put(replaceFontName, font);
            return true;
        }
        return false;
    }

    private boolean processCOSArray(Object token, Set<Map.Entry<String, String>> entrySet, PDFont resourceFont, PDFont replaceFont) {
        boolean flag;
        block5: {
            COSArray array;
            block4: {
                if (resourceFont == null) {
                    return false;
                }
                flag = false;
                array = (COSArray)token;
                if (!this.isAllowReplaceCOSArray.booleanValue()) break block4;
                if (!this.processCOSArray(array, entrySet, resourceFont, replaceFont)) break block5;
                flag = true;
                break block5;
            }
            for (COSBase cosBase : array) {
                if (!(cosBase instanceof COSString) || !this.processCOSString(true, cosBase, entrySet, resourceFont, replaceFont)) continue;
                flag = true;
                if (!entrySet.isEmpty()) continue;
                break;
            }
        }
        return flag;
    }

    private boolean processCOSArray(COSArray array, Set<Map.Entry<String, String>> entrySet, PDFont resourceFont, PDFont replaceFont) {
        StringBuilder builder = new StringBuilder();
        for (COSBase cosBase : array) {
            if (!(cosBase instanceof COSString)) continue;
            COSString cosString = (COSString)cosBase;
            ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());
            Throwable throwable = null;
            try {
                while (((InputStream)in).available() > 0) {
                    builder.append(resourceFont.toUnicode(resourceFont.readCode((InputStream)in)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((InputStream)in).close();
            }
        }
        byte[] bytes = this.encode(true, builder.toString(), entrySet, replaceFont);
        if (bytes != null) {
            array.clear();
            array.add((COSBase)new COSString(bytes));
            return true;
        }
        return false;
    }

    private boolean processCOSString(boolean isArray, Object token, Set<Map.Entry<String, String>> entrySet, PDFont resourceFont, PDFont replaceFont) {
        if (resourceFont == null) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        COSString cosString = (COSString)token;
        try (ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());){
            while (((InputStream)in).available() > 0) {
                builder.append(resourceFont.toUnicode(resourceFont.readCode((InputStream)in)));
            }
        }
        byte[] bytes = this.encode(isArray, builder.toString(), entrySet, replaceFont);
        if (bytes != null) {
            cosString.setValue(bytes);
            return true;
        }
        return false;
    }

    private byte[] encode(boolean isArray, String value, Set<Map.Entry<String, String>> entrySet, PDFont font) {
        if (this.log.isDebugEnabled()) {
            if (isArray) {
                this.log.debug((Object)("current string for array: " + value));
            } else {
                this.log.debug((Object)("current string: " + value));
            }
        }
        int count = entrySet.size();
        if (value.trim().length() > 0) {
            Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String temp = value.replaceFirst(entry.getKey(), entry.getValue());
                if (value.equals(temp)) continue;
                value = temp;
                iterator.remove();
            }
        }
        if (count > entrySet.size()) {
            XEasyPdfFontUtil.addToSubset(font, value);
            return font.encode(value);
        }
        return null;
    }

    private XEasyPdfDocumentReplacer replaceImage(PDImageXObject image, List<Integer> replaceIndexList, int ... pageIndex) {
        PDPageTree pages = this.document.getPages();
        if (pageIndex == null || pageIndex.length == 0) {
            for (PDPage page : pages) {
                this.replaceImage(page.getResources(), image, replaceIndexList);
            }
        } else {
            for (int index : pageIndex) {
                if (index < 0) continue;
                this.replaceImage(pages.get(index).getResources(), image, replaceIndexList);
            }
        }
        return this;
    }

    private void replaceImage(PDResources resources, PDImageXObject image, List<Integer> replaceIndexList) {
        block7: {
            Iterable objectNames = resources.getXObjectNames();
            if (replaceIndexList == null || replaceIndexList.isEmpty()) {
                for (COSName cosName : objectNames) {
                    if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                    resources.put(cosName, (PDXObject)image);
                }
                break block7;
            }
            Iterator<Integer> iterator = new TreeSet<Integer>(replaceIndexList).iterator();
            int index = 0;
            int replaceIndex = iterator.next();
            for (COSName cosName : objectNames) {
                if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                if (index == replaceIndex) {
                    resources.put(cosName, (PDXObject)image);
                    if (!iterator.hasNext()) break;
                    replaceIndex = iterator.next();
                }
                ++index;
            }
        }
    }
}

