/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.handler;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.barcode.XEasyPdfBarCode;
import wiki.xsx.core.pdf.component.circle.XEasyPdfCircle;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.component.image.XEasyPdfSVGImage;
import wiki.xsx.core.pdf.component.layout.XEasyPdfHorizontalLayout;
import wiki.xsx.core.pdf.component.layout.XEasyPdfLayoutComponent;
import wiki.xsx.core.pdf.component.layout.XEasyPdfVerticalLayout;
import wiki.xsx.core.pdf.component.line.XEasyPdfBaseLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfDottedSplitLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfSolidSplitLine;
import wiki.xsx.core.pdf.component.rect.XEasyPdfRect;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextExtend;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextScript;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPageRectangle;
import wiki.xsx.core.pdf.footer.XEasyPdfDefaultFooter;
import wiki.xsx.core.pdf.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.header.XEasyPdfDefaultHeader;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.mark.XEasyPdfDefaultWatermark;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfHandler {

    public static enum FontMappingPolicy {
        DEFAULT,
        ALL;


        public static String key() {
            return "x-easypdf.font.mapping";
        }
    }

    public static class Font {
        public static final XEasyPdfDefaultFontStyle LIGHT = XEasyPdfDefaultFontStyle.LIGHT;
        public static final XEasyPdfDefaultFontStyle NORMAL = XEasyPdfDefaultFontStyle.NORMAL;
        public static final XEasyPdfDefaultFontStyle BOLD = XEasyPdfDefaultFontStyle.BOLD;

        public static void addFont(String fontPath) {
            XEasyPdfFontUtil.addFont(fontPath);
        }

        public static void enableSystemFontMapping() {
            System.setProperty(FontMappingPolicy.key(), FontMappingPolicy.ALL.name());
        }
    }

    public static class Layout {

        public static class Component {
            public static XEasyPdfLayoutComponent build(float width, float height) {
                return new XEasyPdfLayoutComponent(Float.valueOf(width), Float.valueOf(height));
            }

            public static XEasyPdfLayoutComponent build(float width, float height, XEasyPdfComponent component) {
                return new XEasyPdfLayoutComponent(Float.valueOf(width), Float.valueOf(height)).setComponent(component);
            }
        }

        public static class Vertical {
            public static XEasyPdfVerticalLayout build() {
                return new XEasyPdfVerticalLayout();
            }
        }

        public static class Horizontal {
            public static XEasyPdfHorizontalLayout build() {
                return new XEasyPdfHorizontalLayout();
            }
        }
    }

    public static class Footer {
        public static XEasyPdfFooter build(XEasyPdfComponent component) {
            return new XEasyPdfDefaultFooter(component);
        }

        public static XEasyPdfFooter build(XEasyPdfText text) {
            return new XEasyPdfDefaultFooter(text);
        }

        public static XEasyPdfFooter build(XEasyPdfImage image) {
            return new XEasyPdfDefaultFooter(image);
        }

        public static XEasyPdfFooter build(XEasyPdfImage image, XEasyPdfText text) {
            return new XEasyPdfDefaultFooter(image, text);
        }

        public static XEasyPdfFooter build(XEasyPdfText text, XEasyPdfImage image) {
            return new XEasyPdfDefaultFooter(image, text);
        }
    }

    public static class Header {
        public static XEasyPdfHeader build() {
            return new XEasyPdfDefaultHeader();
        }

        public static XEasyPdfHeader build(XEasyPdfComponent component) {
            return new XEasyPdfDefaultHeader(component);
        }

        public static XEasyPdfHeader build(XEasyPdfText text) {
            return new XEasyPdfDefaultHeader(text);
        }

        public static XEasyPdfHeader build(XEasyPdfImage image) {
            return new XEasyPdfDefaultHeader(image);
        }

        public static XEasyPdfHeader build(XEasyPdfImage image, XEasyPdfText text) {
            return new XEasyPdfDefaultHeader(image, text);
        }

        public static XEasyPdfHeader build(XEasyPdfText text, XEasyPdfImage image) {
            return new XEasyPdfDefaultHeader(image, text);
        }
    }

    public static class Table {
        public static XEasyPdfTable build(XEasyPdfRow ... rows) {
            return new XEasyPdfTable(rows);
        }

        public static XEasyPdfTable build(List<XEasyPdfRow> rowList) {
            return new XEasyPdfTable(rowList);
        }

        public static class Row {
            public static XEasyPdfRow build(XEasyPdfCell ... cells) {
                return new XEasyPdfRow(cells);
            }

            public static XEasyPdfRow build(List<XEasyPdfCell> cellList) {
                return new XEasyPdfRow(cellList);
            }

            public static class Cell {
                public static XEasyPdfCell build(float width) {
                    return new XEasyPdfCell(width);
                }

                public static XEasyPdfCell build(float width, float height) {
                    return new XEasyPdfCell(width, height);
                }
            }
        }
    }

    public static class Circle {
        public static XEasyPdfCircle build(float radius) {
            return new XEasyPdfCircle(radius);
        }

        public static XEasyPdfCircle build(float radius, float beginX, float beginY) {
            return new XEasyPdfCircle(radius, Float.valueOf(beginX), Float.valueOf(beginY));
        }
    }

    public static class Rect {
        public static XEasyPdfRect build(float width, float height) {
            return new XEasyPdfRect(width, height);
        }

        public static XEasyPdfRect build(float width, float height, float beginX, float beginY) {
            return new XEasyPdfRect(width, height, Float.valueOf(beginX), Float.valueOf(beginY));
        }
    }

    public static class BarCode {
        public static XEasyPdfBarCode build(XEasyPdfBarCode.CodeType codeType, String content) {
            return new XEasyPdfBarCode(codeType, content);
        }

        public static XEasyPdfBarCode build(XEasyPdfBarCode.CodeType codeType, String content, String words) {
            return new XEasyPdfBarCode(codeType, content, words);
        }

        public static XEasyPdfBarCode build(XEasyPdfBarCode.CodeType codeType, String content, float beginX, float beginY) {
            return new XEasyPdfBarCode(codeType, content, beginX, beginY);
        }

        public static XEasyPdfBarCode build(XEasyPdfBarCode.CodeType codeType, String content, String words, float beginX, float beginY) {
            return new XEasyPdfBarCode(codeType, content, words, beginX, beginY);
        }
    }

    public static class SVGImage {
        public static XEasyPdfSVGImage build() {
            return new XEasyPdfSVGImage();
        }
    }

    public static class Image {
        public static XEasyPdfImage build(File image) {
            return new XEasyPdfImage(image);
        }

        public static XEasyPdfImage build(InputStream imageInputStream, XEasyPdfImageType imageType) {
            return new XEasyPdfImage(imageInputStream, imageType);
        }

        public static XEasyPdfImage build(File image, int width, int height) {
            return new XEasyPdfImage(image, width, height);
        }

        public static XEasyPdfImage build(InputStream imageInputStream, XEasyPdfImageType imageType, int width, int height) {
            return new XEasyPdfImage(imageInputStream, imageType, width, height);
        }
    }

    public static class SplitLine {

        public static class DottedLine {
            public static XEasyPdfDottedSplitLine build() {
                return new XEasyPdfDottedSplitLine();
            }
        }

        public static class SolidLine {
            public static XEasyPdfSolidSplitLine build() {
                return new XEasyPdfSolidSplitLine();
            }
        }
    }

    public static class Line {
        public static XEasyPdfBaseLine build(float beginX, float beginY, float endX, float endY) {
            return new XEasyPdfBaseLine(beginX, beginY, endX, endY);
        }
    }

    public static class TextScript {
        public static XEasyPdfTextScript build(String text) {
            return new XEasyPdfTextScript(text);
        }
    }

    public static class TextExtend {
        public static XEasyPdfTextExtend build(String text) {
            return new XEasyPdfTextExtend(text);
        }

        public static XEasyPdfTextExtend build(String text, String scriptText) {
            return new XEasyPdfTextExtend(text, scriptText);
        }
    }

    public static class Text {
        public static XEasyPdfText build(String text) {
            return new XEasyPdfText(text);
        }

        public static XEasyPdfText build(List<String> textList) {
            return new XEasyPdfText(textList);
        }

        public static XEasyPdfText build(float fontSize, String text) {
            return new XEasyPdfText(fontSize, text);
        }

        public static XEasyPdfText build(float fontSize, List<String> textList) {
            return new XEasyPdfText(fontSize, textList);
        }
    }

    public static class Watermark {
        public static XEasyPdfDefaultWatermark build(String text) {
            return new XEasyPdfDefaultWatermark(text);
        }

        public static XEasyPdfDefaultWatermark build(float fontSize, String text) {
            return new XEasyPdfDefaultWatermark(fontSize, text);
        }
    }

    public static class Page {
        private static final String TOTAL_PAGE_PLACEHOLDER = "${TPN}";
        private static final String CURRENT_PAGE_PLACEHOLDER = "${CPN}";

        public static XEasyPdfPage build(List<XEasyPdfComponent> components) {
            return new XEasyPdfPage(null).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfComponent ... components) {
            return new XEasyPdfPage(null).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfDefaultWatermark watermark, XEasyPdfComponent ... components) {
            return new XEasyPdfPage(null).setWatermark(watermark).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfDefaultWatermark watermark, List<XEasyPdfComponent> components) {
            return new XEasyPdfPage(null).setWatermark(watermark).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfPageRectangle pageSize, XEasyPdfComponent ... components) {
            return new XEasyPdfPage(pageSize).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfPageRectangle pageSize, List<XEasyPdfComponent> components) {
            return new XEasyPdfPage(pageSize).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfPageRectangle pageSize, XEasyPdfDefaultWatermark watermark, XEasyPdfComponent ... components) {
            return new XEasyPdfPage(pageSize).setWatermark(watermark).addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfPageRectangle pageSize, XEasyPdfDefaultWatermark watermark, List<XEasyPdfComponent> components) {
            return new XEasyPdfPage(pageSize).setWatermark(watermark).addComponent(components);
        }

        public static String getTotalPagePlaceholder() {
            return TOTAL_PAGE_PLACEHOLDER;
        }

        public static String getCurrentPagePlaceholder() {
            return CURRENT_PAGE_PLACEHOLDER;
        }

        public static class Rectangle {
            public static final XEasyPdfPageRectangle A0 = XEasyPdfPageRectangle.A0;
            public static final XEasyPdfPageRectangle A1 = XEasyPdfPageRectangle.A1;
            public static final XEasyPdfPageRectangle A2 = XEasyPdfPageRectangle.A2;
            public static final XEasyPdfPageRectangle A3 = XEasyPdfPageRectangle.A3;
            public static final XEasyPdfPageRectangle A4 = XEasyPdfPageRectangle.A4;
            public static final XEasyPdfPageRectangle A5 = XEasyPdfPageRectangle.A5;
            public static final XEasyPdfPageRectangle A6 = XEasyPdfPageRectangle.A6;
            public static final XEasyPdfPageRectangle A7 = XEasyPdfPageRectangle.A7;
            public static final XEasyPdfPageRectangle A8 = XEasyPdfPageRectangle.A8;
            public static final XEasyPdfPageRectangle B0 = XEasyPdfPageRectangle.B0;
            public static final XEasyPdfPageRectangle B1 = XEasyPdfPageRectangle.B1;
            public static final XEasyPdfPageRectangle B2 = XEasyPdfPageRectangle.B2;
            public static final XEasyPdfPageRectangle B3 = XEasyPdfPageRectangle.B3;
            public static final XEasyPdfPageRectangle B4 = XEasyPdfPageRectangle.B4;
            public static final XEasyPdfPageRectangle B5 = XEasyPdfPageRectangle.B5;
            public static final XEasyPdfPageRectangle B6 = XEasyPdfPageRectangle.B6;
            public static final XEasyPdfPageRectangle B7 = XEasyPdfPageRectangle.B7;
            public static final XEasyPdfPageRectangle B8 = XEasyPdfPageRectangle.B8;
        }
    }

    public static class Document {
        public static XEasyPdfDocument build() {
            return new XEasyPdfDocument();
        }

        public static XEasyPdfDocument build(XEasyPdfPage ... pages) {
            return new XEasyPdfDocument().addPage(pages);
        }

        public static XEasyPdfDocument build(List<XEasyPdfPage> pages) {
            return new XEasyPdfDocument().addPage(pages);
        }

        public static XEasyPdfDocument load(String sourcePath) {
            return new XEasyPdfDocument(sourcePath);
        }

        public static XEasyPdfDocument load(String sourcePath, String password) {
            return new XEasyPdfDocument(sourcePath, password);
        }

        public static XEasyPdfDocument load(String sourcePath, String password, InputStream keyStore, String alias) {
            return new XEasyPdfDocument(sourcePath, password, keyStore, alias);
        }

        public static XEasyPdfDocument load(InputStream sourceInputStream) {
            return new XEasyPdfDocument(sourceInputStream);
        }

        public static XEasyPdfDocument load(InputStream sourceInputStream, String password) {
            return new XEasyPdfDocument(sourceInputStream, password);
        }

        public static XEasyPdfDocument load(InputStream sourceInputStream, String password, InputStream keyStore, String alias) {
            return new XEasyPdfDocument(sourceInputStream, password, keyStore, alias);
        }
    }
}

