/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import org.apache.fontbox.ttf.OTFParser;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.handler.XEasyPdfFontMapperHandler;

public class XEasyPdfFontUtil {
    private static final String TTF = ".ttf";
    private static final String TTC = ".ttc";
    private static final String OTF = ".otf";
    private static final String COLLECTION_FONT_SEPARATOR = ",";
    private static final Object TTF_LOCK = new Object();
    private static final Object TTC_LOCK = new Object();
    private static final Object OTF_LOCK = new Object();

    public static float getFontHeight(PDFont font, float fontSize) {
        return font.getFontDescriptor().getCapHeight() / 1000.0f * fontSize;
    }

    public static void addToSubset(PDFont font, String text) {
        if (font != null && font.willBeSubset()) {
            int codePoint;
            int length = text.length();
            for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
                codePoint = text.codePointAt(offset);
                font.addToSubset(codePoint);
            }
        }
    }

    public static void addFont(String fontPath) {
        try {
            String lowerPath = fontPath.toLowerCase(Locale.ROOT);
            if (lowerPath.endsWith(TTF)) {
                XEasyPdfFontUtil.addAndGetTTFFont(fontPath);
            }
            if (lowerPath.contains(TTC)) {
                XEasyPdfFontUtil.addAndGetTTCFont(fontPath);
            }
            if (lowerPath.endsWith(OTF)) {
                XEasyPdfFontUtil.addAndGetOTFFont(fontPath);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the font can not be loaded\uff0cthe path['" + fontPath + "'] is error");
        }
    }

    public static PDFont getFont(XEasyPdfDocument document, String fontPath, PDFont defaultFont) {
        if (fontPath != null) {
            return XEasyPdfFontUtil.loadFont(document, fontPath, true);
        }
        return defaultFont;
    }

    public static PDFont loadFont(XEasyPdfDocument document, XEasyPdfPage page, String fontPath, boolean isEmbedded) {
        if (fontPath != null) {
            return XEasyPdfFontUtil.loadFont(document, fontPath, isEmbedded);
        }
        return XEasyPdfFontUtil.loadFont(document, page);
    }

    public static PDFont loadFont(XEasyPdfDocument document, String fontPath, boolean isEmbedded) {
        if (fontPath != null) {
            PDFont font;
            if (isEmbedded && (font = document.getFont(fontPath)) != null) {
                return font;
            }
            String lowerPath = fontPath.toLowerCase(Locale.ROOT);
            if (lowerPath.endsWith(TTF)) {
                return XEasyPdfFontUtil.loadTTF(document, fontPath, isEmbedded);
            }
            if (lowerPath.contains(TTC)) {
                return XEasyPdfFontUtil.loadTTC(document, fontPath, isEmbedded);
            }
            if (lowerPath.endsWith(OTF)) {
                return XEasyPdfFontUtil.loadOTF(document, fontPath);
            }
        }
        throw new IllegalArgumentException("the font can not be loaded\uff0cthe path['" + fontPath + "'] is error");
    }

    private static PDFont loadFont(XEasyPdfDocument document, XEasyPdfPage page) {
        PDFont font = null;
        if (page != null) {
            font = page.getFont();
        } else if (document != null) {
            font = document.getFont();
        }
        if (font == null) {
            throw new IllegalArgumentException("the font can not be found");
        }
        return font;
    }

    private static PDFont loadTTF(XEasyPdfDocument document, String fontPath, boolean isEmbedded) {
        try {
            PDType0Font font = PDType0Font.load((PDDocument)document.getTarget(), (TrueTypeFont)XEasyPdfFontUtil.addAndGetTTFFont(fontPath), (boolean)isEmbedded);
            if (isEmbedded) {
                document.addFont(fontPath, (PDFont)font);
            }
            return font;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the font can not be loaded\uff0cthe path['" + fontPath + "'] is error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrueTypeFont addAndGetTTFFont(String fontPath) {
        TrueTypeFont trueTypeFont = (TrueTypeFont)XEasyPdfFontMapperHandler.getInstance().getFontByPath(fontPath);
        if (trueTypeFont == null) {
            Object object = TTF_LOCK;
            synchronized (object) {
                trueTypeFont = (TrueTypeFont)XEasyPdfFontMapperHandler.getInstance().getFontByPath(fontPath);
                if (trueTypeFont == null) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(XEasyPdfFontUtil.class.getResourceAsStream(fontPath));){
                        trueTypeFont = new TTFParser(true, true).parse((InputStream)inputStream);
                    }
                    catch (Exception e) {
                        try (BufferedInputStream inputStream2 = new BufferedInputStream(Files.newInputStream(Paths.get(fontPath, new String[0]), new OpenOption[0]));){
                            trueTypeFont = new TTFParser(true, true).parse((InputStream)inputStream2);
                        }
                    }
                    XEasyPdfFontMapperHandler.getInstance().addFont(fontPath, trueTypeFont);
                }
            }
        }
        return trueTypeFont;
    }

    private static PDFont loadTTC(XEasyPdfDocument document, String fontPath, boolean isEmbedded) {
        try {
            PDType0Font font = PDType0Font.load((PDDocument)document.getTarget(), (TrueTypeFont)XEasyPdfFontUtil.addAndGetTTCFont(fontPath), (boolean)isEmbedded);
            if (isEmbedded) {
                document.addFont(fontPath, (PDFont)font);
            }
            return font;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the font can not be loaded\uff0cthe path['" + fontPath + "'] is error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrueTypeFont addAndGetTTCFont(String fontPath) {
        int length = 2;
        String[] fontPathSplit = fontPath.split(COLLECTION_FONT_SEPARATOR);
        if (fontPathSplit.length != 2) {
            throw new IllegalArgumentException();
        }
        TrueTypeFont trueTypeFont = (TrueTypeFont)XEasyPdfFontMapperHandler.getInstance().getFontByPath(fontPath);
        if (trueTypeFont == null) {
            Object object = TTC_LOCK;
            synchronized (object) {
                trueTypeFont = (TrueTypeFont)XEasyPdfFontMapperHandler.getInstance().getFontByPath(fontPath);
                if (trueTypeFont == null) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(XEasyPdfFontUtil.class.getResourceAsStream(fontPathSplit[0]));){
                        TrueTypeCollection trueTypeCollection = new TrueTypeCollection((InputStream)inputStream);
                        Method method = trueTypeCollection.getClass().getDeclaredMethod("getFontAtIndex", Integer.TYPE);
                        method.setAccessible(true);
                        trueTypeFont = (TrueTypeFont)method.invoke((Object)trueTypeCollection, Integer.parseInt(fontPathSplit[1]));
                    }
                    catch (Exception e) {
                        try (BufferedInputStream inputStream2 = new BufferedInputStream(Files.newInputStream(Paths.get(fontPathSplit[0], new String[0]), new OpenOption[0]));){
                            TrueTypeCollection trueTypeCollection = new TrueTypeCollection((InputStream)inputStream2);
                            Method method = trueTypeCollection.getClass().getDeclaredMethod("getFontAtIndex", Integer.TYPE);
                            method.setAccessible(true);
                            trueTypeFont = (TrueTypeFont)method.invoke((Object)trueTypeCollection, Integer.parseInt(fontPathSplit[1]));
                        }
                    }
                    XEasyPdfFontMapperHandler.getInstance().addFont(fontPath, trueTypeFont);
                }
            }
        }
        return trueTypeFont;
    }

    private static PDFont loadOTF(XEasyPdfDocument document, String fontPath) {
        try {
            PDFont font = document.getOtfFont(fontPath);
            if (font != null) {
                return font;
            }
            font = PDType0Font.load((PDDocument)document.getTarget(), (TrueTypeFont)XEasyPdfFontUtil.addAndGetOTFFont(fontPath), (boolean)false);
            document.addOtfFont(fontPath, font);
            return font;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("the font can not be loaded\uff0cthe path['" + fontPath + "'] is error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrueTypeFont addAndGetOTFFont(String fontPath) {
        TrueTypeFont trueTypeFont = (TrueTypeFont)XEasyPdfFontMapperHandler.getInstance().getFontByPath(fontPath);
        if (trueTypeFont == null) {
            Object object = OTF_LOCK;
            synchronized (object) {
                trueTypeFont = (TrueTypeFont)XEasyPdfFontMapperHandler.getInstance().getFontByPath(fontPath);
                if (trueTypeFont == null) {
                    try (BufferedInputStream inputStream = new BufferedInputStream(XEasyPdfFontUtil.class.getResourceAsStream(fontPath));){
                        trueTypeFont = new OTFParser(false, true).parse((InputStream)inputStream);
                    }
                    catch (Exception e) {
                        try (BufferedInputStream inputStream2 = new BufferedInputStream(Files.newInputStream(Paths.get(fontPath, new String[0]), new OpenOption[0]));){
                            trueTypeFont = new OTFParser(false, true).parse((InputStream)inputStream2);
                        }
                    }
                    XEasyPdfFontMapperHandler.getInstance().addFont(fontPath, trueTypeFont);
                }
            }
        }
        return trueTypeFont;
    }
}

