/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.barcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.barcode.XEasyPdfBarCodeParam;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

public class XEasyPdfBarCode
implements XEasyPdfComponent {
    private static final long serialVersionUID = 5127121806423508565L;
    private final XEasyPdfBarCodeParam param = new XEasyPdfBarCodeParam();

    public XEasyPdfBarCode(CodeType codeType, String content) {
        this(codeType, content, null);
    }

    public XEasyPdfBarCode(CodeType codeType, String content, String words) {
        if (codeType != null) {
            this.param.setCodeType(codeType);
        }
        this.param.setContent(content).setWords(words);
    }

    public XEasyPdfBarCode(CodeType codeType, String content, float beginX, float beginY) {
        this(codeType, content, null, beginX, beginY);
    }

    public XEasyPdfBarCode(CodeType codeType, String content, String words, float beginX, float beginY) {
        if (codeType != null) {
            this.param.setCodeType(codeType);
        }
        this.param.setContent(content).setWords(words).setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
    }

    @Override
    public XEasyPdfBarCode setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfBarCode setWidth(float width) {
        this.param.setImageWidth((int)Math.abs(width));
        return this;
    }

    @Override
    public XEasyPdfBarCode setHeight(float height) {
        this.param.setImageHeight((int)Math.abs(height));
        return this;
    }

    public XEasyPdfBarCode setMaxWidth(float width) {
        this.param.setImageMaxWidth((int)Math.abs(width));
        return this;
    }

    public XEasyPdfBarCode setMaxHeight(float height) {
        this.param.setImageMaxHeight((int)Math.abs(height));
        return this;
    }

    @Override
    public XEasyPdfBarCode setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfBarCode setCodeType(CodeType codeType) {
        this.param.setCodeType(codeType);
        return this;
    }

    public XEasyPdfBarCode setCodeMargin(int codeMargin) {
        this.param.setCodeMargin(Math.abs(codeMargin));
        return this;
    }

    public XEasyPdfBarCode setErrorLevel(ErrorLevel errorLevel) {
        if (errorLevel != null) {
            this.param.setEncodeHints(EncodeHintType.ERROR_CORRECTION, errorLevel.level);
        }
        return this;
    }

    public XEasyPdfBarCode setQrVersion(int version) {
        boolean min = false;
        int max = 41;
        if (version <= 0 || version >= 41) {
            throw new IllegalArgumentException("the version must be between 1 and 40");
        }
        this.param.setEncodeHints(EncodeHintType.QR_VERSION, version);
        return this;
    }

    public XEasyPdfBarCode setContent(String content) {
        this.param.setContent(content);
        return this;
    }

    public XEasyPdfBarCode setOnColor(Color onColor) {
        if (onColor != null) {
            this.param.setOnColor(onColor);
        }
        return this;
    }

    public XEasyPdfBarCode setOffColor(Color offColor) {
        if (offColor != null) {
            this.param.setOffColor(offColor);
        }
        return this;
    }

    public XEasyPdfBarCode setWords(String words) {
        this.param.setWords(words);
        return this;
    }

    public XEasyPdfBarCode setWordsColor(Color wordsColor) {
        if (wordsColor != null) {
            this.param.setWordsColor(wordsColor);
        }
        return this;
    }

    public XEasyPdfBarCode setWordsStyle(WordsStyle wordsStyle) {
        if (wordsStyle != null) {
            this.param.setWordsStyle(wordsStyle);
        }
        return this;
    }

    public XEasyPdfBarCode setWordsSize(int wordsSize) {
        this.param.setWordsSize(Math.abs(wordsSize));
        return this;
    }

    public XEasyPdfBarCode setRadians(double radians) {
        if ((radians %= 360.0) != 0.0) {
            if (radians < 0.0) {
                radians += 360.0;
            }
            this.param.setRadians(radians);
        }
        return this;
    }

    public XEasyPdfBarCode setMarginLeft(float marginLeft) {
        this.param.setMarginLeft(Float.valueOf(marginLeft));
        return this;
    }

    public XEasyPdfBarCode setMarginRight(float marginRight) {
        this.param.setMarginRight(Float.valueOf(marginRight));
        return this;
    }

    public XEasyPdfBarCode setMarginTop(float marginTop) {
        this.param.setMarginTop(Float.valueOf(marginTop));
        return this;
    }

    public XEasyPdfBarCode setMarginBottom(float marginBottom) {
        this.param.setMarginBottom(Float.valueOf(marginBottom));
        return this;
    }

    public XEasyPdfBarCode enableShowWords() {
        this.param.setIsShowWords(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfBarCode enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
        PDDocument target = document.getTarget();
        BufferedImage bufferedImage = this.getBarCodeImage(this.createBitMatrix());
        PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)target, (byte[])XEasyPdfImageUtil.toBytes(bufferedImage, XEasyPdfImageType.PNG.name()), (String)XEasyPdfImageType.PNG.name());
        PDPageContentStream contentStream = new PDPageContentStream(target, page.getLastPage(), this.param.getContentMode().getMode(), true, this.param.getIsResetContext().booleanValue());
        contentStream.drawImage(pdImage, this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue(), (float)this.param.getImageWidth().intValue(), (float)this.param.getImageHeight().intValue());
        contentStream.close();
        if (page.isAllowResetPosition()) {
            page.setPageX(this.param.getBeginX()).setPageY(this.param.getBeginY());
        }
    }

    public void init() {
        this.param.init();
    }

    public BitMatrix createBitMatrix() {
        return new MultiFormatWriter().encode(this.param.getContent(), this.param.getCodeType().codeFormat, this.param.getImageMaxWidth().intValue(), this.param.getImageMaxHeight().intValue(), this.param.getEncodeHints());
    }

    public BufferedImage getBarCodeImage(BitMatrix matrix) {
        BufferedImage bufferedImage = this.toBufferedImage(matrix);
        if (this.param.getIsShowWords().booleanValue()) {
            bufferedImage = this.addImageWords(bufferedImage);
        }
        if (this.param.isRotate()) {
            bufferedImage = XEasyPdfImageUtil.rotate(bufferedImage, this.param.getRadians());
            this.param.resetBeginY(bufferedImage.getHeight());
        }
        return bufferedImage;
    }

    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getImageHeight() == null) {
            this.param.init(document, page);
        }
        return this.param.getImageHeight().intValue();
    }

    private BufferedImage toBufferedImage(BitMatrix matrix) {
        int onColor = this.param.getOnColor().getRGB();
        int offColor = this.param.getOffColor().getRGB();
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        int[] rowPixels = new int[width];
        BitArray row = new BitArray(width);
        for (int y = 0; y < height; ++y) {
            row = matrix.getRow(y, row);
            for (int x = 0; x < width; ++x) {
                rowPixels[x] = row.get(x) ? onColor : offColor;
            }
            image.setRGB(0, y, width, 1, rowPixels, 0, width);
        }
        return image;
    }

    private BufferedImage addImageWords(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage out = new BufferedImage(width, height + this.param.getWordsSize(), 2);
        Graphics2D graphics = out.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics.setColor(this.param.getOffColor());
        graphics.fillRect(0, 0, width, height + this.param.getWordsSize());
        graphics.setColor(this.param.getWordsColor());
        graphics.drawImage(image, 0, 0, width, height, null);
        graphics.setFont(new Font(null, this.param.getWordsStyle().style, this.param.getWordsSize()));
        int strWidth = graphics.getFontMetrics().stringWidth(this.param.getWords());
        int beginX = (width - strWidth) / 2;
        int beginY = height + this.param.getWordsSize();
        graphics.drawString(this.param.getWords(), beginX, beginY);
        graphics.dispose();
        image.flush();
        return out;
    }

    public static enum WordsStyle {
        NORMAL(0),
        BOLD(1),
        ITALIC(2);

        private final int style;

        private WordsStyle(int style) {
            this.style = style;
        }
    }

    public static enum ErrorLevel {
        L(ErrorCorrectionLevel.L),
        M(ErrorCorrectionLevel.M),
        Q(ErrorCorrectionLevel.Q),
        H(ErrorCorrectionLevel.H);

        private final ErrorCorrectionLevel level;

        private ErrorLevel(ErrorCorrectionLevel level) {
            this.level = level;
        }
    }

    public static enum CodeType {
        CODA_BAR(BarcodeFormat.CODABAR, 1),
        CODE_39(BarcodeFormat.CODE_39, 1),
        CODE_93(BarcodeFormat.CODE_93, 1),
        CODE_128(BarcodeFormat.CODE_128, 1),
        EAN_8(BarcodeFormat.EAN_8, 1),
        EAN_13(BarcodeFormat.EAN_13, 1),
        ITF(BarcodeFormat.ITF, 1),
        UPC_A(BarcodeFormat.UPC_A, 1),
        UPC_E(BarcodeFormat.UPC_E, 1),
        QR_CODE(BarcodeFormat.QR_CODE, 1),
        AZTEC(BarcodeFormat.AZTEC, 1),
        DATA_MATRIX(BarcodeFormat.DATA_MATRIX, 1),
        MAXI_CODE(BarcodeFormat.MAXICODE, 1),
        PDF_417(BarcodeFormat.PDF_417, 1);

        final BarcodeFormat codeFormat;
        final int margin;

        private CodeType(BarcodeFormat codeFormat, int margin) {
            this.codeFormat = codeFormat;
            this.margin = margin;
        }

        boolean isQrType() {
            switch (this) {
                case QR_CODE: 
                case AZTEC: 
                case DATA_MATRIX: 
                case MAXI_CODE: 
                case PDF_417: {
                    return true;
                }
            }
            return false;
        }
    }
}

