/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfCellBorder;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableParam;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPositionStyle;
import wiki.xsx.core.pdf.util.XEasyPdfConvertUtil;

class XEasyPdfRowParam
implements Serializable {
    private static final long serialVersionUID = -8085463000293380631L;
    private XEasyPdfComponent.ContentMode contentMode;
    private List<XEasyPdfCell> cells = new ArrayList<XEasyPdfCell>(10);
    private XEasyPdfRow splitRow;
    private Boolean hasBorder;
    private XEasyPdfRow.BorderPolicy borderPolicy;
    private Color backgroundColor;
    private Color borderColor;
    private Float borderWidth;
    private Float borderLineLength;
    private Float borderLineSpace;
    private Float marginLeft;
    private Float marginTop = Float.valueOf(0.0f);
    private Float height;
    private Float minHeight;
    private Float beginX;
    private Float beginY;
    private String fontPath;
    private Float fontSize;
    private Color fontColor;
    private XEasyPdfPositionStyle horizontalStyle;
    private XEasyPdfPositionStyle verticalStyle;
    private Boolean isResetContext;
    private Boolean isPaging;
    private Boolean isAutoSplit;
    private Boolean isAutoScaleFontSize;

    void init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table, XEasyPdfRow row) {
        if (!this.cells.isEmpty()) {
            XEasyPdfTableParam tableParam = table.getParam();
            if (this.hasBorder == null) {
                this.hasBorder = tableParam.getHasBorder();
            }
            if (this.hasBorder.booleanValue()) {
                this.initBorder();
                if (this.borderWidth == null) {
                    this.borderWidth = tableParam.getBorderWidth();
                }
                if (this.borderColor == null) {
                    this.borderColor = tableParam.getBorderColor();
                }
                if (this.borderLineLength == null) {
                    this.borderLineLength = tableParam.getBorderLineLength();
                }
                if (this.borderLineSpace == null) {
                    this.borderLineSpace = tableParam.getBorderLineSpace();
                }
            } else {
                this.borderWidth = Float.valueOf(0.0f);
            }
            if (this.contentMode == null) {
                this.contentMode = tableParam.getContentMode();
            }
            if (this.isResetContext == null) {
                this.isResetContext = tableParam.getIsResetContext();
            }
            if (this.fontPath == null) {
                this.fontPath = tableParam.getFontPath();
            }
            if (this.fontSize == null) {
                this.fontSize = tableParam.getFontSize();
            }
            if (this.fontColor == null) {
                this.fontColor = tableParam.getFontColor();
            }
            if (this.backgroundColor == null) {
                this.backgroundColor = tableParam.getBackgroundColor();
            }
            if (this.horizontalStyle == null) {
                this.horizontalStyle = tableParam.getHorizontalStyle();
            }
            if (this.verticalStyle == null) {
                this.verticalStyle = tableParam.getVerticalStyle();
            }
            if (this.isAutoScaleFontSize == null) {
                this.isAutoScaleFontSize = tableParam.getIsAutoScaleFontSize();
            }
            this.isAutoSplit = tableParam.getIsAutoSplit();
            float rowHeight = 0.0f;
            for (XEasyPdfCell cell : this.cells) {
                if (cell.getParam().getIsVerticalMerge().booleanValue()) continue;
                rowHeight = Math.max(rowHeight, cell.init(document, page, row));
            }
            if (this.minHeight == null) {
                this.minHeight = tableParam.getMinRowHeight();
            }
            if (this.minHeight != null) {
                rowHeight = Math.max(rowHeight, this.minHeight.floatValue());
            }
            if (this.height == null) {
                this.height = Float.valueOf(rowHeight);
            }
            this.beginY = Float.valueOf(this.checkPage(document, page, table, row));
            if (this.beginX == null) {
                this.beginX = tableParam.getBeginX() != null ? tableParam.getBeginX() : (this.marginLeft != null ? this.marginLeft : tableParam.getMarginLeft());
            }
        }
    }

    private void initBorder() {
        if (this.borderPolicy != null) {
            switch (this.borderPolicy) {
                case ONLY_LEFT_RIGHT: {
                    this.initBorder(false, false, true, true);
                    break;
                }
                case ONLY_TOP_BOTTOM: {
                    this.initBorder(true, true, false, false);
                    break;
                }
                case ONLY_TOP_LEFT_RIGHT: {
                    this.initBorder(true, false, true, true);
                    break;
                }
                case ONLY_BOTTOM_LEFT_RIGHT: {
                    this.initBorder(false, true, true, true);
                    break;
                }
                case ONLY_TOP: {
                    this.initBorder(true, false, false, false);
                    break;
                }
                case ONLY_BOTTOM: {
                    this.initBorder(false, true, false, false);
                    break;
                }
                default: {
                    this.initBorder(false, false, false, false);
                }
            }
        }
    }

    private void initBorder(boolean hasTop, boolean hasBottom, boolean hasLeft, boolean hasRight) {
        if (!this.cells.isEmpty()) {
            for (XEasyPdfCell cell : this.cells) {
                cell.disableBorder();
                if (hasTop) {
                    cell.enableTopBorder();
                }
                if (!hasBottom) continue;
                cell.enableBottomBorder();
            }
            if (hasLeft) {
                this.cells.get(0).enableLeftBorder();
            }
            if (hasRight) {
                this.cells.get(this.cells.size() - 1).enableRightBorder();
            }
        }
    }

    private float checkPage(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table, XEasyPdfRow row) {
        float footerHeight = 0.0f;
        if (page.isAllowFooter() && page.getFooter() != null) {
            footerHeight = page.getFooter().getHeight(document, page);
        }
        Float pageY = page.getPageY();
        float currentY = pageY.floatValue() - this.marginTop.floatValue();
        if (this.isPaging == null) {
            this.isPaging = currentY - footerHeight - this.height.floatValue() < table.getParam().getMarginBottom().floatValue();
            if (this.isPaging.booleanValue()) {
                if (this.isAutoSplit.booleanValue()) {
                    float maxHeight = currentY - footerHeight - table.getParam().getMarginBottom().floatValue();
                    this.split(document, page, table, row, maxHeight);
                }
                if (this.isPaging.booleanValue()) {
                    this.paging(document, page, table);
                    currentY = page.getPageY().floatValue() - this.marginTop.floatValue();
                }
            }
        } else if (this.isPaging.booleanValue()) {
            this.paging(document, page, table);
            currentY = page.getPageY().floatValue() - this.marginTop.floatValue();
            this.isPaging = currentY - footerHeight - this.height.floatValue() < table.getParam().getMarginBottom().floatValue();
            if (this.isPaging.booleanValue() && this.isAutoSplit.booleanValue()) {
                float maxHeight = currentY - footerHeight - table.getParam().getMarginBottom().floatValue();
                this.split(document, page, table, row, maxHeight);
                if (this.isPaging.booleanValue()) {
                    this.paging(document, page, table);
                    currentY = page.getPageY().floatValue() - this.marginTop.floatValue();
                }
            }
        }
        return currentY;
    }

    private void paging(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table) {
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        XEasyPdfTableParam tableParam = table.getParam();
        List<XEasyPdfCellBorder> cellBorderList = tableParam.getCellBorderList();
        if (!cellBorderList.isEmpty()) {
            for (XEasyPdfCellBorder cellBorder : cellBorderList) {
                cellBorder.drawBorder();
            }
            tableParam.setCellBorderList(new ArrayList<XEasyPdfCellBorder>(256));
        }
        page.enablePosition();
        page.addNewPage(document, rectangle);
        page.disablePosition();
        if (page.getPageY() == null) {
            page.setPageY(Float.valueOf(rectangle.getHeight() - tableParam.getMarginTop().floatValue()));
        } else {
            page.setPageY(Float.valueOf(page.getPageY().floatValue() - tableParam.getMarginTop().floatValue()));
        }
        this.drawTitle(document, page, tableParam);
    }

    private void drawTitle(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTableParam tableParam) {
        XEasyPdfTable title = tableParam.getTitle();
        if (title != null) {
            title.init(title.getParam());
            title.draw(document, page);
        }
    }

    private void split(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table, XEasyPdfRow row, float maxHeight) {
        HashMap<Integer, List<String>> splitMap = new HashMap<Integer, List<String>>(this.cells.size());
        float originalHeight = this.height.floatValue();
        boolean splitFlag = this.splitRow(document, page, splitMap, maxHeight);
        if (splitFlag) {
            this.isPaging = this.setSplitRow(document, page, row, splitMap, originalHeight, maxHeight);
        }
    }

    private void resetCellHeight() {
        for (XEasyPdfCell cell : this.cells) {
            cell.getParam().setHeight(null);
        }
    }

    private boolean splitRow(XEasyPdfDocument document, XEasyPdfPage page, Map<Integer, List<String>> splitMap, float maxHeight) {
        for (XEasyPdfCell cell : this.cells) {
            XEasyPdfComponent component = cell.getParam().getComponent();
            if (component instanceof XEasyPdfText) continue;
            return false;
        }
        int count = this.cells.size();
        for (int i = 0; i < count; ++i) {
            XEasyPdfComponent component;
            XEasyPdfCell cell = this.cells.get(i);
            Float cellHeight = cell.getParam().getHeight();
            if (cellHeight == null) {
                cellHeight = Float.valueOf(0.0f);
            }
            if (!((component = cell.getParam().getComponent()) instanceof XEasyPdfText)) continue;
            XEasyPdfText text = (XEasyPdfText)component;
            if (!((cellHeight = Float.valueOf(Math.max(cellHeight.floatValue(), text.getHeight(document, page)))).floatValue() > maxHeight)) continue;
            List<String> splitTextList = text.getSplitTextList();
            int textListSize = Math.min(Math.round((maxHeight - text.getMarginTop()) / (text.getFontSize() + text.getLeading())), splitTextList.size());
            if (textListSize <= 0) continue;
            text.setSplitTextList(splitTextList.subList(0, textListSize));
            text.setMaxHeight(null);
            if (text.getHeight(document, page) > maxHeight) {
                if (textListSize == 1) {
                    text.setSplitTextList(new ArrayList<String>(0));
                    splitMap.put(i, splitTextList);
                } else {
                    text.setSplitTextList(splitTextList.subList(0, textListSize - 1));
                    splitMap.put(i, splitTextList.subList(textListSize - 1, splitTextList.size()));
                }
                text.setMaxHeight(null);
            } else {
                splitMap.put(i, splitTextList.subList(textListSize, splitTextList.size()));
            }
            cell.getParam().setHeight(null);
        }
        return true;
    }

    private boolean setSplitRow(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, Map<Integer, List<String>> splitMap, float originalHeight, float maxHeight) {
        XEasyPdfText text;
        XEasyPdfComponent component;
        XEasyPdfCell cell;
        if (splitMap.isEmpty()) {
            this.splitRow = null;
            return true;
        }
        this.height = Float.valueOf(maxHeight);
        float rowHeight = originalHeight - maxHeight;
        Set<Map.Entry<Integer, List<String>>> entrySet = splitMap.entrySet();
        XEasyPdfRow splitRow = (XEasyPdfRow)XEasyPdfConvertUtil.toNewObject(row);
        XEasyPdfRowParam splitRowParam = splitRow.getParam();
        splitRowParam.resetCellHeight();
        List<XEasyPdfCell> cells = splitRowParam.getCells();
        int count = this.cells.size();
        for (int i = 0; i < count; ++i) {
            cell = this.cells.get(i);
            component = cell.getParam().getComponent();
            if (!(component instanceof XEasyPdfText) || !((text = (XEasyPdfText)component).getHeight(document, page) <= maxHeight)) continue;
            cell = cells.get(i);
            component = cell.getParam().getComponent();
            text = (XEasyPdfText)component;
            text.setSplitTextList(new ArrayList<String>(0));
            text.setMaxHeight(null);
        }
        for (Map.Entry<Integer, List<String>> entry : entrySet) {
            cell = cells.get(entry.getKey());
            component = cell.getParam().getComponent();
            text = (XEasyPdfText)component;
            text.setSplitTextList(entry.getValue());
            text.setMaxHeight(null);
            float textHeight = text.getHeight(document, page);
            if (!(textHeight > rowHeight)) continue;
            rowHeight = textHeight;
        }
        splitRowParam.setHeight(Float.valueOf(rowHeight));
        this.splitRow = splitRow;
        return false;
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public List<XEasyPdfCell> getCells() {
        return this.cells;
    }

    public XEasyPdfRow getSplitRow() {
        return this.splitRow;
    }

    public Boolean getHasBorder() {
        return this.hasBorder;
    }

    public XEasyPdfRow.BorderPolicy getBorderPolicy() {
        return this.borderPolicy;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Float getBorderWidth() {
        return this.borderWidth;
    }

    public Float getBorderLineLength() {
        return this.borderLineLength;
    }

    public Float getBorderLineSpace() {
        return this.borderLineSpace;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getMinHeight() {
        return this.minHeight;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.horizontalStyle;
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.verticalStyle;
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public Boolean getIsPaging() {
        return this.isPaging;
    }

    public Boolean getIsAutoSplit() {
        return this.isAutoSplit;
    }

    public Boolean getIsAutoScaleFontSize() {
        return this.isAutoScaleFontSize;
    }

    public XEasyPdfRowParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfRowParam setCells(List<XEasyPdfCell> cells) {
        this.cells = cells;
        return this;
    }

    public XEasyPdfRowParam setSplitRow(XEasyPdfRow splitRow) {
        this.splitRow = splitRow;
        return this;
    }

    public XEasyPdfRowParam setHasBorder(Boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfRowParam setBorderPolicy(XEasyPdfRow.BorderPolicy borderPolicy) {
        this.borderPolicy = borderPolicy;
        return this;
    }

    public XEasyPdfRowParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfRowParam setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public XEasyPdfRowParam setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public XEasyPdfRowParam setBorderLineLength(Float borderLineLength) {
        this.borderLineLength = borderLineLength;
        return this;
    }

    public XEasyPdfRowParam setBorderLineSpace(Float borderLineSpace) {
        this.borderLineSpace = borderLineSpace;
        return this;
    }

    public XEasyPdfRowParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfRowParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfRowParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfRowParam setMinHeight(Float minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public XEasyPdfRowParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfRowParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfRowParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfRowParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfRowParam setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public XEasyPdfRowParam setHorizontalStyle(XEasyPdfPositionStyle horizontalStyle) {
        this.horizontalStyle = horizontalStyle;
        return this;
    }

    public XEasyPdfRowParam setVerticalStyle(XEasyPdfPositionStyle verticalStyle) {
        this.verticalStyle = verticalStyle;
        return this;
    }

    public XEasyPdfRowParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfRowParam setIsPaging(Boolean isPaging) {
        this.isPaging = isPaging;
        return this;
    }

    public XEasyPdfRowParam setIsAutoSplit(Boolean isAutoSplit) {
        this.isAutoSplit = isAutoSplit;
        return this;
    }

    public XEasyPdfRowParam setIsAutoScaleFontSize(Boolean isAutoScaleFontSize) {
        this.isAutoScaleFontSize = isAutoScaleFontSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfRowParam)) {
            return false;
        }
        XEasyPdfRowParam other = (XEasyPdfRowParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$hasBorder = this.getHasBorder();
        Boolean other$hasBorder = other.getHasBorder();
        if (this$hasBorder == null ? other$hasBorder != null : !((Object)this$hasBorder).equals(other$hasBorder)) {
            return false;
        }
        Float this$borderWidth = this.getBorderWidth();
        Float other$borderWidth = other.getBorderWidth();
        if (this$borderWidth == null ? other$borderWidth != null : !((Object)this$borderWidth).equals(other$borderWidth)) {
            return false;
        }
        Float this$borderLineLength = this.getBorderLineLength();
        Float other$borderLineLength = other.getBorderLineLength();
        if (this$borderLineLength == null ? other$borderLineLength != null : !((Object)this$borderLineLength).equals(other$borderLineLength)) {
            return false;
        }
        Float this$borderLineSpace = this.getBorderLineSpace();
        Float other$borderLineSpace = other.getBorderLineSpace();
        if (this$borderLineSpace == null ? other$borderLineSpace != null : !((Object)this$borderLineSpace).equals(other$borderLineSpace)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$minHeight = this.getMinHeight();
        Float other$minHeight = other.getMinHeight();
        if (this$minHeight == null ? other$minHeight != null : !((Object)this$minHeight).equals(other$minHeight)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Boolean this$isPaging = this.getIsPaging();
        Boolean other$isPaging = other.getIsPaging();
        if (this$isPaging == null ? other$isPaging != null : !((Object)this$isPaging).equals(other$isPaging)) {
            return false;
        }
        Boolean this$isAutoSplit = this.getIsAutoSplit();
        Boolean other$isAutoSplit = other.getIsAutoSplit();
        if (this$isAutoSplit == null ? other$isAutoSplit != null : !((Object)this$isAutoSplit).equals(other$isAutoSplit)) {
            return false;
        }
        Boolean this$isAutoScaleFontSize = this.getIsAutoScaleFontSize();
        Boolean other$isAutoScaleFontSize = other.getIsAutoScaleFontSize();
        if (this$isAutoScaleFontSize == null ? other$isAutoScaleFontSize != null : !((Object)this$isAutoScaleFontSize).equals(other$isAutoScaleFontSize)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        List<XEasyPdfCell> this$cells = this.getCells();
        List<XEasyPdfCell> other$cells = other.getCells();
        if (this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells)) {
            return false;
        }
        XEasyPdfRow this$splitRow = this.getSplitRow();
        XEasyPdfRow other$splitRow = other.getSplitRow();
        if (this$splitRow == null ? other$splitRow != null : !this$splitRow.equals(other$splitRow)) {
            return false;
        }
        XEasyPdfRow.BorderPolicy this$borderPolicy = this.getBorderPolicy();
        XEasyPdfRow.BorderPolicy other$borderPolicy = other.getBorderPolicy();
        if (this$borderPolicy == null ? other$borderPolicy != null : !((Object)((Object)this$borderPolicy)).equals((Object)other$borderPolicy)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        XEasyPdfPositionStyle this$horizontalStyle = this.getHorizontalStyle();
        XEasyPdfPositionStyle other$horizontalStyle = other.getHorizontalStyle();
        if (this$horizontalStyle == null ? other$horizontalStyle != null : !((Object)((Object)this$horizontalStyle)).equals((Object)other$horizontalStyle)) {
            return false;
        }
        XEasyPdfPositionStyle this$verticalStyle = this.getVerticalStyle();
        XEasyPdfPositionStyle other$verticalStyle = other.getVerticalStyle();
        return !(this$verticalStyle == null ? other$verticalStyle != null : !((Object)((Object)this$verticalStyle)).equals((Object)other$verticalStyle));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfRowParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $hasBorder = this.getHasBorder();
        result = result * 59 + ($hasBorder == null ? 43 : ((Object)$hasBorder).hashCode());
        Float $borderWidth = this.getBorderWidth();
        result = result * 59 + ($borderWidth == null ? 43 : ((Object)$borderWidth).hashCode());
        Float $borderLineLength = this.getBorderLineLength();
        result = result * 59 + ($borderLineLength == null ? 43 : ((Object)$borderLineLength).hashCode());
        Float $borderLineSpace = this.getBorderLineSpace();
        result = result * 59 + ($borderLineSpace == null ? 43 : ((Object)$borderLineSpace).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $minHeight = this.getMinHeight();
        result = result * 59 + ($minHeight == null ? 43 : ((Object)$minHeight).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Boolean $isPaging = this.getIsPaging();
        result = result * 59 + ($isPaging == null ? 43 : ((Object)$isPaging).hashCode());
        Boolean $isAutoSplit = this.getIsAutoSplit();
        result = result * 59 + ($isAutoSplit == null ? 43 : ((Object)$isAutoSplit).hashCode());
        Boolean $isAutoScaleFontSize = this.getIsAutoScaleFontSize();
        result = result * 59 + ($isAutoScaleFontSize == null ? 43 : ((Object)$isAutoScaleFontSize).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        List<XEasyPdfCell> $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        XEasyPdfRow $splitRow = this.getSplitRow();
        result = result * 59 + ($splitRow == null ? 43 : $splitRow.hashCode());
        XEasyPdfRow.BorderPolicy $borderPolicy = this.getBorderPolicy();
        result = result * 59 + ($borderPolicy == null ? 43 : ((Object)((Object)$borderPolicy)).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        XEasyPdfPositionStyle $horizontalStyle = this.getHorizontalStyle();
        result = result * 59 + ($horizontalStyle == null ? 43 : ((Object)((Object)$horizontalStyle)).hashCode());
        XEasyPdfPositionStyle $verticalStyle = this.getVerticalStyle();
        result = result * 59 + ($verticalStyle == null ? 43 : ((Object)((Object)$verticalStyle)).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfRowParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", cells=" + this.getCells() + ", splitRow=" + this.getSplitRow() + ", hasBorder=" + this.getHasBorder() + ", borderPolicy=" + (Object)((Object)this.getBorderPolicy()) + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", borderWidth=" + this.getBorderWidth() + ", borderLineLength=" + this.getBorderLineLength() + ", borderLineSpace=" + this.getBorderLineSpace() + ", marginLeft=" + this.getMarginLeft() + ", marginTop=" + this.getMarginTop() + ", height=" + this.getHeight() + ", minHeight=" + this.getMinHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", fontPath=" + this.getFontPath() + ", fontSize=" + this.getFontSize() + ", fontColor=" + this.getFontColor() + ", horizontalStyle=" + (Object)((Object)this.getHorizontalStyle()) + ", verticalStyle=" + (Object)((Object)this.getVerticalStyle()) + ", isResetContext=" + this.getIsResetContext() + ", isPaging=" + this.getIsPaging() + ", isAutoSplit=" + this.getIsAutoSplit() + ", isAutoScaleFontSize=" + this.getIsAutoScaleFontSize() + ")";
    }
}

