/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.fixup.AcroFormDefaultFixup;
import org.apache.pdfbox.pdmodel.fixup.PDDocumentFixup;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentForm;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSigner;
import wiki.xsx.core.pdf.util.XEasyPdfFileUtil;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfTextUtil;

public class XEasyPdfDocumentFormFiller
implements Serializable {
    private static final long serialVersionUID = -178730035810612354L;
    private final XEasyPdfDocument pdfDocument;
    private final PDDocument document;
    private PDAcroForm form;
    private static final String FONT_REGEX = "/\\S*";
    private static final String FONT_SIZE_REGEX = "/.*Tf";
    private String fontPath;
    private String fontSize;
    private Boolean isReadOnly = Boolean.FALSE;
    private Boolean isNeedAppearance = Boolean.FALSE;
    private Boolean isCompress = Boolean.FALSE;

    XEasyPdfDocumentFormFiller(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.build(true);
        this.form = this.initAcroForm(this.document, false);
    }

    public XEasyPdfDocumentFormFiller enableReadOnly() {
        this.isReadOnly = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentFormFiller enableFixForm() {
        this.form = this.initAcroForm(this.document, true);
        return this;
    }

    public XEasyPdfDocumentFormFiller enableAppearance() {
        this.isNeedAppearance = Boolean.TRUE;
        this.form.setNeedAppearances(Boolean.TRUE);
        return this;
    }

    public XEasyPdfDocumentFormFiller enableCompress() {
        this.isCompress = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentFormFiller setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfDocumentFormFiller setFontSize(int fontSize) {
        this.fontSize = String.valueOf(Math.abs(fontSize));
        return this;
    }

    public XEasyPdfDocumentFormFiller setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.fontPath = style.getPath();
        }
        return this;
    }

    public XEasyPdfDocumentFormFiller fill(Map<String, String> formMap) {
        if (formMap != null && !formMap.isEmpty() && this.form != null) {
            if (this.form.getNeedAppearances()) {
                this.fillForAppearance(formMap);
            } else {
                this.fillForNormal(formMap);
            }
            this.fontSize = null;
        }
        return this;
    }

    public XEasyPdfDocumentFormFiller clear() {
        this.form.getFields().forEach(this::clearField);
        return this;
    }

    public XEasyPdfDocumentForm create() {
        return new XEasyPdfDocumentForm(this);
    }

    public XEasyPdfDocumentSigner signer() {
        return new XEasyPdfDocumentSigner(this.pdfDocument, this.document);
    }

    public void finish(String outputPath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(outputPath, new String[0])), new OpenOption[0]));){
            this.finish(outputStream);
        }
    }

    public void finish(OutputStream outputStream) {
        if (this.isCompress.booleanValue() && !this.form.getNeedAppearances()) {
            this.document.getDocumentCatalog().setAcroForm(null);
        }
        this.pdfDocument.setBasicInfo(this.document);
        this.pdfDocument.replaceTotalPagePlaceholder(this.document, false);
        this.document.save(outputStream);
        this.pdfDocument.close();
    }

    PDDocument getDocument() {
        return this.document;
    }

    PDAcroForm getForm() {
        if (this.form == null) {
            this.form = new PDAcroForm(this.document);
        }
        return this.form;
    }

    private PDAcroForm initAcroForm(PDDocument document, boolean isFixForm) {
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        PDAcroForm acroForm = isFixForm ? documentCatalog.getAcroForm((PDDocumentFixup)new AcroFormDefaultFixup(document)) : documentCatalog.getAcroForm(null);
        if (acroForm == null) {
            acroForm = new PDAcroForm(document);
        }
        acroForm.setNeedAppearances(this.isNeedAppearance);
        return acroForm;
    }

    private void fillForNormal(Map<String, String> formMap) {
        PDFont font = this.initFont();
        PDResources defaultResources = this.form.getDefaultResources();
        defaultResources.put(COSName.getPDFName((String)font.getName()), font);
        if (this.fill(formMap, font)) {
            this.pdfDocument.getParam().embedFont(Collections.singleton(font));
        }
    }

    private void fillForAppearance(Map<String, String> formMap) {
        this.fill(formMap, null);
    }

    private boolean fill(Map<String, String> formMap, PDFont font) {
        boolean flag = false;
        Set<Map.Entry<String, String>> entrySet = formMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            PDField field = this.form.getField(entry.getKey());
            String newValue = entry.getValue();
            if (field == null) continue;
            if (XEasyPdfTextUtil.isNotBlank(newValue)) {
                this.resetValue(font, field, newValue);
                flag = true;
            }
            if (!this.isReadOnly.booleanValue()) continue;
            field.setReadOnly(true);
        }
        return flag;
    }

    private PDFont initFont() {
        if (this.fontPath == null) {
            this.fontPath = this.pdfDocument.getFontPath();
        }
        return XEasyPdfFontUtil.loadFont(this.pdfDocument, this.fontPath, true);
    }

    private void resetValue(PDFont font, PDField field, String newValue) {
        if (font != null) {
            if (field instanceof PDTextField) {
                PDTextField textField = (PDTextField)field;
                String defaultAppearance = textField.getDefaultAppearance();
                if (this.fontSize == null) {
                    textField.setDefaultAppearance(defaultAppearance.replaceFirst(FONT_REGEX, XEasyPdfTextUtil.join("", "/", font.getName())));
                } else {
                    textField.setDefaultAppearance(defaultAppearance.replaceFirst(FONT_SIZE_REGEX, XEasyPdfTextUtil.join(" ", "/", font.getName(), this.fontSize, "Tf")));
                }
            }
            XEasyPdfFontUtil.addToSubset(font, newValue);
        }
        field.setValue(newValue);
    }

    private void clearField(PDField field) {
        if (field instanceof PDTerminalField) {
            field.getWidgets().forEach(v -> Optional.ofNullable(v.getPage()).ifPresent(this::clearAnnotations));
        } else if (field instanceof PDNonTerminalField) {
            ((PDNonTerminalField)field).getChildren().forEach(this::clearField);
        }
    }

    private void clearAnnotations(PDPage page) {
        page.getAnnotations().clear();
    }
}

