/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.PDContentStream;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentInfo;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSigner;
import wiki.xsx.core.pdf.util.XEasyPdfFileUtil;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

public class XEasyPdfDocumentReplacer
implements Serializable {
    private static final long serialVersionUID = 5248577569799461988L;
    private final Log log = LogFactory.getLog(XEasyPdfDocumentReplacer.class);
    private PDDocument document;
    private XEasyPdfDocument pdfDocument;
    private String fontPath;
    boolean isAllowReplaceComments = Boolean.FALSE;

    XEasyPdfDocumentReplacer(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.build(true);
    }

    XEasyPdfDocumentReplacer(XEasyPdfDocument pdfDocument, PDDocument target) {
        this.pdfDocument = pdfDocument;
        this.document = target;
    }

    public XEasyPdfDocumentReplacer enableReplaceComments(boolean b) {
        this.isAllowReplaceComments = Boolean.TRUE;
        return this;
    }

    public XEasyPdfDocumentReplacer setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfDocumentReplacer setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.fontPath = style.getPath();
        }
        return this;
    }

    public XEasyPdfDocumentReplacer replaceText(Map<String, String> replaceMap) {
        return this.replaceText(replaceMap, (int[])null);
    }

    public XEasyPdfDocumentReplacer replaceText(Map<String, String> replaceMap, int ... pageIndex) {
        return this.replaceText(1, replaceMap, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceText(int count, Map<String, String> replaceMap, int ... pageIndex) {
        if (replaceMap != null && !replaceMap.isEmpty() && count > 0) {
            if (pageIndex == null || pageIndex.length == 0) {
                PDPageTree pages = this.document.getPages();
                for (PDPage page : pages) {
                    for (int i = 0; i < count; ++i) {
                        this.replaceText(page, replaceMap);
                    }
                }
            } else {
                for (int index : pageIndex) {
                    if (index < 0) continue;
                    for (int i = 0; i < count; ++i) {
                        this.replaceText(this.document.getPage(index), replaceMap);
                    }
                }
            }
        }
        return this;
    }

    public XEasyPdfDocumentReplacer replaceComment(Map<String, String> replaceMap, int ... pageIndex) {
        if (replaceMap != null && !replaceMap.isEmpty()) {
            if (pageIndex == null || pageIndex.length == 0) {
                PDPageTree pages = this.document.getPages();
                for (PDPage page : pages) {
                    this.replaceComment(page, replaceMap);
                }
            } else {
                for (int index : pageIndex) {
                    if (index < 0) continue;
                    this.replaceComment(this.document.getPage(index), replaceMap);
                }
            }
        }
        return this;
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, int ... pageIndex) {
        return this.replaceImage(image, XEasyPdfImageType.PNG, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, XEasyPdfImageType imageType, int ... pageIndex) {
        return this.replaceImage(image, imageType, null, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, List<Integer> replaceIndexList, int ... pageIndex) {
        return this.replaceImage(image, XEasyPdfImageType.PNG, replaceIndexList, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceImage(BufferedImage image, XEasyPdfImageType imageType, List<Integer> replaceIndexList, int ... pageIndex) {
        PDImageXObject imageObject = null;
        if (image != null) {
            imageObject = PDImageXObject.createFromByteArray((PDDocument)this.document, (byte[])XEasyPdfImageUtil.toBytes(image, imageType.name()), (String)imageType.name());
        }
        return this.replaceImage(imageObject, replaceIndexList, pageIndex);
    }

    public XEasyPdfDocumentReplacer replaceAttributes(Map<String, String> map) {
        PDDocumentInformation information = this.pdfDocument.getParam().getSource().getDocumentInformation();
        this.replaceAttributes(this.pdfDocument.information(), information, map);
        return this;
    }

    public XEasyPdfDocumentSigner signer() {
        return new XEasyPdfDocumentSigner(this.pdfDocument);
    }

    public void finish(String outputPath) {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(outputPath, new String[0])), new OpenOption[0]));){
            this.finish(outputStream);
        }
    }

    public void finish(OutputStream outputStream) {
        this.pdfDocument.replaceTotalPagePlaceholder(this.document, false);
        this.pdfDocument.setBasicInfo(this.document);
        this.document.save(outputStream);
        this.pdfDocument.close();
    }

    void finish() {
        this.pdfDocument = null;
        this.document = null;
    }

    void replaceText(PDPage page, Map<String, String> replaceMap) {
        block14: {
            PDFont font = this.initFont();
            PDResources resources = page.getResources();
            PDFStreamParser parser = new PDFStreamParser((PDContentStream)page);
            parser.parse();
            List tokens = parser.getTokens();
            if (!this.replaceTextToken(font, resources, tokens, replaceMap)) break block14;
            PDStream updatedStream = new PDStream(this.document);
            try (OutputStream outputStream = updatedStream.createOutputStream(COSName.FLATE_DECODE);){
                ContentStreamWriter tokenWriter = new ContentStreamWriter(outputStream);
                tokenWriter.writeTokens(tokens);
                page.setContents(updatedStream);
            }
            this.pdfDocument.getParam().embedFont(Collections.singleton(font));
        }
    }

    void replaceComment(PDPage page, Map<String, String> replaceMap) {
        List pdAnnotations = page.getAnnotations();
        for (PDAnnotation p : pdAnnotations) {
            PDAnnotationText pdAnnotationText;
            String comment;
            String replaceString;
            if (!(p instanceof PDAnnotationText) || Objects.equals(replaceString = this.replaceString(comment = (pdAnnotationText = (PDAnnotationText)p).getContents(), replaceMap), comment)) continue;
            pdAnnotationText.setContents(replaceString);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("replace comment from \"" + comment + "\" to \"" + replaceString + "\""));
        }
    }

    private Boolean findReplaceString(String source, Map<String, String> replaceMap) {
        for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
            Matcher matcher = Pattern.compile(entry.getKey(), 18).matcher(source);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String replaceString(String content, Map<String, String> replaceMap) {
        if (content == null) {
            return null;
        }
        if (content.trim().length() > 0) {
            for (Map.Entry<String, String> entry : replaceMap.entrySet()) {
                Matcher matcher = Pattern.compile(entry.getKey(), 18).matcher(content);
                if (!matcher.find()) continue;
                content = matcher.replaceAll(entry.getValue());
            }
        }
        return content;
    }

    private PDFont initFont() {
        if (this.fontPath == null) {
            this.fontPath = this.pdfDocument.getFontPath();
        }
        return XEasyPdfFontUtil.loadFont(this.pdfDocument, this.fontPath, true);
    }

    private Map<COSName, PDFont> initResourceFontMap(PDResources resources) {
        HashMap<COSName, PDFont> resourceFontMap = new HashMap<COSName, PDFont>(16);
        for (COSName cosName : resources.getFontNames()) {
            resourceFontMap.put(cosName, resources.getFont(cosName));
        }
        return resourceFontMap;
    }

    private boolean replaceTextToken(PDFont font, PDResources resources, List<Object> tokens, Map<String, String> replaceMap) {
        Map<COSName, PDFont> resourceFontMap = this.initResourceFontMap(resources);
        COSName replaceFontName = COSName.getPDFName((String)font.getName());
        Integer resourceFontIndex = null;
        COSName resourceFontName = null;
        PDFont resourceFont = null;
        LinkedHashMap cosBaseMap = new LinkedHashMap(10);
        for (int i = 0; i < tokens.size(); ++i) {
            List list;
            Object token = tokens.get(i);
            if (token instanceof COSName) {
                if (resourceFontMap.get(token) == null) continue;
                resourceFont = resourceFontMap.get(token);
                resourceFontIndex = i;
                resourceFontName = (COSName)token;
                if (cosBaseMap.containsKey(resourceFontName)) continue;
                cosBaseMap.put(resourceFontName, new ArrayList(64));
                continue;
            }
            if (!(token instanceof COSArray) && !(token instanceof COSString) || (list = (List)cosBaseMap.get(resourceFontName)) == null) continue;
            list.add(new COSBaseInfo((COSBase)token, resourceFontIndex, resourceFontName, resourceFont));
        }
        Collection values = cosBaseMap.values();
        for (List cosBases : values) {
            if (cosBases.isEmpty()) continue;
            for (COSBaseInfo info : cosBases) {
                if (!this.replaceString(info.getCosBase(), replaceMap, resourceFont, font)) continue;
                tokens.set(info.getFontIndex(), replaceFontName);
                if (resources.getFont(replaceFontName) != null) continue;
                resources.put(replaceFontName, font);
            }
        }
        return true;
    }

    private boolean replaceString(COSBase cosBase, Map<String, String> replaceMap, PDFont resourceFont, PDFont replaceFont) {
        if (cosBase instanceof COSArray || cosBase instanceof COSString) {
            String source = this.readFromToken(cosBase, resourceFont);
            String temp = this.replaceString(source, replaceMap);
            if (temp == null || temp.equals(source)) {
                return false;
            }
            XEasyPdfFontUtil.addToSubset(replaceFont, temp);
            if (cosBase instanceof COSArray) {
                COSArray array = (COSArray)cosBase;
                array.clear();
                array.add((COSBase)new COSString(replaceFont.encode(temp)));
            } else {
                byte[] array = replaceFont.encode(temp);
                COSString cosString = (COSString)cosBase;
                cosString.setValue(array);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("replace string from \"" + source + "\" to \"" + temp + "\""));
            }
            return true;
        }
        return false;
    }

    private String readFromToken(Object token, PDFont resourceFont) throws IOException {
        StringBuilder builder = new StringBuilder();
        if (token instanceof COSArray) {
            COSArray array = (COSArray)token;
            for (COSBase cosBase : array) {
                COSInteger cosInteger;
                if (cosBase instanceof COSString) {
                    COSString cosString = (COSString)cosBase;
                    ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());
                    Throwable throwable = null;
                    try {
                        while (((InputStream)in).available() > 0) {
                            builder.append(resourceFont.toUnicode(resourceFont.readCode((InputStream)in)));
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                ((InputStream)in).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((InputStream)in).close();
                        continue;
                    }
                }
                if (!(cosBase instanceof COSInteger) || (cosInteger = (COSInteger)cosBase).intValue() > -199) continue;
                builder.append(" ");
            }
        } else if (token instanceof COSString) {
            COSString cosString = (COSString)token;
            try (ByteArrayInputStream in = new ByteArrayInputStream(cosString.getBytes());){
                while (((InputStream)in).available() > 0) {
                    builder.append(resourceFont.toUnicode(resourceFont.readCode((InputStream)in)));
                }
            }
        }
        return builder.toString();
    }

    private XEasyPdfDocumentReplacer replaceImage(PDImageXObject image, List<Integer> replaceIndexList, int ... pageIndex) {
        PDPageTree pages = this.document.getPages();
        if (pageIndex == null || pageIndex.length == 0) {
            for (PDPage page : pages) {
                this.replaceImage(page.getResources(), image, replaceIndexList);
            }
        } else {
            for (int index : pageIndex) {
                if (index < 0) continue;
                this.replaceImage(pages.get(index).getResources(), image, replaceIndexList);
            }
        }
        return this;
    }

    private void replaceImage(PDResources resources, PDImageXObject image, List<Integer> replaceIndexList) {
        block7: {
            Iterable objectNames = resources.getXObjectNames();
            if (replaceIndexList == null || replaceIndexList.isEmpty()) {
                for (COSName cosName : objectNames) {
                    if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                    resources.put(cosName, (PDXObject)image);
                }
                break block7;
            }
            Iterator<Integer> iterator = new TreeSet<Integer>(replaceIndexList).iterator();
            int index = 0;
            int replaceIndex = iterator.next();
            for (COSName cosName : objectNames) {
                if (!(resources.getXObject(cosName) instanceof PDImage)) continue;
                if (index == replaceIndex) {
                    resources.put(cosName, (PDXObject)image);
                    if (!iterator.hasNext()) break;
                    replaceIndex = iterator.next();
                }
                ++index;
            }
        }
    }

    private void replaceAttributes(XEasyPdfDocumentInfo info, PDDocumentInformation information, Map<String, String> replaceMap) {
        info.setAuthor(this.replaceString(information.getAuthor(), replaceMap));
        info.setCreator(this.replaceString(information.getCreator(), replaceMap));
        info.setSubject(this.replaceString(information.getSubject(), replaceMap));
        info.setTitle(this.replaceString(information.getTitle(), replaceMap));
        info.setKeywords(this.replaceString(information.getKeywords(), replaceMap));
    }

    private static class COSBaseInfo {
        private COSBase cosBase;
        private Integer fontIndex;
        private COSName fontName;
        private PDFont font;

        public COSBase getCosBase() {
            return this.cosBase;
        }

        public Integer getFontIndex() {
            return this.fontIndex;
        }

        public COSName getFontName() {
            return this.fontName;
        }

        public PDFont getFont() {
            return this.font;
        }

        public void setCosBase(COSBase cosBase) {
            this.cosBase = cosBase;
        }

        public void setFontIndex(Integer fontIndex) {
            this.fontIndex = fontIndex;
        }

        public void setFontName(COSName fontName) {
            this.fontName = fontName;
        }

        public void setFont(PDFont font) {
            this.font = font;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof COSBaseInfo)) {
                return false;
            }
            COSBaseInfo other = (COSBaseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$fontIndex = this.getFontIndex();
            Integer other$fontIndex = other.getFontIndex();
            if (this$fontIndex == null ? other$fontIndex != null : !((Object)this$fontIndex).equals(other$fontIndex)) {
                return false;
            }
            COSBase this$cosBase = this.getCosBase();
            COSBase other$cosBase = other.getCosBase();
            if (this$cosBase == null ? other$cosBase != null : !this$cosBase.equals(other$cosBase)) {
                return false;
            }
            COSName this$fontName = this.getFontName();
            COSName other$fontName = other.getFontName();
            if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
                return false;
            }
            PDFont this$font = this.getFont();
            PDFont other$font = other.getFont();
            return !(this$font == null ? other$font != null : !this$font.equals(other$font));
        }

        protected boolean canEqual(Object other) {
            return other instanceof COSBaseInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $fontIndex = this.getFontIndex();
            result = result * 59 + ($fontIndex == null ? 43 : ((Object)$fontIndex).hashCode());
            COSBase $cosBase = this.getCosBase();
            result = result * 59 + ($cosBase == null ? 43 : $cosBase.hashCode());
            COSName $fontName = this.getFontName();
            result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
            PDFont $font = this.getFont();
            result = result * 59 + ($font == null ? 43 : $font.hashCode());
            return result;
        }

        public String toString() {
            return "XEasyPdfDocumentReplacer.COSBaseInfo(cosBase=" + this.getCosBase() + ", fontIndex=" + this.getFontIndex() + ", fontName=" + this.getFontName() + ", font=" + this.getFont() + ")";
        }

        public COSBaseInfo(COSBase cosBase, Integer fontIndex, COSName fontName, PDFont font) {
            this.cosBase = cosBase;
            this.fontIndex = fontIndex;
            this.fontName = fontName;
            this.font = font;
        }
    }
}

