/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSignAlgorithm;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSignDefaultProcessor;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSignFilter;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSignKeyStoreType;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentSignerParam;

public class XEasyPdfDocumentSigner
implements Serializable {
    private static final long serialVersionUID = -3449241065190072431L;
    private final XEasyPdfDocumentSignerParam param = new XEasyPdfDocumentSignerParam();

    XEasyPdfDocumentSigner(XEasyPdfDocument pdfDocument) {
        this.param.setPdfDocument(pdfDocument);
        this.param.setDocument(this.param.getPdfDocument().build(true));
    }

    XEasyPdfDocumentSigner(XEasyPdfDocument pdfDocument, PDDocument document) {
        this.param.setPdfDocument(pdfDocument);
        this.param.setDocument(document);
    }

    public XEasyPdfDocumentSigner setSignerInfo(String name, String location, String reason, String contactInfo) {
        this.param.getSignature().setName(name);
        this.param.getSignature().setLocation(location);
        this.param.getSignature().setReason(reason);
        this.param.getSignature().setContactInfo(contactInfo);
        return this;
    }

    public XEasyPdfDocumentSigner setSignFilter(XEasyPdfDocumentSignFilter.Filter filter, XEasyPdfDocumentSignFilter.SubFilter subFilter) {
        if (filter != null) {
            this.param.getSignature().setFilter(filter.getFilter());
        }
        if (subFilter != null) {
            this.param.getSignature().setSubFilter(subFilter.getFilter());
        }
        return this;
    }

    public XEasyPdfDocumentSigner setSignImage(BufferedImage image, float marginLeft, float marginTop, float scalePercent) {
        this.param.setImage(image).setImageMarginLeft(Float.valueOf(marginLeft)).setImageMarginTop(Float.valueOf(marginTop)).setImageScalePercent(Float.valueOf(scalePercent - 100.0f));
        return this;
    }

    public XEasyPdfDocumentSigner setCertificate(XEasyPdfDocumentSignAlgorithm signAlgorithm, XEasyPdfDocumentSignKeyStoreType keyStoreType, File certificate, String certificatePassword) {
        this.param.setSignAlgorithm(signAlgorithm).setKeyStoreType(keyStoreType).setCertificate(certificate).setCertificatePassword(certificatePassword);
        return this;
    }

    public XEasyPdfDocumentSigner setPreferredSignatureSize(int preferredSignatureSize) {
        this.param.setPreferredSignatureSize(preferredSignatureSize);
        return this;
    }

    public XEasyPdfDocumentSigner setCustomSignature(SignatureInterface customSignature) {
        this.param.setCustomSignature(customSignature);
        return this;
    }

    public XEasyPdfDocumentSigner setAccessPermissions(int accessPermissions) {
        this.param.setAccessPermissions(accessPermissions);
        return this;
    }

    public void sign(int pageIndex, OutputStream outputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);){
            this.param.init(pageIndex);
            PDDocument target = this.param.getDocument();
            target.save((OutputStream)byteArrayOutputStream);
            this.addSignature(true, PDDocument.load((byte[])byteArrayOutputStream.toByteArray()), outputStream);
        }
        this.param.getPdfDocument().close();
    }

    public void sign(OutputStream outputStream, int ... pageIndexes) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);){
            PDDocument target = this.param.getDocument();
            target.save((OutputStream)byteArrayOutputStream);
            target.close();
            this.param.setDocument(PDDocument.load((byte[])byteArrayOutputStream.toByteArray()));
        }
        int index = 0;
        int signSize = this.param.getPreferredSignatureSize();
        int accessPermission = this.param.getAccessPermissions();
        if (pageIndexes != null && pageIndexes.length > 0) {
            int lastIndex = pageIndexes.length - 1;
            for (int pageIndex : pageIndexes) {
                index = this.addSignature(index, pageIndex, index == lastIndex, signSize, accessPermission, this.param.getDocument(), outputStream);
                signSize = (int)((double)signSize * 3.5);
            }
        } else {
            int total = this.param.getDocument().getNumberOfPages();
            int lastIndex = total - 1;
            for (int pageIndex = 0; pageIndex < total; ++pageIndex) {
                index = this.addSignature(index, pageIndex, index == lastIndex, signSize, accessPermission, this.param.getDocument(), outputStream);
                signSize = (int)((double)signSize * 3.5);
            }
        }
        this.release();
    }

    void addSignature(boolean isAddInfo, PDDocument target, OutputStream outputStream) {
        XEasyPdfDocument pdfDocument = this.param.getPdfDocument();
        if (isAddInfo) {
            pdfDocument.replaceTotalPagePlaceholder(target, false);
            pdfDocument.setBasicInfo(target);
        }
        this.setMdpPermission(target, this.param.getSignature(), this.param.getAccessPermissions());
        this.resetSignForm(target);
        target.addSignature(this.param.getSignature(), this.getSignatureInterface(), this.param.getSignatureOptions());
        target.saveIncremental(outputStream);
        target.close();
    }

    void resetSignForm(PDDocument target) {
        PDAcroForm acroForm = target.getDocumentCatalog().getAcroForm(null);
        if (acroForm != null && acroForm.getNeedAppearances() && acroForm.getFields().isEmpty()) {
            acroForm.getCOSObject().removeItem(COSName.NEED_APPEARANCES);
        }
    }

    XEasyPdfDocumentSignerParam getParam() {
        return this.param;
    }

    private int addSignature(int index, int pageIndex, boolean isLast, int signSize, int accessPermission, PDDocument target, OutputStream outputStream) {
        this.param.setPreferredSignatureSize(signSize);
        if (isLast) {
            this.param.setAccessPermissions(accessPermission);
            this.param.init(pageIndex);
            this.addSignature(true, target, outputStream);
        } else {
            this.param.setAccessPermissions(accessPermission > 1 ? 2 : accessPermission);
            this.param.init(pageIndex);
            String tempPath = this.param.getTempDir() + File.separatorChar + index;
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempPath);){
                this.addSignature(false, target, fileOutputStream);
                try (InputStream inputStream = Files.newInputStream(Paths.get(tempPath, new String[0]), StandardOpenOption.DELETE_ON_CLOSE);){
                    this.param.setDocument(PDDocument.load((InputStream)inputStream));
                }
            }
        }
        return index + 1;
    }

    private SignatureInterface getSignatureInterface() {
        return this.param.getCustomSignature() != null ? this.param.getCustomSignature() : new XEasyPdfDocumentSignDefaultProcessor(this);
    }

    private int getMdpPermission(PDDocument doc) {
        COSDictionary signatureDict;
        COSDictionary permsDict;
        COSBase base = doc.getDocumentCatalog().getCOSObject().getDictionaryObject(COSName.PERMS);
        if (base instanceof COSDictionary && (base = (permsDict = (COSDictionary)base).getDictionaryObject(COSName.DOCMDP)) instanceof COSDictionary && (base = (signatureDict = (COSDictionary)base).getDictionaryObject("Reference")) instanceof COSArray) {
            COSArray refArray = (COSArray)base;
            for (int i = 0; i < refArray.size(); ++i) {
                COSDictionary sigRefDict;
                base = refArray.getObject(i);
                if (!(base instanceof COSDictionary) || !COSName.DOCMDP.equals((Object)(sigRefDict = (COSDictionary)base).getDictionaryObject("TransformMethod")) || !((base = sigRefDict.getDictionaryObject("TransformParams")) instanceof COSDictionary)) continue;
                COSDictionary transformDict = (COSDictionary)base;
                int accessPermissions = transformDict.getInt(COSName.P, 2);
                if (accessPermissions < 1 || accessPermissions > 3) {
                    accessPermissions = 2;
                }
                return accessPermissions;
            }
        }
        return 0;
    }

    private void setMdpPermission(PDDocument doc, PDSignature signature, int accessPermissions) {
        List signatureList = doc.getSignatureDictionaries();
        for (PDSignature sig : signatureList) {
            if (COSName.DOC_TIME_STAMP.equals((Object)sig.getCOSObject().getItem(COSName.TYPE)) || !sig.getCOSObject().containsKey(COSName.CONTENTS)) continue;
            return;
        }
        COSDictionary sigDict = signature.getCOSObject();
        COSDictionary transformParameters = new COSDictionary();
        transformParameters.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"TransformParams"));
        transformParameters.setInt(COSName.P, accessPermissions);
        transformParameters.setName(COSName.V, "1.2");
        transformParameters.setNeedToBeUpdated(true);
        COSDictionary referenceDict = new COSDictionary();
        referenceDict.setItem(COSName.TYPE, (COSBase)COSName.getPDFName((String)"SigRef"));
        referenceDict.setItem("TransformMethod", (COSBase)COSName.DOCMDP);
        referenceDict.setItem("DigestMethod", (COSBase)COSName.getPDFName((String)"SHA1"));
        referenceDict.setItem("TransformParams", (COSBase)transformParameters);
        referenceDict.setNeedToBeUpdated(true);
        COSArray referenceArray = new COSArray();
        referenceArray.add((COSBase)referenceDict);
        sigDict.setItem("Reference", (COSBase)referenceArray);
        referenceArray.setNeedToBeUpdated(true);
        COSDictionary catalogDict = doc.getDocumentCatalog().getCOSObject();
        COSDictionary permsDict = new COSDictionary();
        catalogDict.setItem(COSName.PERMS, (COSBase)permsDict);
        permsDict.setItem(COSName.DOCMDP, (COSObjectable)signature);
        catalogDict.setNeedToBeUpdated(true);
        permsDict.setNeedToBeUpdated(true);
    }

    private void release() {
        this.param.getDocument().close();
        this.param.getPdfDocument().close();
    }
}

