/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.util.XEasyPdfConvertUtil;
import wiki.xsx.core.pdf.util.XEasyPdfFileUtil;

public class XEasyPdfDocumentSplitter
implements Serializable {
    private static final long serialVersionUID = -1959028511245585789L;
    private final PDDocument document;
    private final XEasyPdfDocument pdfDocument;
    private final List<List<Integer>> documentList = new ArrayList<List<Integer>>(10);

    XEasyPdfDocumentSplitter(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.build(true);
    }

    public XEasyPdfDocumentSplitter addDocument(int ... pageIndex) {
        this.documentList.add(XEasyPdfConvertUtil.toInteger(pageIndex));
        return this;
    }

    public XEasyPdfDocumentSplitter split(String outputPath) {
        return this.split(outputPath, null);
    }

    public XEasyPdfDocumentSplitter split(String outputPath, String prefix) {
        if (prefix == null) {
            prefix = "x-easypdf";
        }
        if (!this.documentList.isEmpty()) {
            int count = this.documentList.size();
            for (int i = 0; i < count; ++i) {
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(i + 1).append(".pdf");
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(fileNameBuilder.toString(), new String[0])), new OpenOption[0]));){
                    this.split(outputStream, XEasyPdfConvertUtil.toInt(this.documentList.get(i)));
                    continue;
                }
            }
        } else {
            int index = 1;
            PDPageTree pageTree = this.document.getPages();
            for (PDPage sourcePage : pageTree) {
                PDDocument target = new PDDocument();
                PDPage importPage = target.importPage(sourcePage);
                importPage.setResources(sourcePage.getResources());
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(index).append(".pdf");
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(XEasyPdfFileUtil.createDirectories(Paths.get(fileNameBuilder.toString(), new String[0])), new OpenOption[0]));){
                    this.pdfDocument.replaceTotalPagePlaceholder(target, false);
                    this.pdfDocument.setBasicInfo(target);
                    target.save((OutputStream)outputStream);
                    target.close();
                }
                ++index;
            }
        }
        return this;
    }

    public XEasyPdfDocumentSplitter split(OutputStream outputStream, int ... pageIndex) {
        try (PDDocument target = new PDDocument();){
            PDPageTree sourcePages = this.document.getPages();
            for (int index : pageIndex) {
                PDPage pdPage = sourcePages.get(index);
                PDPage importPage = target.importPage(pdPage);
                importPage.setResources(pdPage.getResources());
            }
            this.pdfDocument.replaceTotalPagePlaceholder(target, false);
            this.pdfDocument.setBasicInfo(target);
            target.save(outputStream);
        }
        return this;
    }

    public XEasyPdfDocument finish() {
        return this.pdfDocument;
    }
}

