/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPageParam;
import wiki.xsx.core.pdf.doc.XEasyPdfPageRectangle;
import wiki.xsx.core.pdf.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.mark.XEasyPdfWatermark;

public class XEasyPdfPage
implements Serializable {
    private static final long serialVersionUID = 2960592445501222343L;
    private final XEasyPdfPageParam param = new XEasyPdfPageParam();

    XEasyPdfPage(PDPage page) {
        if (page != null) {
            this.param.setLastPage(page);
            this.param.setOriginalPageSize(new XEasyPdfPageRectangle(page.getMediaBox()));
            this.param.setCurrentPageSize(new XEasyPdfPageRectangle(page.getTrimBox()));
            this.param.getPageList().add(page);
        }
    }

    public XEasyPdfPage(XEasyPdfPageRectangle pageSize) {
        if (pageSize != null) {
            this.param.setLastPage(new PDPage(pageSize.getSize()));
            this.param.setOriginalPageSize(pageSize);
            this.param.setCurrentPageSize(pageSize);
        } else {
            this.param.setLastPage(new PDPage(XEasyPdfPageRectangle.A4.getSize()));
        }
    }

    public XEasyPdfPage setRotation(Rotation rotation) {
        this.param.setRotation(rotation.rotation);
        return this;
    }

    public XEasyPdfPage setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public String getFontPath() {
        return this.param.getFontPath();
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public XEasyPdfPage setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfPage setPageX(Float pageX) {
        this.param.setPageX(pageX);
        return this;
    }

    public Float getPageX() {
        return this.param.getPageX();
    }

    public XEasyPdfPage setPageY(Float pageY) {
        this.param.setPageY(pageY);
        return this;
    }

    public Float getPageY() {
        return this.param.getPageY();
    }

    public XEasyPdfPage setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        if (contentMode != null) {
            this.param.setContentMode(contentMode);
        }
        return this;
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.param.getContentMode();
    }

    public XEasyPdfPage setBackgroundImage(XEasyPdfImage backgroundImage) {
        this.param.setBackgroundImage(backgroundImage);
        return this;
    }

    public XEasyPdfImage getBackgroundImage() {
        return this.param.getBackgroundImage();
    }

    public XEasyPdfPage setBackgroundColor(Color backgroundColor) {
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public Color getBackgroundColor() {
        return this.param.getBackgroundColor();
    }

    public XEasyPdfPage setWatermark(XEasyPdfWatermark watermark) {
        this.param.setWatermark(watermark);
        return this;
    }

    public XEasyPdfWatermark getWatermark() {
        return this.param.getWatermark();
    }

    public XEasyPdfPage setHeader(XEasyPdfHeader header) {
        this.param.setHeader(header);
        return this;
    }

    public XEasyPdfHeader getHeader() {
        return this.param.getHeader();
    }

    public XEasyPdfPage setFooter(XEasyPdfFooter footer) {
        this.param.setFooter(footer);
        return this;
    }

    public XEasyPdfFooter getFooter() {
        return this.param.getFooter();
    }

    public float getUnit() {
        return XEasyPdfPageRectangle.getUnit();
    }

    public float getWidth() {
        return this.param.getCurrentPageSize().getWidth();
    }

    public float getHeight() {
        return this.param.getCurrentPageSize().getHeight();
    }

    public XEasyPdfPageRectangle getRectangle() {
        return this.param.getCurrentPageSize();
    }

    public float getRectangleLeftX() {
        return this.param.getCurrentPageSize().getLeftX();
    }

    public float getRectangleRightX() {
        return this.param.getCurrentPageSize().getRightX();
    }

    public float getRectangleBottomY() {
        return this.param.getCurrentPageSize().getBottomY();
    }

    public float getRectangleTopY() {
        return this.param.getCurrentPageSize().getTopY();
    }

    public float getOriginalWidth() {
        return this.param.getOriginalPageSize().getWidth();
    }

    public float getOriginalHeight() {
        return this.param.getOriginalPageSize().getHeight();
    }

    public XEasyPdfPageRectangle getOriginalRectangle() {
        return this.param.getOriginalPageSize();
    }

    public float getOriginalRectangleLeftX() {
        return this.param.getOriginalPageSize().getLeftX();
    }

    public float getOriginalRectangleRightX() {
        return this.param.getOriginalPageSize().getRightX();
    }

    public float getOriginalRectangleBottomY() {
        return this.param.getOriginalPageSize().getBottomY();
    }

    public float getOriginalRectangleTopY() {
        return this.param.getOriginalPageSize().getTopY();
    }

    public PDPage getLastPage() {
        return this.param.getLastPage();
    }

    public int getCurrentIndex(XEasyPdfDocument document) {
        return document.getParam().getTotalPage();
    }

    public List<PDPage> getPageList() {
        return this.param.getPageList();
    }

    public List<PDPage> getNewPageList() {
        return this.param.getNewPageList();
    }

    public XEasyPdfPage disableBackgroundColor() {
        this.param.setAllowBackgroundColor(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage disableBackgroundImage() {
        this.param.setAllowBackgroundImage(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage disableWatermark() {
        this.param.setAllowWatermark(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage disableHeader() {
        this.param.setAllowHeader(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage disableFooter() {
        this.param.setAllowFooter(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage disableRotateInherentPage() {
        this.param.setAllowRotateInherentPage(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage enablePosition() {
        this.param.setAllowResetPosition(Boolean.TRUE);
        return this;
    }

    public XEasyPdfPage disablePosition() {
        this.param.setAllowResetPosition(Boolean.FALSE);
        return this;
    }

    public XEasyPdfPage enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public boolean isAllowResetPosition() {
        return this.param.getAllowResetPosition();
    }

    public boolean isAllowHeader() {
        return this.param.getAllowHeader();
    }

    public boolean isAllowFooter() {
        return this.param.getAllowFooter();
    }

    public boolean isAllowWatermark() {
        return this.param.getAllowWatermark();
    }

    public boolean isAllowBackgroundImage() {
        return this.param.getAllowBackgroundImage();
    }

    public boolean isAllowBackgroundColor() {
        return this.param.getAllowBackgroundColor();
    }

    public boolean isAllowRotateInherentPage() {
        return this.param.getAllowRotateInherentPage();
    }

    public boolean isResetContext() {
        return this.param.getIsResetContext();
    }

    public XEasyPdfPage addNewPage(XEasyPdfDocument document, PDRectangle pageSize) {
        PDPage page;
        PDPage pDPage = page = pageSize == null ? new PDPage(this.param.getOriginalPageSize().getSize()) : new PDPage(pageSize);
        if (this.param.getRotation() != null) {
            page.setRotation(this.param.getRotation().intValue());
        }
        this.param.setLastPage(page);
        this.param.getNewPageList().add(page);
        this.initPage(document);
        return this;
    }

    public XEasyPdfPage addComponent(XEasyPdfComponent ... components) {
        if (components != null) {
            Collections.addAll(this.param.getComponentList(), components);
        }
        return this;
    }

    public XEasyPdfPage addComponent(List<XEasyPdfComponent> components) {
        if (components != null && !components.isEmpty()) {
            this.param.getComponentList().addAll(components);
        }
        return this;
    }

    public XEasyPdfPage modifyPageSize(XEasyPdfPageRectangle pageSize) {
        if (pageSize != null) {
            this.param.setCurrentPageSize(pageSize);
            this.param.setModifyPageSize(pageSize.getSize());
        }
        return this;
    }

    void build(XEasyPdfDocument document) {
        this.build(document, this.param.getOriginalPageSize());
    }

    void build(XEasyPdfDocument document, XEasyPdfPageRectangle pageSize) {
        this.param.init(document, this);
        if (this.param.getPageList().isEmpty()) {
            this.addNewPage(document, pageSize.getSize());
        } else {
            PDRectangle modifyPageSize = this.param.getModifyPageSize();
            List<PDPage> pageList = this.param.getPageList();
            for (PDPage page : pageList) {
                if (modifyPageSize != null) {
                    this.modifyPageSize(page, modifyPageSize);
                }
                if (!this.param.getAllowRotateInherentPage().booleanValue() || this.param.getRotation() == null) continue;
                page.setRotation(this.param.getRotation().intValue());
            }
            this.initPage(document);
        }
        List<XEasyPdfComponent> componentList = this.param.getComponentList();
        if (!componentList.isEmpty()) {
            for (XEasyPdfComponent component : componentList) {
                if (component == null) continue;
                component.draw(document, this);
            }
        }
        this.drawWatermark(document);
    }

    private void modifyPageSize(PDPage page, PDRectangle pageSize) {
        page.setCropBox(pageSize);
    }

    private void setLastPageBackgroundColor(XEasyPdfDocument document) {
        PDPage lastPage;
        if (this.param.getAllowBackgroundColor().booleanValue() && !Color.WHITE.equals(this.param.getBackgroundColor()) && (lastPage = this.getLastPage()) != null) {
            PDRectangle rectangle = lastPage.getMediaBox();
            PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), lastPage, PDPageContentStream.AppendMode.PREPEND, true, this.param.getIsResetContext().booleanValue());
            contentStream.addRect(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight());
            contentStream.setNonStrokingColor(this.param.getBackgroundColor());
            contentStream.fill();
            contentStream.setNonStrokingColor(Color.BLACK);
            contentStream.close();
        }
    }

    private void initPage(XEasyPdfDocument document) {
        document.getParam().initTotalPage(1);
        this.param.setPageX(null).setPageY(null);
        this.drawHeaderAndFooter(document);
        this.drawBackgroundImage(document);
        this.setLastPageBackgroundColor(document);
    }

    private void drawBackgroundImage(XEasyPdfDocument document) {
        if (this.param.getAllowBackgroundImage().booleanValue() && this.param.getBackgroundImage() != null) {
            Float pageX = this.param.getPageX();
            Float pageY = this.param.getPageY();
            this.param.setPageX(null).setPageY(null);
            this.disablePosition();
            this.param.getBackgroundImage().setContentMode(XEasyPdfComponent.ContentMode.PREPEND).draw(document, this);
            this.enablePosition();
            this.param.setPageX(pageX).setPageY(pageY);
        }
    }

    private void drawHeaderAndFooter(XEasyPdfDocument document) {
        this.drawHeader(document);
        this.drawFooter(document);
    }

    private void drawHeader(XEasyPdfDocument document) {
        if (this.param.getAllowHeader().booleanValue()) {
            if (this.param.getHeader() == null) {
                this.param.setHeader(document.getGlobalHeader());
            }
            if (this.param.getHeader() != null) {
                this.param.getHeader().draw(document, this);
            }
        }
    }

    private void drawFooter(XEasyPdfDocument document) {
        if (this.param.getAllowFooter().booleanValue()) {
            if (this.param.getFooter() == null) {
                this.param.setFooter(document.getGlobalFooter());
            }
            if (this.param.getFooter() != null) {
                this.param.getFooter().draw(document, this);
            }
        }
    }

    private void drawWatermark(XEasyPdfDocument document) {
        if (this.param.getAllowWatermark().booleanValue()) {
            XEasyPdfWatermark watermark = this.param.getWatermark();
            if (watermark == null) {
                watermark = document.getGlobalWatermark();
            }
            if (watermark != null) {
                watermark.draw(document, this);
            }
        }
    }

    public static enum Rotation {
        FORWARD_0(0),
        FORWARD_90(90),
        FORWARD_180(180),
        FORWARD_270(270);

        private final int rotation;

        private Rotation(int rotation) {
            this.rotation = rotation;
        }
    }
}

