/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.footer;

import java.io.Serializable;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;

class XEasyPdfFooterParam
implements Serializable {
    private static final long serialVersionUID = -1024397509263922127L;
    private Boolean isResetContext;
    private XEasyPdfText text;
    private XEasyPdfImage image;
    private XEasyPdfComponent component;
    private Float height;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(5.0f);
    private Float beginX;
    private Float beginY;

    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.isResetContext == null) {
            this.isResetContext = page.isResetContext();
        }
        this.initHeight(document, page);
        this.beginX = this.marginLeft;
        this.beginY = Float.valueOf(0.0f);
    }

    private void initHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        float textHeight = 0.0f;
        if (this.text != null) {
            textHeight = this.text.getHeight(document, page);
        }
        float imageHeight = 0.0f;
        if (this.image != null) {
            this.image.disableSelfAdaption();
            if (this.image.getWidth(document, page) == null) {
                this.image.setWidth(page.getLastPage().getMediaBox().getWidth());
            }
            imageHeight = this.image.getHeight(document, page).intValue();
        }
        if (this.height == null) {
            this.height = Float.valueOf(Math.max(textHeight, imageHeight) + this.marginBottom.floatValue());
        }
    }

    public Boolean getIsResetContext() {
        return this.isResetContext;
    }

    public XEasyPdfText getText() {
        return this.text;
    }

    public XEasyPdfImage getImage() {
        return this.image;
    }

    public XEasyPdfComponent getComponent() {
        return this.component;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public XEasyPdfFooterParam setIsResetContext(Boolean isResetContext) {
        this.isResetContext = isResetContext;
        return this;
    }

    public XEasyPdfFooterParam setText(XEasyPdfText text) {
        this.text = text;
        return this;
    }

    public XEasyPdfFooterParam setImage(XEasyPdfImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfFooterParam setComponent(XEasyPdfComponent component) {
        this.component = component;
        return this;
    }

    public XEasyPdfFooterParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfFooterParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfFooterParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfFooterParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfFooterParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfFooterParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfFooterParam)) {
            return false;
        }
        XEasyPdfFooterParam other = (XEasyPdfFooterParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isResetContext = this.getIsResetContext();
        Boolean other$isResetContext = other.getIsResetContext();
        if (this$isResetContext == null ? other$isResetContext != null : !((Object)this$isResetContext).equals(other$isResetContext)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        XEasyPdfText this$text = this.getText();
        XEasyPdfText other$text = other.getText();
        if (this$text == null ? other$text != null : !((Object)this$text).equals(other$text)) {
            return false;
        }
        XEasyPdfImage this$image = this.getImage();
        XEasyPdfImage other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        XEasyPdfComponent this$component = this.getComponent();
        XEasyPdfComponent other$component = other.getComponent();
        return !(this$component == null ? other$component != null : !this$component.equals(other$component));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfFooterParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isResetContext = this.getIsResetContext();
        result = result * 59 + ($isResetContext == null ? 43 : ((Object)$isResetContext).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        XEasyPdfText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : ((Object)$text).hashCode());
        XEasyPdfImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        XEasyPdfComponent $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfFooterParam(isResetContext=" + this.getIsResetContext() + ", text=" + this.getText() + ", image=" + this.getImage() + ", component=" + this.getComponent() + ", height=" + this.getHeight() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginBottom=" + this.getMarginBottom() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ")";
    }
}

