/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.image;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageParam;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageStyle;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

public class XEasyPdfImage
implements XEasyPdfComponent {
    private final XEasyPdfImageParam param = new XEasyPdfImageParam();

    public XEasyPdfImage(File imageFile) {
        this.param.setImageType(XEasyPdfImageUtil.parseType(imageFile)).setImage(XEasyPdfImageUtil.read(imageFile));
    }

    public XEasyPdfImage(InputStream imageStream, XEasyPdfImageType imageType) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(XEasyPdfImageUtil.read(imageStream));
    }

    public XEasyPdfImage(File imageFile, int width, int height) {
        this.param.setImageType(XEasyPdfImageUtil.parseType(imageFile)).setImage(XEasyPdfImageUtil.read(imageFile)).setWidth(width).setHeight(height);
    }

    public XEasyPdfImage(InputStream imageStream, XEasyPdfImageType imageType, int width, int height) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(XEasyPdfImageUtil.read(imageStream)).setWidth(width).setHeight(height);
    }

    public XEasyPdfImage setImage(File imageFile) {
        this.param.setImageType(XEasyPdfImageUtil.parseType(imageFile)).setImage(XEasyPdfImageUtil.read(imageFile));
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage setImage(InputStream imageStream, XEasyPdfImageType imageType) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(XEasyPdfImageUtil.read(imageStream));
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage enableSelfAdaption() {
        this.param.setEnableSelfAdaption(true);
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage disableSelfAdaption() {
        this.param.setEnableSelfAdaption(false);
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage enableSelfStyle() {
        this.param.setUseSelfStyle(true);
        return this;
    }

    public XEasyPdfImage disableSelfStyle() {
        this.param.setUseSelfStyle(false);
        return this;
    }

    public XEasyPdfImage setMaxWidth(float maxWidth) {
        this.param.setMaxWidth(Float.valueOf(maxWidth));
        return this;
    }

    public XEasyPdfImage setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setStyle(XEasyPdfImageStyle style) {
        this.param.setStyle(style);
        return this;
    }

    @Override
    public XEasyPdfImage setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfImage setWidth(float width) {
        this.param.setWidth((int)width);
        this.param.setImageXObject(null);
        return this;
    }

    @Override
    public XEasyPdfImage setHeight(float height) {
        this.param.setHeight((int)height);
        this.param.setImageXObject(null);
        return this;
    }

    @Override
    public XEasyPdfImage setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDImageXObject pdImage = this.param.init(document, page);
        this.param.initPosition(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, false);
        contentStream.drawImage(pdImage, this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue());
        contentStream.close();
        if (page.getParam().isAllowResetPosition()) {
            page.getParam().setPageX(this.param.getBeginX()).setPageY(this.param.getBeginY());
        }
        this.param.setDraw(true);
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }

    public float getWidth(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        return this.param.init(document, page).getWidth();
    }

    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        return this.param.init(document, page).getHeight();
    }

    public float getMarginTop() {
        return this.param.getMarginTop().floatValue();
    }

    public float getMarginBottom() {
        return this.param.getMarginBottom().floatValue();
    }

    public float getMarginLeft() {
        return this.param.getMarginLeft().floatValue();
    }

    public float getMarginRight() {
        return this.param.getMarginRight().floatValue();
    }

    public XEasyPdfImageStyle getStyle() {
        return this.param.getStyle();
    }

    public boolean isUseSelfStyle() {
        return this.param.isUseSelfStyle();
    }
}

