/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.line;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineCapStyle;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfBaseLine
implements XEasyPdfLine {
    private XEasyPdfLineParam param = new XEasyPdfLineParam();

    public XEasyPdfBaseLine(XEasyPdfLineParam param) {
        this.param = param;
    }

    public XEasyPdfBaseLine(float beginX, float beginY, float endX, float endY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY)).setEndX(Float.valueOf(endX)).setEndY(Float.valueOf(endY));
    }

    @Override
    public XEasyPdfBaseLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    @Override
    public XEasyPdfBaseLine setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    @Override
    public XEasyPdfBaseLine setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(lineWidth));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setColor(Color color) {
        this.param.setColor(color);
        return this;
    }

    @Override
    public XEasyPdfBaseLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        this.param.setStyle(lineCapStyle);
        return this;
    }

    public XEasyPdfBaseLine setPosition(float beginX, float beginY, float endX, float endY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY)).setEndX(Float.valueOf(endX)).setEndY(Float.valueOf(endY));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setWidth(float width) {
        this.param.setEndX(Float.valueOf(this.param.getBeginX().floatValue() + width));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setHeight(float height) {
        this.param.setEndY(Float.valueOf(this.param.getBeginY().floatValue() - height));
        return this;
    }

    @Override
    public XEasyPdfBaseLine setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    @Override
    public PDFont getFont() {
        return this.param.getFont();
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDPageContentStream contentStream = this.initStream(document, page);
        contentStream.moveTo(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue());
        contentStream.setStrokingColor(this.param.getColor());
        contentStream.lineTo(this.param.getEndX().floatValue(), this.param.getEndY().floatValue());
        contentStream.stroke();
        contentStream.setStrokingColor(Color.BLACK);
        contentStream.close();
        this.param.setDraw(true);
        if (this.param.getFontPath() != null && this.param.getFontPath().length() > 0) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }

    private PDPageContentStream initStream(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.init(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, false);
        contentStream.setFont(this.param.getFont(), this.param.getFontSize().floatValue());
        contentStream.setLineWidth(this.param.getLineWidth().floatValue());
        contentStream.setLineCapStyle(this.param.getStyle().getType());
        return contentStream;
    }

    private void init(XEasyPdfDocument document, XEasyPdfPage page) {
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        if (this.param.getBeginX() == null) {
            this.param.setBeginX(page.getParam().getPageX() == null ? this.param.getMarginLeft() : page.getParam().getPageX());
        }
        if (this.param.getBeginY() == null) {
            this.param.setBeginY(page.getParam().getPageY() == null ? this.param.getMarginTop() : page.getParam().getPageY());
        }
        if (this.param.getEndX() == null) {
            this.param.setEndX(Float.valueOf(rectangle.getWidth()));
        }
        if (this.param.getEndY() == null) {
            this.param.setEndY(Float.valueOf(rectangle.getHeight()));
        }
        if (this.param.getFont() == null) {
            this.param.setFont(XEasyPdfFontUtil.loadFont(document, page, this.param.getFontPath()));
        }
    }
}

