/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.rect;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.rect.XEasyPdfRectParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfRect
implements XEasyPdfComponent {
    private final XEasyPdfRectParam param = new XEasyPdfRectParam();

    public XEasyPdfRect(float width, float height) {
        this.param.setWidth(Float.valueOf(width)).setHeight(Float.valueOf(height));
    }

    public XEasyPdfRect(float width, float height, Float beginX, Float beginY) {
        this.param.setWidth(Float.valueOf(width)).setHeight(Float.valueOf(height)).setBeginX(beginX).setBeginY(beginY);
    }

    public XEasyPdfRect enableCheckPage() {
        this.param.setCheckPage(true);
        return this;
    }

    public XEasyPdfRect disableCheckPage() {
        this.param.setCheckPage(false);
        return this;
    }

    public XEasyPdfRect setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRect setHasBorder(boolean hasBorder) {
        this.param.setHasBorder(hasBorder);
        return this;
    }

    public XEasyPdfRect setBorderWidth(float borderWidth) {
        this.param.setBorderWidth(Float.valueOf(borderWidth));
        return this;
    }

    public XEasyPdfRect setBackgroundColor(Color backgroundColor) {
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public XEasyPdfRect setBorderColor(Color borderColor) {
        this.param.setBorderColor(borderColor);
        return this;
    }

    public XEasyPdfRect setNewLine(boolean newLine) {
        this.param.setNewLine(newLine);
        return this;
    }

    @Override
    public XEasyPdfRect setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfRect setWidth(float width) {
        this.param.setWidth(Float.valueOf(width));
        return this;
    }

    @Override
    public XEasyPdfRect setHeight(float height) {
        this.param.setHeight(Float.valueOf(height));
        return this;
    }

    @Override
    public XEasyPdfRect setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.param.init(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, false);
        if (this.param.isHasBorder()) {
            contentStream.addRect(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue(), this.param.getWidth().floatValue(), this.param.getHeight().floatValue());
            contentStream.setNonStrokingColor(this.param.getBorderColor());
            contentStream.fill();
            contentStream.addRect(this.param.getBeginX().floatValue() + this.param.getBorderWidth().floatValue(), this.param.getBeginY().floatValue() + this.param.getBorderWidth().floatValue(), this.param.getWidth().floatValue() - this.param.getBorderWidth().floatValue() * 2.0f, this.param.getHeight().floatValue() - this.param.getBorderWidth().floatValue() * 2.0f);
            contentStream.setNonStrokingColor(this.param.getBackgroundColor());
            contentStream.fill();
        } else {
            contentStream.addRect(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue(), this.param.getWidth().floatValue(), this.param.getHeight().floatValue());
            contentStream.setNonStrokingColor(this.param.getBackgroundColor());
            contentStream.fill();
        }
        contentStream.setNonStrokingColor(Color.BLACK);
        contentStream.close();
        if (page.getParam().isAllowResetPosition()) {
            if (this.param.isNewLine()) {
                page.getParam().setPageX(null);
                page.getParam().setPageY(this.param.getBeginY());
            } else {
                page.getParam().setPageX(Float.valueOf(this.param.getBeginX().floatValue() + this.param.getWidth().floatValue()));
            }
        }
        this.param.setDraw(true);
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }
}

