/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.table.XEasyPdfCellParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableStyle;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.handler.XEasyPdfHandler;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfCell {
    private final XEasyPdfCellParam param = new XEasyPdfCellParam();

    public XEasyPdfCell(float width, float height) {
        this.param.setWidth(Float.valueOf(width)).setHeight(Float.valueOf(height));
    }

    public XEasyPdfCell setWidth(float width) {
        this.param.setWidth(Float.valueOf(width));
        return this;
    }

    public XEasyPdfCell setHeight(float height) {
        this.param.setHeight(Float.valueOf(height));
        return this;
    }

    public XEasyPdfCell setBackgroundColor(Color backgroundColor) {
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public XEasyPdfCell setBorderColor(Color borderColor) {
        this.param.setBorderColor(borderColor);
        return this;
    }

    public XEasyPdfCell setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell enableBorder() {
        this.param.setHasBorder(true);
        return this;
    }

    public XEasyPdfCell disableBorder() {
        this.param.setHasBorder(false);
        return this;
    }

    public XEasyPdfCell setBorderWidth(float lineWidth) {
        this.param.setBorderWidth(lineWidth);
        return this;
    }

    public XEasyPdfCell setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfCell setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfCell setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfCell setFontColor(Color fontColor) {
        this.param.setFontColor(fontColor);
        return this;
    }

    public XEasyPdfCell setStyle(XEasyPdfTableStyle style) {
        this.param.setStyle(style);
        return this;
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public XEasyPdfCell enableNewLine() {
        this.param.setNewLine(true);
        return this;
    }

    public XEasyPdfCell disableNewLine() {
        this.param.setNewLine(false);
        return this;
    }

    public XEasyPdfCell addContent(XEasyPdfComponent ... components) {
        Collections.addAll(this.param.getComponentList(), components);
        return this;
    }

    public XEasyPdfCell addContent(List<XEasyPdfComponent> componentList) {
        this.param.getComponentList().addAll(componentList);
        return this;
    }

    XEasyPdfCellParam getParam() {
        return this.param;
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) throws IOException {
        this.param.init(document, page, row);
        if (this.param.isHasBorder()) {
            this.writeBorder(document, page, row);
        }
        List<XEasyPdfComponent> componentList = this.param.getComponentList();
        if (this.param.isNewLine()) {
            page.enablePosition();
        }
        float pageY = page.getParam().getPageY().floatValue();
        float rowBeginX = row.getParam().getBeginX().floatValue();
        for (XEasyPdfComponent component : componentList) {
            if (component instanceof XEasyPdfText) {
                this.writeText(document, page, row, (XEasyPdfText)component);
                continue;
            }
            if (!(component instanceof XEasyPdfImage)) continue;
            this.writeImage(document, page, row, (XEasyPdfImage)component);
        }
        row.getParam().setBeginX(Float.valueOf(rowBeginX));
        page.getParam().setPageY(Float.valueOf(pageY));
        page.disablePosition();
        if (this.param.getFontPath() != null && this.param.getFontPath().length() > 0) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    private void writeBorder(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) throws IOException {
        XEasyPdfHandler.Rect.build(this.param.getWidth().floatValue(), this.param.getHeight().floatValue(), row.getParam().getBeginX().floatValue(), row.getParam().getBeginY().floatValue()).setContentMode(this.param.getContentMode()).setBackgroundColor(this.param.getBackgroundColor()).setBorderColor(this.param.getBorderColor()).setBorderWidth(this.param.getBorderWidth()).setNewLine(false).setHasBorder(true).disableCheckPage().draw(document, page);
    }

    private void writeText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfText text) throws IOException {
        float width = this.param.getWidth().floatValue() - this.param.getBorderWidth() * 2.0f;
        float height = this.param.getHeight().floatValue() - this.param.getBorderWidth() * 2.0f;
        text.setContentMode(this.param.getContentMode()).enableChildComponent().setWidth(width).setHeight(height).setFont(this.param.getFont()).setFontSize(this.param.getFontSize().floatValue()).setFontColor(this.param.getFontColor()).setStyle(text.isUseSelfStyle() ? text.getStyle() : this.param.getStyle().getTextStyle()).setPosition(row.getParam().getBeginX().floatValue() + this.param.getBorderWidth(), page.getParam().getPageY().floatValue() - row.getParam().getMarginTop().floatValue() - text.getMarginTop() - this.param.getFontSize().floatValue() + this.param.getBorderWidth()).draw(document, page);
    }

    private void writeImage(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row, XEasyPdfImage image) throws IOException {
        float width = Math.min(image.getWidth(document, page), this.param.getWidth().floatValue()) - this.param.getBorderWidth();
        float height = Math.min(image.getHeight(document, page), this.param.getHeight().floatValue()) - this.param.getBorderWidth();
        image.setContentMode(this.param.getContentMode()).setWidth(width - this.param.getBorderWidth() * 2.0f).setMaxWidth(this.param.getWidth().floatValue() - this.param.getBorderWidth() * 2.0f).setHeight(height - this.param.getBorderWidth() * 2.0f).setStyle(image.isUseSelfStyle() ? image.getStyle() : this.param.getStyle().getImageStyle()).setPosition(row.getParam().getBeginX().floatValue() + this.param.getBorderWidth() / 2.0f, page.getParam().getPageY().floatValue() - row.getParam().getMarginTop().floatValue() - image.getMarginTop() - image.getHeight(document, page) - this.param.getBorderWidth() / 2.0f).draw(document, page);
    }
}

