/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfRowParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfCellParam {
    private XEasyPdfComponent.ContentMode contentMode;
    private boolean isNewLine = true;
    private boolean hasBorder = true;
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private Float width;
    private Float height;
    private List<XEasyPdfComponent> componentList = new ArrayList<XEasyPdfComponent>(10);
    private String fontPath;
    private PDFont font;
    private Float fontSize;
    private Color fontColor = Color.BLACK;
    private float borderWidth = 1.0f;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private XEasyPdfTableStyle style;

    void init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) throws IOException {
        XEasyPdfRowParam rowParam = row.getParam();
        if (this.contentMode == null) {
            this.contentMode = rowParam.getContentMode();
        }
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.getFont(document, this.fontPath, rowParam.getFont());
        }
        if (this.fontSize == null) {
            this.fontSize = rowParam.getFontSize();
        }
        if (this.style == null) {
            this.style = rowParam.getStyle();
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public boolean isNewLine() {
        return this.isNewLine;
    }

    public boolean isHasBorder() {
        return this.hasBorder;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public List<XEasyPdfComponent> getComponentList() {
        return this.componentList;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public XEasyPdfTableStyle getStyle() {
        return this.style;
    }

    public XEasyPdfCellParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfCellParam setNewLine(boolean isNewLine) {
        this.isNewLine = isNewLine;
        return this;
    }

    public XEasyPdfCellParam setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfCellParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfCellParam setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public XEasyPdfCellParam setWidth(Float width) {
        this.width = width;
        return this;
    }

    public XEasyPdfCellParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfCellParam setComponentList(List<XEasyPdfComponent> componentList) {
        this.componentList = componentList;
        return this;
    }

    public XEasyPdfCellParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfCellParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfCellParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfCellParam setFontColor(Color fontColor) {
        this.fontColor = fontColor;
        return this;
    }

    public XEasyPdfCellParam setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public XEasyPdfCellParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfCellParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfCellParam setStyle(XEasyPdfTableStyle style) {
        this.style = style;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfCellParam)) {
            return false;
        }
        XEasyPdfCellParam other = (XEasyPdfCellParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNewLine() != other.isNewLine()) {
            return false;
        }
        if (this.isHasBorder() != other.isHasBorder()) {
            return false;
        }
        if (Float.compare(this.getBorderWidth(), other.getBorderWidth()) != 0) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        List<XEasyPdfComponent> this$componentList = this.getComponentList();
        List<XEasyPdfComponent> other$componentList = other.getComponentList();
        if (this$componentList == null ? other$componentList != null : !((Object)this$componentList).equals(other$componentList)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Color this$fontColor = this.getFontColor();
        Color other$fontColor = other.getFontColor();
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        XEasyPdfTableStyle this$style = this.getStyle();
        XEasyPdfTableStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfCellParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNewLine() ? 79 : 97);
        result = result * 59 + (this.isHasBorder() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getBorderWidth());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        List<XEasyPdfComponent> $componentList = this.getComponentList();
        result = result * 59 + ($componentList == null ? 43 : ((Object)$componentList).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Color $fontColor = this.getFontColor();
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        XEasyPdfTableStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfCellParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", isNewLine=" + this.isNewLine() + ", hasBorder=" + this.isHasBorder() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", componentList=" + this.getComponentList() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", fontColor=" + this.getFontColor() + ", borderWidth=" + this.getBorderWidth() + ", marginLeft=" + this.getMarginLeft() + ", marginTop=" + this.getMarginTop() + ", style=" + (Object)((Object)this.getStyle()) + ")";
    }
}

