/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table.simple;

import java.awt.Color;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableStyle;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleCellParam;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleRow;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.handler.XEasyPdfHandler;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfSimpleCell {
    private final XEasyPdfSimpleCellParam param = new XEasyPdfSimpleCellParam();

    public XEasyPdfSimpleCell(float width) {
        this.param.setWidth(Float.valueOf(width));
    }

    public XEasyPdfSimpleCell(float width, float height) {
        this.param.setWidth(Float.valueOf(width)).setHeight(Float.valueOf(height));
    }

    public XEasyPdfSimpleCell setWidth(float width) {
        this.param.setWidth(Float.valueOf(width + 1.0f));
        return this;
    }

    public XEasyPdfSimpleCell setHeight(float height) {
        this.param.setHeight(Float.valueOf(height));
        return this;
    }

    public XEasyPdfSimpleCell setBackgroundColor(Color backgroundColor) {
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public XEasyPdfSimpleCell setBorderColor(Color borderColor) {
        this.param.setBorderColor(borderColor);
        return this;
    }

    public XEasyPdfSimpleCell setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleCell setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleCell setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfSimpleCell setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfSimpleCell setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfSimpleCell setFontColor(Color fontColor) {
        this.param.setFontColor(fontColor);
        return this;
    }

    public XEasyPdfSimpleCell setStyle(XEasyPdfTableStyle style) {
        this.param.setStyle(style);
        return this;
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public XEasyPdfSimpleCell enableNewLine() {
        this.param.setNewLine(true);
        return this;
    }

    public XEasyPdfSimpleCell disableNewLine() {
        this.param.setNewLine(false);
        return this;
    }

    public XEasyPdfSimpleCell addContent(XEasyPdfComponent ... components) {
        Collections.addAll(this.param.getComponentList(), components);
        return this;
    }

    public XEasyPdfSimpleCell addContent(List<XEasyPdfComponent> componentList) {
        this.param.getComponentList().addAll(componentList);
        return this;
    }

    XEasyPdfSimpleCellParam getParam() {
        return this.param;
    }

    float init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleRow row) throws IOException {
        this.param.init(document, page, row);
        float rowHeight = 0.0f;
        List<XEasyPdfComponent> componentList = this.param.getComponentList();
        for (XEasyPdfComponent component : componentList) {
            if (component instanceof XEasyPdfText) {
                XEasyPdfText text = (XEasyPdfText)component;
                this.initText(document, page, row, text);
                rowHeight += text.getHeight(document, page, text.getMarginLeft(), text.getMarginRight());
                continue;
            }
            if (!(component instanceof XEasyPdfImage)) continue;
            XEasyPdfImage image = (XEasyPdfImage)component;
            this.initImage(document, page, row, (XEasyPdfImage)component);
            rowHeight += image.getHeight(document, page);
        }
        return rowHeight;
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleRow row) throws IOException {
        if (this.param.getHeight() == null) {
            this.param.setHeight(row.getParam().getHeight());
        }
        if (this.param.isHasBorder()) {
            this.writeBorder(document, page, row);
        }
        List<XEasyPdfComponent> componentList = this.param.getComponentList();
        if (this.param.isNewLine()) {
            page.enablePosition();
        }
        float pageY = page.getParam().getPageY().floatValue();
        float rowBeginX = row.getParam().getBeginX().floatValue();
        for (XEasyPdfComponent component : componentList) {
            if (component instanceof XEasyPdfText) {
                XEasyPdfText text = (XEasyPdfText)component;
                text.setPosition(row.getParam().getBeginX().floatValue() + this.param.getBorderWidth(), page.getParam().getPageY().floatValue() - row.getParam().getMarginTop().floatValue() - text.getMarginTop() - this.param.getFontSize().floatValue() + this.param.getBorderWidth()).draw(document, page);
                continue;
            }
            if (!(component instanceof XEasyPdfImage)) continue;
            XEasyPdfImage image = (XEasyPdfImage)component;
            image.setPosition(row.getParam().getBeginX().floatValue() + this.param.getBorderWidth() / 2.0f, page.getParam().getPageY().floatValue() - row.getParam().getMarginTop().floatValue() - image.getMarginTop() - image.getHeight(document, page) - this.param.getBorderWidth() / 2.0f).draw(document, page);
        }
        row.getParam().setBeginX(Float.valueOf(rowBeginX));
        page.getParam().setPageY(Float.valueOf(pageY));
        page.disablePosition();
        if (this.param.getFontPath() != null && this.param.getFontPath().length() > 0) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    private void writeBorder(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleRow row) throws IOException {
        XEasyPdfHandler.Rect.build(this.param.getWidth().floatValue(), this.param.getHeight().floatValue(), row.getParam().getBeginX().floatValue(), row.getParam().getBeginY().floatValue()).setContentMode(this.param.getContentMode()).setBackgroundColor(this.param.getBackgroundColor()).setBorderColor(this.param.getBorderColor()).setBorderWidth(this.param.getBorderWidth()).setNewLine(false).setHasBorder(true).disableCheckPage().draw(document, page);
    }

    void initText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleRow row, XEasyPdfText text) {
        float width = this.param.getWidth().floatValue() - this.param.getBorderWidth() * 2.0f;
        text.setContentMode(this.param.getContentMode()).setWidth(width).setFont(this.param.getFont()).setFontSize(this.param.getFontSize().floatValue()).setFontColor(this.param.getFontColor()).setStyle(text.isUseSelfStyle() ? text.getStyle() : this.param.getStyle().getTextStyle()).enableChildComponent();
    }

    void initImage(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleRow row, XEasyPdfImage image) throws IOException {
        float width = image.getWidth(document, page);
        float height = image.getHeight(document, page);
        image.setContentMode(this.param.getContentMode()).setWidth(width - this.param.getBorderWidth() * 2.0f).setMaxWidth(this.param.getWidth().floatValue() - this.param.getBorderWidth() * 2.0f).setHeight(height - this.param.getBorderWidth() * 2.0f).setStyle(image.isUseSelfStyle() ? image.getStyle() : this.param.getStyle().getImageStyle());
    }
}

