/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table.simple;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableStyle;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleCell;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleRowParam;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleTable;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfSimpleRow {
    private final XEasyPdfSimpleRowParam param = new XEasyPdfSimpleRowParam();

    public XEasyPdfSimpleRow(XEasyPdfSimpleCell ... cells) {
        Collections.addAll(this.param.getCells(), cells);
    }

    public XEasyPdfSimpleRow(List<XEasyPdfSimpleCell> cellList) {
        this.param.getCells().addAll(cellList);
    }

    public XEasyPdfSimpleRow setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfSimpleRow setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfSimpleRow setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfSimpleRow setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleRow setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSimpleRow setStyle(XEasyPdfTableStyle style) {
        this.param.setStyle(style);
        return this;
    }

    public XEasyPdfSimpleRow setHeight(float height) {
        this.param.setHeight(Float.valueOf(height));
        return this;
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public XEasyPdfSimpleRow addCell(XEasyPdfSimpleCell ... cells) {
        Collections.addAll(this.param.getCells(), cells);
        return this;
    }

    public XEasyPdfSimpleRow addCell(List<XEasyPdfSimpleCell> cellList) {
        this.param.getCells().addAll(cellList);
        return this;
    }

    XEasyPdfSimpleRowParam getParam() {
        return this.param;
    }

    void init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleTable table) throws IOException {
        this.param.init(document, page, table, this);
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleTable table) throws IOException {
        this.init(document, page, table);
        List<XEasyPdfSimpleCell> cells = this.param.getCells();
        for (XEasyPdfSimpleCell cell : cells) {
            if (cell == null) continue;
            this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + cell.getParam().getMarginLeft().floatValue()));
            cell.doDraw(document, page, this);
            this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + cell.getParam().getWidth().floatValue() - 1.0f));
        }
        page.getParam().setPageY(this.param.getBeginY());
        if (this.param.getFontPath() != null && this.param.getFontPath().length() > 0) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }
}

