/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table.simple;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableStyle;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleCell;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleRow;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleTable;
import wiki.xsx.core.pdf.component.table.simple.XEasyPdfSimpleTableParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfSimpleRowParam {
    private XEasyPdfComponent.ContentMode contentMode;
    private List<XEasyPdfSimpleCell> cells = new ArrayList<XEasyPdfSimpleCell>(10);
    private boolean hasBorder = false;
    private float borderWidth = 0.0f;
    private Float marginLeft;
    private Float marginTop = Float.valueOf(0.0f);
    private Float height;
    private Float beginX;
    private Float beginY;
    private String fontPath;
    private PDFont font;
    private Float fontSize;
    private XEasyPdfTableStyle style;

    void init(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfSimpleTable table, XEasyPdfSimpleRow row) throws IOException {
        if (!this.cells.isEmpty()) {
            float currentY;
            XEasyPdfSimpleTableParam tableParam = table.getParam();
            this.hasBorder = tableParam.isHasBorder();
            if (this.hasBorder) {
                this.borderWidth = tableParam.getBorderWidth();
            }
            if (this.contentMode == null) {
                this.contentMode = tableParam.getContentMode();
            }
            if (this.style == null) {
                this.style = tableParam.getStyle();
            }
            if (this.font == null) {
                this.font = XEasyPdfFontUtil.getFont(document, this.fontPath, tableParam.getFont());
            }
            if (this.fontSize == null) {
                this.fontSize = Float.valueOf(tableParam.getFontSize());
            }
            float rowHeight = 0.0f;
            for (XEasyPdfSimpleCell cell : this.cells) {
                rowHeight = Math.max(rowHeight + tableParam.getBorderWidth() * 2.0f, cell.init(document, page, row));
            }
            if (this.height == null) {
                this.height = Float.valueOf(rowHeight);
            }
            PDRectangle rectangle = page.getLastPage().getMediaBox();
            Float pageY = page.getParam().getPageY();
            float footerHeight = 0.0f;
            if (page.getParam().isAllowFooter() && page.getParam().getFooter() != null) {
                footerHeight = page.getParam().getFooter().getHeight();
            }
            if ((currentY = pageY.floatValue() - this.height.floatValue() - this.marginTop.floatValue() + 1.0f) - footerHeight <= tableParam.getMarginBottom().floatValue()) {
                page.enablePosition();
                page.addNewPage(document, rectangle);
                page.disablePosition();
                if (page.getParam().getPageY() == null) {
                    page.getParam().setPageY(Float.valueOf(rectangle.getHeight() - tableParam.getMarginTop().floatValue()));
                } else {
                    page.getParam().setPageY(Float.valueOf(page.getParam().getPageY().floatValue() - tableParam.getMarginTop().floatValue()));
                }
                pageY = page.getParam().getPageY();
                currentY = pageY.floatValue() - this.height.floatValue() - this.marginTop.floatValue() + 1.0f;
            }
            this.beginY = Float.valueOf(currentY);
            if (this.beginX == null) {
                this.beginX = this.marginLeft != null ? this.marginLeft : tableParam.getMarginLeft();
            }
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public List<XEasyPdfSimpleCell> getCells() {
        return this.cells;
    }

    public boolean isHasBorder() {
        return this.hasBorder;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public XEasyPdfTableStyle getStyle() {
        return this.style;
    }

    public XEasyPdfSimpleRowParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfSimpleRowParam setCells(List<XEasyPdfSimpleCell> cells) {
        this.cells = cells;
        return this;
    }

    public XEasyPdfSimpleRowParam setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfSimpleRowParam setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public XEasyPdfSimpleRowParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfSimpleRowParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfSimpleRowParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfSimpleRowParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfSimpleRowParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfSimpleRowParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfSimpleRowParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfSimpleRowParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfSimpleRowParam setStyle(XEasyPdfTableStyle style) {
        this.style = style;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfSimpleRowParam)) {
            return false;
        }
        XEasyPdfSimpleRowParam other = (XEasyPdfSimpleRowParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasBorder() != other.isHasBorder()) {
            return false;
        }
        if (Float.compare(this.getBorderWidth(), other.getBorderWidth()) != 0) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        List<XEasyPdfSimpleCell> this$cells = this.getCells();
        List<XEasyPdfSimpleCell> other$cells = other.getCells();
        if (this$cells == null ? other$cells != null : !((Object)this$cells).equals(other$cells)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        XEasyPdfTableStyle this$style = this.getStyle();
        XEasyPdfTableStyle other$style = other.getStyle();
        return !(this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfSimpleRowParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasBorder() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getBorderWidth());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        List<XEasyPdfSimpleCell> $cells = this.getCells();
        result = result * 59 + ($cells == null ? 43 : ((Object)$cells).hashCode());
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        XEasyPdfTableStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfSimpleRowParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", cells=" + this.getCells() + ", hasBorder=" + this.isHasBorder() + ", borderWidth=" + this.getBorderWidth() + ", marginLeft=" + this.getMarginLeft() + ", marginTop=" + this.getMarginTop() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", style=" + (Object)((Object)this.getStyle()) + ")";
    }
}

